% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trig.funs.R
\name{dist.2d}
\alias{dist.2d}
\title{Computes distance between two points in Cartesian space.}
\usage{
dist.2d(x1, x2, y1, y2)
}
\arguments{
\item{x1}{Numeric; x position of coordinate 1}

\item{x2}{numeric; x position of coordinate 2}

\item{y1}{numeric; y position of coordinate 1}

\item{y2}{numeric; y position of coordinate 2}
}
\value{
A single value of the distance between p[x1,y1] and p[x2,y2]
}
\description{
Computes distance between two points in Cartesian space using simple trigonometry functions
}
\examples{
#Find the lengths of the sides of a tringle and print to plot
x <- c(0,3,2)
y <- c(0,3,0)
plot(x,y)
lines(x,y)
lines(x[c(1,3)],y[c(1,3)])
hyp <- dist.2d(x[1],x[2],y[1],y[2])
s1 <- dist.2d(x[1],x[3],y[1],y[3])
s2 <- dist.2d(x[2],x[3],y[2],y[3])
text(mean(x[1:2],mean(y[2:3])),labels=round(hyp,1))
text(mean(x[c(1,3)]),y[1]+0.25,labels=round(s1,1))
text(mean(x[c(2:3)]),mean(y[2:3]),labels=round(s2,1))
}
