% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trackeRdata.R
\name{trackeRdata}
\alias{trackeRdata}
\title{Create a trackeRdata object.}
\usage{
trackeRdata(dat, units = NULL, cycling = FALSE, sessionThreshold = 2,
  correctDistances = FALSE, country = NULL, mask = TRUE,
  fromDistances = TRUE, lgap = 30, lskip = 5, m = 11, silent = FALSE)
}
\arguments{
\item{dat}{A data frame.}

\item{units}{A data frame containing the unit of measurement for all variables. See Details.}

\item{cycling}{Logical. Do the data stem from cycling instead of running? If so, the default unit of
measurement for cadence is set to \code{rev_per_min} instead of \code{steps_per_min} and power is
imputed with \code{0}, else with \code{NA}.}

\item{sessionThreshold}{The threshold in hours for the time
difference between consecutive timestamps above which they are
considered to belong to different training sessions.}

\item{correctDistances}{Logical. Should the distances be corrected for elevation?}

\item{country}{ISO3 country code for downloading altitude data. If \code{NULL}, country is derived from
longitude and latitude.}

\item{mask}{Logical. Passed on to \code{\link[raster]{getData}}. Should only the altitudes for the specified
\code{country} be extracted (\code{TRUE}) or also those for the neighboring countries (\code{FALSE})?}

\item{fromDistances}{Logical. Should the speeds be calculated from the distance recordings
instead of taken from the speed recordings directly?}

\item{lgap}{Time in seconds corresponding to the minimal sampling rate.}

\item{lskip}{Time in seconds between the last observation before a small break
and the first imputed speed or the last imputed speed and the first
observation after a small break.}

\item{m}{Number of imputed observations in each small break.}

\item{silent}{Logical. Should warnings be generated if any of the sanity checks on the data are triggered?}
}
\description{
Create a trackeRdata object from a data frame with observations being divided in
separate training sessions. For breaks within a session observations are imputed.
}
\details{
The \code{units} argument takes a data frame with two variables named \code{variable} and \code{unit}.
    Possible options include:
    \itemize{
    \item variables \code{latitude} and \code{longitude} with unit \code{degree}
    \item variables \code{altitude}, \code{distance} with unit \code{m}, \code{km}, \code{mi} or \code{ft}
    \item variable \code{heart.rate} with unit \code{bpm}
    \item variable \code{speed} with unit \code{m_per_s}, \code{km_per_h}, \code{ft_per_min},
          \code{ft_per_s} or \code{mi_per_h}
    \item variable \code{cadence} with unit \code{steps_per_min} or \code{rev_per_min}
    \item variable \code{power} with unit \code{W} or \code{kW}.
    }
    If the argument \code{units} is \code{NULL}, the default units are used. These are the first options, i.e.,
    \code{m} for variables \code{altitude} and \code{distance}, \code{m_per_s} for variable \code{speed} as well
    as \code{W} for variable \code{power}. The default for variable \code{cadence} depends on the value of
    argument \code{cycling}.

    During small breaks within a session, e.g., because the recording device was paused,
    observations are imputed the following way:
    0 for speed, last known position for latitude, longitude and altitude,
    NA or 0 power for running or cycling session, respectively, and NA for all other
    variables. Distances are (re-)calculated based on speeds after imputation.
}
\examples{
\dontrun{
## read raw data
filepath <- system.file("extdata", "2013-06-08-090442.TCX", package = "trackeR")
run <- readTCX(file = filepath, timezone = "GMT")

## turn into trackeRdata object
run <- trackeRdata(run, units = data.frame(variable = c("latitude", "longitude",
    "altitude", "distance", "heart.rate", "speed", "cadence", "power"),
    unit = c("degree", "degree", "m", "m", "bpm", "m_per_s", "steps_per_min", "W"),
    stringsAsFactors = FALSE))

## alternatively
run <- readContainer(filepath, type = "tcx", timezone = "GMT")
}
}
\references{
Frick, H., Kosmidis, I. (2017). trackeR: Infrastructure for Running and Cycling Data from GPS-Enabled Tracking Devices in R. \emph{Journal of Statistical Software}, \bold{82}(7), 1--29. doi:10.18637/jss.v082.i07
}
\seealso{
\code{\link{readContainer}} for reading .tcx and .db3 files directly into \code{trackeRdata} objects.
}
