% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trackeRdata_zones.R
\name{zones}
\alias{zones}
\title{Time spent in training zones.}
\usage{
zones(object, session = NULL, what = c("speed", "heart.rate"),
  breaks = list(speed = 0:10, heart.rate = c(0, seq(75, 225, by = 50), 250)),
  parallel = FALSE, cores = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{\link{trackeRdata}}.}

\item{session}{A numeric vector of the sessions to be plotted, defaults to all sessions.}

\item{what}{A vector of variable names.}

\item{breaks}{A list of breakpoints between zones, corresponding to the variables in \code{what}.}

\item{parallel}{Logical. Should computation be carried out in parallel?}

\item{cores}{Number of cores for parallel computing. If NULL, the number of cores is set to the value of \code{options("corese")} (on Windows) or \code{options("mc.cores")} (elsewhere), or, if the relevant option is unspecified, to half the number of cores detected.}

\item{...}{Currently not used.}
}
\value{
An object of class \code{trackeRdataZones}.
}
\description{
Time spent in training zones.
}
\examples{
data(run, package = "trackeR")
runZones <- zones(run, what = "speed", breaks = list(speed = c(0, 2:6, 12.5)))
## if breaks is a named list, argument 'what' can be left unspecified
runZones <- zones(run, breaks = list(speed = c(0, 2:6, 12.5)))
## if only a single variable is to be evaluated, 'breaks' can also be a vector
runZones <- zones(run, what = "speed", breaks = c(0, 2:6, 12.5))
plot(runZones)
}
\seealso{
\code{\link{plot.trackeRdataZones}}
}

