% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thresholds.R
\name{threshold}
\alias{threshold}
\title{Thresholding for variables in \code{trackeRdata} objects.}
\usage{
threshold(object, variable, lower, upper, ...)
}
\arguments{
\item{object}{An object of class \code{\link{trackeRdata}}.}

\item{variable}{A vector containing the names of the variables to which thresholding is applied. See Details.}

\item{lower}{A vector containing the corresponding lower thresholds. See Details.}

\item{upper}{A vector containing the corresponding upper thresholds. See Details.}

\item{...}{Currently not used.}
}
\description{
Thresholding for variables in \code{trackeRdata} objects.
}
\details{
Argument \code{variable} can also be a data frame containing the variable names, lower, and upper thresholds.
If arguments \code{variable}, \code{lower}, and \code{upper} are all unspecified, the following default thresholds are employed: latitude [-90, 90] degrees, longitude [-180, 180] degrees, altitude [-500, 9000] m, distance [0, Inf] meters, heart rate [0, 250] bpm, power [0, Inf] W, pace [0, Inf] min per km, duration [0, Inf] seconds. The thresholds for speed differ for running, [0, 12.5] meters per second, and cycling, [0, 100] meters per second. Default thresholds are converted to the units of measurment of the \code{object} before they are applied.
}
\examples{
data(runs, package = "trackeR")
plot(runs, session = 4, what = "speed", threshold = FALSE)
runsT <- threshold(runs, variable = "speed", lower = 0, upper = 12.5)
plot(runsT, session = 4, what = "speed", threshold = FALSE)
}

