% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructors.R
\name{peak_table_to_fragments}
\alias{peak_table_to_fragments}
\title{Convert Peak Table to Fragments_repeats class}
\usage{
peak_table_to_fragments(
  df,
  data_format = NULL,
  peak_size_col = NULL,
  peak_signal_col = NULL,
  unique_id = NULL,
  dye_col = NULL,
  dye_channel = NULL,
  allele_col = NULL,
  min_size_bp = 200,
  max_size_bp = 1000
)
}
\arguments{
\item{df}{A data frame containing the peak data.}

\item{data_format}{The format that the data frame is in (for example, a genemapper peak table). Choose between: genemapper5, generic.}

\item{peak_size_col}{A character string specifying column name giving the peak size.}

\item{peak_signal_col}{A character string specifying column name giving the peak signal.}

\item{unique_id}{A character string specifying column name giving the unique sample id (often the file name).}

\item{dye_col}{Genemapper specific. A character string specifying column name indicating the dye channel.}

\item{dye_channel}{Genemapper specific. A character string indicating the channel to extract data from. For example, 6-FAM is often "B".}

\item{allele_col}{Genemapper specific. A character string specifying column name indicating the called alleles. This is often used when the peaks have been called in genemapper.}

\item{min_size_bp}{Numeric value indicating the minimum size of the peak table to import.}

\item{max_size_bp}{Numeric value indicating the maximum size of the peak table to import.}
}
\value{
A list of fragments_repeats objects.
}
\description{
This function converts a peak table data frame into a list of fragments_repeats objects.
}
\details{
This function takes a peak table data frame (eg. Genemapper output) and converts it into a list of fragment objects.
The function supports different data formats and allows specifying column names for various attributes.
}
\examples{

gm_raw <- trace::example_data

test_fragments <- peak_table_to_fragments(
  gm_raw,
  data_format = "genemapper5",
  dye_channel = "B",
  min_size_bp = 400
)

}
\seealso{
\code{\link{repeat_table_to_repeats}}
}
