% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_tcpl_based.R
\name{fit_curve_tcpl}
\alias{fit_curve_tcpl}
\title{fit dose-resopnse curve using tcpl hill model}
\usage{
fit_curve_tcpl(df, assay_info, prim_cutoff = 20, toxi_cutoff = 20)
}
\arguments{
\item{df}{input data contain normalized assay readings}

\item{assay_info}{predefined names for primary and cytotoxicity assays,
use NULL if either one of the assay does not need to be modeled.}

\item{prim_cutoff}{significance cutoff for primary assay (eg. 3sigma or 3bMAD)}

\item{toxi_cutoff}{significance cutoff for cytotoxicity assay (eg. 3sigma or 3bMAD)}
}
\value{
A list object containing modeling results, the corresponding data for each chemical.
}
\description{
Curve fitting using the tcplFit function in `tcpl` package.
Chemicals are modelled based on spid.
If you want to model the same chemical (e.g. positive controls),
then assign different spid to this chemical so the function can separate them out.
Absolute IC20 and absolute IC50 are calculated as well.
}
\examples{
## fit curve with default significant threshold 20

demo_md <- fit_curve_tcpl(mc_norm, assay_info =
list(prim_assay = "Primary", toxi_assay = "Cytotox"))

## start from raw data
# define assay
assay_info <- list(prim_assay = "Primary",toxi_assay = "Cytotox")
# data normalization
demo_mc_norm <- normalize_per_plate(demo_mc, nctrl = "DMSO")
# filter out two test chemicals
demo_mc_norm <- dplyr::filter(demo_mc_norm, spid \%in\% c("TP0001502B05", "TP0001502B01"))
# fit curve with default 20\% threshold
demo_md <- fit_curve_tcpl(demo_mc_norm, assay_info)

## fit curve with specified significance threshold
demo_md <- fit_curve_tcpl(demo_mc_norm, assay_info, prim_cutoff = 25, toxi_cutoff = 25)


}
