% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toxEval.R
\docType{data}
\name{ToxCast_ACC}
\alias{ToxCast_ACC}
\title{ACC values included with toxEval.}
\source{
\url{https://www.epa.gov/chemical-research/toxicity-forecaster-toxcasttm-data}
}
\value{
data frame with columns CAS, chnm (chemical name), flags, endPoint, and ACC (value).
}
\description{
Downloaded on October 2015 from ToxCast. The data were
combined from files in the "INVITRODB_V2_LEVEL5" folder. 
At the time of toxEval package release, this information was found:
\url{https://www.epa.gov/chemical-research/toxicity-forecaster-toxcasttm-data}
in the "ToxCast & Tox21 Data Spreadsheet" data set. 
ACC values are the in the "ACC" column (winning model) and units are 
log micro-Molarity (log \eqn{\mu}M).
}
\examples{
ACCColumnNames <- names(ToxCast_ACC)
}
\references{
U.S. EPA. 2015. ToxCast & Tox21 Summary Files from invitrodb_v2. 
Retrieved from \url{https://www.epa.gov/chemical-research/toxicity-forecaster-toxcasttm-data}
on October 28, 2015. Data released October 2015.
}
\keyword{datasets}
