% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deleteAndRenameDuplicates.R
\name{deleteAndRenameDuplicates}
\alias{deleteAndRenameDuplicates}
\title{Deletes and Renames Articles with the same ID}
\usage{
deleteAndRenameDuplicates(object, paragraph = FALSE)
}
\arguments{
\item{object}{A \code{textmeta} object as a result of a read-function.}

\item{paragraph}{Logical: Should be set to \code{TRUE} if the article is a
list of character strings, representing the paragraphs.}
}
\value{
A filtered \code{textmeta} object with updated IDs.
}
\description{
Deletes articles with the same ID and same text. Renames the ID of articles
with the same ID but different text-component (_IDFakeDup, _IDRealDup).
}
\details{
Summary: Different types of duplicates:
 "complete duplicates" = same ID, same information in text, same information in meta
 "real duplicates" = same ID, same information in text, different information in meta
 "fake duplicates" = same ID, different information in text
}
\examples{
texts <- list(A="Give a Man a Fish, and You Feed Him for a Day.
Teach a Man To Fish, and You Feed Him for a Lifetime",
A="A fake duplicate",
B="So Long, and Thanks for All the Fish",
B="So Long, and Thanks for All the Fish",
C="A very able manipulative mathematician, Fisher enjoys a real mastery
in evaluating complicated multiple integrals.",
C="A very able manipulative mathematician, Fisher enjoys a real mastery
in evaluating complicated multiple integrals.")

corpus <- textmeta(meta=data.frame(id=c("A", "A", "B", "B", "C", "C"),
title=c("Fishing", "Fake duplicate", "Don't panic!", "towel day", "Sir Ronald", "Sir Ronald"),
date=c("1885-01-02", "1885-01-03", "1979-03-04", "1979-03-05", "1951-05-06", "1951-05-06"),
stringsAsFactors=FALSE), text=texts)

duplicates <- deleteAndRenameDuplicates(object=corpus)
duplicates$meta$id
}
