% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models-resnet.R
\name{model_resnet}
\alias{model_resnet}
\alias{model_resnet18}
\alias{model_resnet34}
\alias{model_resnet50}
\alias{model_resnet101}
\alias{model_resnet152}
\alias{model_resnext50_32x4d}
\alias{model_resnext101_32x8d}
\alias{model_wide_resnet50_2}
\alias{model_wide_resnet101_2}
\title{ResNet implementation}
\usage{
model_resnet18(pretrained = FALSE, progress = TRUE, ...)

model_resnet34(pretrained = FALSE, progress = TRUE, ...)

model_resnet50(pretrained = FALSE, progress = TRUE, ...)

model_resnet101(pretrained = FALSE, progress = TRUE, ...)

model_resnet152(pretrained = FALSE, progress = TRUE, ...)

model_resnext50_32x4d(pretrained = FALSE, progress = TRUE, ...)

model_resnext101_32x8d(pretrained = FALSE, progress = TRUE, ...)

model_wide_resnet50_2(pretrained = FALSE, progress = TRUE, ...)

model_wide_resnet101_2(pretrained = FALSE, progress = TRUE, ...)
}
\arguments{
\item{pretrained}{(bool): If TRUE, returns a model pre-trained on ImageNet.}

\item{progress}{(bool): If TRUE, displays a progress bar of the download to
stderr.}

\item{...}{Other parameters passed to the resnet model.}
}
\description{
ResNet models implementation from
\href{https://arxiv.org/pdf/1512.03385.pdf}{Deep Residual Learning for Image Recognition} and later
related papers (see Functions)
}
\section{Functions}{
\itemize{
\item \code{model_resnet18}: ResNet 18-layer model

\item \code{model_resnet34}: ResNet 34-layer model

\item \code{model_resnet50}: ResNet 50-layer model

\item \code{model_resnet101}: ResNet 101-layer model

\item \code{model_resnet152}: ResNet 152-layer model

\item \code{model_resnext50_32x4d}: ResNeXt-50 32x4d model from \href{https://arxiv.org/pdf/1611.05431.pdf}{"Aggregated Residual Transformation for Deep Neural Networks"}
with 32 groups having each a width of 4.

\item \code{model_resnext101_32x8d}: ResNeXt-101 32x8d model from \href{https://arxiv.org/pdf/1611.05431.pdf}{"Aggregated Residual Transformation for Deep Neural Networks"}
with 32 groups having each a width of 8.

\item \code{model_wide_resnet50_2}: Wide ResNet-50-2 model from \href{https://arxiv.org/pdf/1605.07146.pdf}{"Wide Residual Networks"}
with width per group of 128.

\item \code{model_wide_resnet101_2}: Wide ResNet-101-2 model from \href{https://arxiv.org/pdf/1605.07146.pdf}{"Wide Residual Networks"}
with width per group of 128.
}}

\seealso{
Other models: 
\code{\link{model_alexnet}()},
\code{\link{model_mobilenet_v2}()}
}
\concept{models}
