% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_nansum}
\alias{torch_nansum}
\title{Nansum}
\usage{
torch_nansum(self, dim, keepdim = FALSE, dtype = NULL)
}
\arguments{
\item{self}{(Tensor) the input tensor.}

\item{dim}{(int or tuple of ints) the dimension or dimensions to reduce.}

\item{keepdim}{(bool) whether the output tensor has \code{dim} retained or not.}

\item{dtype}{the desired data type of returned tensor. If specified, the
input tensor is casted to dtype before the operation is performed. This is
useful for preventing data type overflows. Default: \code{NULL}.}
}
\description{
Nansum
}
\section{nansum(input, *, dtype=None) -> Tensor }{


Returns the sum of all elements, treating Not a Numbers (NaNs) as zero.
}

\section{nansum(input, dim, keepdim=FALSE, *, dtype=None) -> Tensor }{


Returns the sum of each row of the \code{input} tensor in the given
dimension \code{dim}, treating Not a Numbers (NaNs) as zero.
If \code{dim} is a list of dimensions, reduce over all of them.

If \code{keepdim} is \code{TRUE}, the output tensor is of the same size
as \code{input} except in the dimension(s) \code{dim} where it is of size 1.
Otherwise, \code{dim} is squeezed (see \code{\link{torch_squeeze}}), resulting in the
output tensor having 1 (or \code{len(dim)}) fewer dimension(s).
}

\examples{
if (torch_is_installed()) {

a <- torch_tensor(c(1., 2., NaN, 4.))
torch_nansum(a)


torch_nansum(torch_tensor(c(1., NaN)))
a <- torch_tensor(rbind(c(1, 2), c(3., NaN)))
torch_nansum(a)
torch_nansum(a, dim=1)
torch_nansum(a, dim=2)
}
}
