% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-data-dataloader.R
\name{dataloader}
\alias{dataloader}
\title{Data loader. Combines a dataset and a sampler, and provides
single- or multi-process iterators over the dataset.}
\usage{
dataloader(
  dataset,
  batch_size = 1,
  shuffle = FALSE,
  sampler = NULL,
  batch_sampler = NULL,
  num_workers = 0,
  collate_fn = NULL,
  pin_memory = FALSE,
  drop_last = FALSE,
  timeout = -1,
  worker_init_fn = NULL
)
}
\arguments{
\item{dataset}{(Dataset): dataset from which to load the data.}

\item{batch_size}{(int, optional): how many samples per batch to load
(default: \code{1}).}

\item{shuffle}{(bool, optional): set to \code{TRUE} to have the data reshuffled
at every epoch (default: \code{FALSE}).}

\item{sampler}{(Sampler, optional): defines the strategy to draw samples from
the dataset. If specified, \code{shuffle} must be False.}

\item{batch_sampler}{(Sampler, optional): like sampler, but returns a batch of
indices at a time. Mutually exclusive with \code{batch_size},
\code{shuffle}, \code{sampler}, and \code{drop_last}.}

\item{num_workers}{(int, optional): how many subprocesses to use for data
loading. 0 means that the data will be loaded in the main process.
(default: \code{0})}

\item{collate_fn}{(callable, optional): merges a list of samples to form a mini-batch.}

\item{pin_memory}{(bool, optional): If \code{TRUE}, the data loader will copy tensors
into CUDA pinned memory before returning them.  If your data elements
are a custom type, or your \code{collate_fn} returns a batch that is a custom type
see the example below.}

\item{drop_last}{(bool, optional): set to \code{TRUE} to drop the last incomplete batch,
if the dataset size is not divisible by the batch size. If \code{FALSE} and
the size of dataset is not divisible by the batch size, then the last batch
will be smaller. (default: \code{FALSE})}

\item{timeout}{(numeric, optional): if positive, the timeout value for collecting a batch
from workers. -1 means no timeout. (default: \code{-1})}

\item{worker_init_fn}{(callable, optional): If not \code{NULL}, this will be called on each
worker subprocess with the worker id (an int in \verb{[1, num_workers]}) as
input, after seeding and before data loading. (default: \code{NULL})}
}
\description{
Data loader. Combines a dataset and a sampler, and provides
single- or multi-process iterators over the dataset.
}
