% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-normalization.R
\name{nn_group_norm}
\alias{nn_group_norm}
\title{Group normalization}
\usage{
nn_group_norm(num_groups, num_channels, eps = 1e-05, affine = TRUE)
}
\arguments{
\item{num_groups}{(int): number of groups to separate the channels into}

\item{num_channels}{(int): number of channels expected in input}

\item{eps}{a value added to the denominator for numerical stability. Default: 1e-5}

\item{affine}{a boolean value that when set to \code{TRUE}, this module
has learnable per-channel affine parameters initialized to ones (for weights)
and zeros (for biases). Default: \code{TRUE}.}
}
\description{
Applies Group Normalization over a mini-batch of inputs as described in
the paper \href{https://arxiv.org/abs/1803.08494}{Group Normalization}.
}
\details{
\deqn{
  y = \frac{x - \mathrm{E}[x]}{ \sqrt{\mathrm{Var}[x] + \epsilon}} * \gamma + \beta
}

The input channels are separated into \code{num_groups} groups, each containing
\code{num_channels / num_groups} channels. The mean and standard-deviation are calculated
separately over the each group. \eqn{\gamma} and \eqn{\beta} are learnable
per-channel affine transform parameter vectors of size \code{num_channels} if
\code{affine} is \code{TRUE}.
The standard-deviation is calculated via the biased estimator, equivalent to
\code{torch_var(input, unbiased=FALSE)}.
}
\note{
This layer uses statistics computed from input data in both training and
evaluation modes.
}
\section{Shape}{

\itemize{
\item Input: \eqn{(N, C, *)} where \eqn{C=\mbox{num\_channels}}
\item Output: \eqn{(N, C, *)}` (same shape as input)
}
}

\examples{
if (torch_is_installed()) {

input <- torch_randn(20, 6, 10, 10)
# Separate 6 channels into 3 groups
m <- nn_group_norm(3, 6)
# Separate 6 channels into 6 groups (equivalent with [nn_instance_morm])
m <- nn_group_norm(6, 6)
# Put all 6 channels into a single group (equivalent with [nn_layer_norm])
m <- nn_group_norm(1, 6)
# Activating the module
output <- m(input)
}
}
