% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R
\name{torch_zeros_like}
\alias{torch_zeros_like}
\title{Zeros_like}
\arguments{
\item{input}{(Tensor) the size of \code{input} will determine size of the output tensor.}

\item{dtype}{(\code{torch.dtype}, optional) the desired data type of returned Tensor.        Default: if \code{None}, defaults to the dtype of \code{input}.}

\item{layout}{(\code{torch.layout}, optional) the desired layout of returned tensor.        Default: if \code{None}, defaults to the layout of \code{input}.}

\item{device}{(\code{torch.device}, optional) the desired device of returned tensor.        Default: if \code{None}, defaults to the device of \code{input}.}

\item{requires_grad}{(bool, optional) If autograd should record operations on the        returned tensor. Default: \code{False}.}

\item{memory_format}{(\code{torch.memory_format}, optional) the desired memory format of        returned Tensor. Default: \code{torch_preserve_format}.}
}
\description{
Zeros_like
}
\section{zeros_like(input, dtype=None, layout=None, device=None, requires_grad=False, memory_format=torch.preserve_format) -> Tensor }{


Returns a tensor filled with the scalar value \code{0}, with the same size as
\code{input}. \code{torch_zeros_like(input)} is equivalent to
\code{torch_zeros(input.size(), dtype=input.dtype, layout=input.layout, device=input.device)}.
}

\section{Warning}{

As of 0.4, this function does not support an \code{out} keyword. As an alternative,
the old \code{torch_zeros_like(input, out=output)} is equivalent to
\code{torch_zeros(input.size(), out=output)}.
}

\examples{
if (torch_is_installed()) {

input = torch_empty(c(2, 3))
torch_zeros_like(input)
}
}
