% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R
\name{torch_cosine_similarity}
\alias{torch_cosine_similarity}
\title{Cosine_similarity}
\arguments{
\item{x1}{(Tensor) First input.}

\item{x2}{(Tensor) Second input (of size matching x1).}

\item{dim}{(int, optional) Dimension of vectors. Default: 1}

\item{eps}{(float, optional) Small value to avoid division by zero.        Default: 1e-8}
}
\description{
Cosine_similarity
}
\section{cosine_similarity(x1, x2, dim=1, eps=1e-8) -> Tensor }{


Returns cosine similarity between x1 and x2, computed along dim.

\deqn{
    \mbox{similarity} = \frac{x_1 \cdot x_2}{\max(\Vert x_1 \Vert _2 \cdot \Vert x_2 \Vert _2, \epsilon)}
}
}

\examples{
if (torch_is_installed()) {

input1 = torch_randn(c(100, 128))
input2 = torch_randn(c(100, 128))
output = torch_cosine_similarity(input1, input2)
output
}
}
