% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R
\name{torch_normal}
\alias{torch_normal}
\title{Normal}
\arguments{
\item{mean}{(Tensor) the tensor of per-element means}

\item{std}{(Tensor) the tensor of per-element standard deviations}

\item{generator}{(\code{torch.Generator}, optional) a pseudorandom number generator for sampling}

\item{out}{(Tensor, optional) the output tensor.}

\item{size}{(int...) a sequence of integers defining the shape of the output tensor.}
}
\description{
Normal
}
\note{
When the shapes do not match, the shape of \code{mean}
is used as the shape for the returned output tensor
}
\section{normal(mean, std, *, generator=None, out=None) -> Tensor }{


Returns a tensor of random numbers drawn from separate normal distributions
whose mean and standard deviation are given.

The \code{mean} is a tensor with the mean of
each output element's normal distribution

The \code{std} is a tensor with the standard deviation of
each output element's normal distribution

The shapes of \code{mean} and \code{std} don't need to match, but the
total number of elements in each tensor need to be the same.
}

\section{normal(mean=0.0, std, out=None) -> Tensor }{


Similar to the function above, but the means are shared among all drawn
elements.
}

\section{normal(mean, std=1.0, out=None) -> Tensor }{


Similar to the function above, but the standard-deviations are shared among
all drawn elements.
}

\section{normal(mean, std, size, *, out=None) -> Tensor }{


Similar to the function above, but the means and standard deviations are shared
among all drawn elements. The resulting tensor has size given by \code{size}.
}

\examples{
if (torch_is_installed()) {

\dontrun{
torch_normal(mean=0, std=torch_arange(1, 0, -0.1))


torch_normal(mean=0.5, std=torch_arange(1., 6.))


torch_normal(mean=torch_arange(1., 6.))


torch_normal(2, 3, size=list(1, 4))
}
}
}
