% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_csv.R
\name{load_csv}
\alias{load_csv}
\alias{load_tsv}
\alias{load_rds}
\alias{load_rdata}
\title{Load each element of a list into an environment.}
\usage{
load_csv(path = ".", regexp = "[.]csv$", ignore.case = TRUE,
  invert = FALSE, envir = .GlobalEnv, ...)

load_tsv(path = ".", regexp = "[.]tsv$", ignore.case = TRUE,
  invert = FALSE, envir = .GlobalEnv, ...)

load_rds(path = ".", regexp = "[.]rds$", ignore.case = TRUE,
  invert = FALSE, envir = .GlobalEnv)

load_rdata(path = ".", regexp = "[.]rdata$|[.]rda$",
  ignore.case = TRUE, invert = FALSE, envir = .GlobalEnv)
}
\arguments{
\item{path}{A character vector of one or more paths.}

\item{regexp}{A regular expression (e.g. \code{[.]csv$}) passed on to \code{\link[=grep]{grep()}} to filter paths.}

\item{ignore.case}{if \code{FALSE}, the pattern matching is \emph{case
      sensitive} and if \code{TRUE}, case is ignored during matching.}

\item{invert}{If \code{TRUE} return files which do \emph{not} match}

\item{envir}{an \code{\link{environment}} or \code{NULL}.}

\item{...}{Arguments passed to \code{readr::read_csv()} or \code{readr::read_tsv()}.}
}
\value{
\code{invisible(path)}.
}
\description{
Load each element of a list into an environment.
}
\examples{
(path_csv <- tor_example("csv"))
dir(path_csv)

load_csv(path_csv)
# Each dataframe is now available in the global environment
csv1
csv2

(path_mixed <- tor_example("mixed"))
dir(path_mixed)

load_rdata(path_mixed)
# Each dataframe is now available in the global environment
lower_rdata
upper_rdata
}
\seealso{
Other general functions to import data: \code{\link{list_any}},
  \code{\link{list_csv}}
}
\concept{general functions to import data}
