% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print_topsa}
\alias{print_topsa}
\title{print \code{topsa} objects}
\usage{
print_topsa(topsaObj, only.return.table = FALSE, ...)
}
\arguments{
\item{topsaObj}{an object of class \code{topsa}}

\item{only.return.table}{if \code{TRUE}, returns a data frame with the
estimated values. Otherwise, print the data frame in console. Defaults to
\code{FALSE}}

\item{...}{further arguments passed to the \code{plot} function}
}
\value{
Print the threshold used, the box area, manifold embedding area, geometric
correlation index and symmetric sensitivity index for and object of class
\code{topsa}.
}
\description{
Print method for objects of class \code{topsa}.
}
\examples{

ishigami.fun <- function(X) {
A <- 7
B <- 0.1
sin(X[, 1]) + A * sin(X[, 2])^2 + B * X[, 3]^4 * sin(X[, 1])
}

X <- matrix(runif(3*50, -pi, pi), ncol = 3)
Y <- ishigami.fun(X)

estimation <- topsa(Ydat = Y, Xdat = X)

print(estimation)
}
