% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprec_funcs.R
\name{get_best_snp_per_MB}
\alias{get_best_snp_per_MB}
\title{Get the index/lead variants}
\usage{
get_best_snp_per_MB(
  df,
  thresh = 5e-09,
  region_size = 1e+06,
  protein_coding_only = FALSE,
  chr = NULL,
  .checked = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{df}{Dataframe}

\item{thresh}{A number. P-value threshold, only extract variants with p-values below this threshold (5e-09 by default)}

\item{region_size}{An integer (default = 20000000) (or a string represented as 200kb or 2MB) indicating the window size for variant labeling. Increase this number for sparser annotation and decrease for denser annotation.}

\item{protein_coding_only}{Logical, set this variable to TRUE to only use protein_coding genes for annotation}

\item{chr}{String, get the top variants from one chromosome only, e.g. chr="chr1"}

\item{.checked}{Logical, if the input data has already been checked, this can be set to TRUE so it wont be checked again (FALSE by default)}

\item{verbose}{Logical, set to TRUE to get printed information on number of SNPs extracted}
}
\value{
Dataframe of lead variants. Returns the best variant per MB (by default, change the region size with the region argument) with p-values below the input threshold (thresh=5e-09 by default)
}
\description{
\code{get_best_snp_per_MB()} Get the top variants within 1 MB windows of the genome with association p-values below the given threshold

This method is deprecated and will be removed in future versions. use \code{\link{get_lead_snps}} instead.
}
