% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformations.R
\name{dist_to_titer_table}
\alias{dist_to_titer_table}
\title{Convert Distance Matrix to Titer Panel Format}
\usage{
dist_to_titer_table(input_matrix, base = exp(1), tens = 1)
}
\arguments{
\item{input_matrix}{Matrix of distances, with row/column names prefixed with
"V/" for antigens and "S/" for sera}

\item{base}{Numeric. Base for logarithmic transformation. Default exp(1). For HI Assay 2}

\item{tens}{Numeric. Scaling factor for final titers. Default 1. For HI Assay 10}
}
\value{
A \code{matrix} of titers with:
\itemize{
\item Rows corresponding to antigen strains (without "V/" prefix)
\item Columns corresponding to antisera (without "S/" prefix)
\item Values as character strings including threshold indicators where applicable
\item \code{NA} values replaced with "*"
}
}
\description{
Converts a distance matrix to a titer panel format, handling threshold measurements
and logarithmic transformations common in antigenic cartography. The function
identifies reference points (typically antisera) and challenge points (typically
antigens) based on row/column name prefixes.
}
\details{
The function:
\enumerate{
\item Identifies antigen and serum entries from matrix row/column names
\item Creates titer table from antigen-serum pairs
\item Handles threshold indicators (< and >) in distance values
\item Applies appropriate transformations to convert distances to titers
}

Transformation steps:
\enumerate{
\item Extract numeric values from thresholded measurements
\item Convert distances to titers via logarithmic transformation
\item Apply scaling factor
\item Reapply threshold indicators to transformed values
}
}
\examples{
# Create sample distance matrix
dist_mat <- matrix(c(0, 2, ">3", 2, 0, 4, "3", 4, 0), nrow=3)
rownames(dist_mat) <- c("V/strain1", "V/strain2", "S/serum1")
colnames(dist_mat) <- c("V/strain1", "V/strain2", "S/serum1")

# Convert to titer panel
titer_panel <- dist_to_titer_table(dist_mat)

}
