% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.tna_data}
\alias{print.tna_data}
\title{Print a TNA data object}
\usage{
\method{print}{tna_data}(x, data = "sequence", ...)
}
\arguments{
\item{x}{A \code{tna_data} object.}

\item{data}{A \code{character} string that defines the data to be printed
tibble. Accepts either \code{"sequence"} (default) for wide format sequence data,
\code{"meta"}, for the wide format metadata, or \code{"long"} for the long format
data.}

\item{...}{Arguments passed to the tibble \code{print} method.}
}
\value{
\code{x} (invisibly).
}
\description{
Print a TNA data object
}
\examples{
data_single_session <- tibble::tibble(
  action = c(
    "view", "click", "add_cart", "view", "checkout", "view", "click", "share"
   )
)
results_single <- prepare_data(data_single_session, action = "action")
print(results_single, which = "sequence")
print(results_single, which = "meta")
print(results_single, which = "long")

}
