% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.tna_bootstrap}
\alias{print.tna_bootstrap}
\title{Print Bootstrap Results}
\usage{
\method{print}{tna_bootstrap}(x, digits = getOption("digits"), type = "both", ...)
}
\arguments{
\item{x}{A \code{tna_bootstrap} object.}

\item{digits}{An \code{integer} giving the minimal number of
\emph{significant} digits to print.}

\item{type}{A \code{character} vector giving the type of edges to print.
The default option \code{"both"} prints both statistically significant and
non-significant edges, \code{"sig"} prints only significant edges, and \code{"nonsig"}
prints only the non-significant edges.}

\item{...}{Ignored.}
}
\value{
\code{x} (invisibly).
}
\description{
Print Bootstrap Results
}
\examples{
model <- tna(engagement)
# Small number of iterations for CRAN
boot <- bootstrap(model, iter = 10)
print(boot)

}
