% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmt_sim.R
\name{tmt_sim}
\alias{tmt_sim}
\title{Function for the Simulation of Multistage-Designs}
\usage{
tmt_sim(mstdesign = NULL, items = NULL, persons = NULL, mean = 0,
  sd = 1, ...)
}
\arguments{
\item{mstdesign}{definition of desired multistage design}

\item{items}{vector of difficulty parameters for each items}

\item{persons}{amount of persons per starting block}

\item{mean}{optional mean for person parameter; default = 0}

\item{sd}{optional sd for person parameter; default = 1}

\item{...}{further optional arguments like \code{set.seed}}
}
\value{
List with following entries

 \item{data}{Matrix with item responses}
 \item{data_mst}{Data frame with item responses and additional a vector of used blocks per person}
 \item{persons}{Generated and used person parameters}
 \item{mstdesign}{Submitted multistage design}
}
\description{
This function simulates data after a multistage design. The subjects are drawn from a normal 
distribution with specified mean and standard deviation (default N (0,1)). As an additional argument, 
a seed can also be passed.
}
\examples{
#############################################################################
# translate multistage model 1
#############################################################################
 mstdesign <- "
	 B1 =~ c(i1, i2, i3, i4, i5)
	 B2 =~ c(i6, i7, i8, i9, i10)
	 B3 =~ c(i11, i12, i13, i14, i15)

	 # define starting Block
	 Start == B2

	 # define branches
	 b1 := Start(0,2) + B1
	 b2 := Start(3,5) + B3
 "
items <- seq(-3,3,length.out = 15)
names(items) <- paste0("i",1:15)

persons = 500
set.seed(1111)
data_1 <- tmt_sim(mstdesign = mstdesign, 
    items = items, 
    persons = persons, 
    mean = 0, 
    sd = 1)

#############################################################################
# translate multistage model 2
#############################################################################
mstdesign <- "
    B1 =~ c(i1, i2, i3, i4, i5)
    B2 =~ c(i6, i7, i8, i9, i10)
    B3 =~ c(i11, i12, i13, i14, i15)
    B4 =~ c(i16, i17, i18, i19, i20)
    B5 =~ c(i21, i22, i23, i24, i25)
    B6 =~ c(i26, i27, i28, i29, i30)

    # define starting Block
    Start == B4

    # define branches
    b1 := Start(0,2) + B2(0,2) + B1
    b2 := Start(0,2) + B2(3,5) + B3
    b3 := Start(3,5) + B5(0,2) + B3
    b4 := Start(3,5) + B5(3,5) + B6
  "

items <- seq(-3,3,length.out = 30)
names(items) <- paste0("i",1:30)
persons = 500
set.seed(1111)
data_2 <- tmt_sim(mstdesign = mstdesign, 
    items = items, 
    persons = persons, 
    mean = 0, 
    sd = 1)
}
\author{
Jan Steinfeld
}
