% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmt_lrtest.R
\name{tmt_lrtest}
\alias{tmt_lrtest}
\title{Computation of Andersen's Likelihood-Ratio Test}
\usage{
tmt_lrtest(object, split = "median", cores = NULL, se = TRUE, ...)
}
\arguments{
\item{object}{it is necessary to submit an object of the function \code{mst} or \code{nmst}}

\item{split}{default is the split criteria "median" of the raw score, optional are "mean" or any dichotomouse vector}

\item{cores}{submit integer of cores you would like to apply}

\item{se}{logical: if true, the standard error is estimated}

\item{\ldots}{further arguments for the \code{tmt_rm} function}
}
\value{
List with following entries

	\item{data_orig}{Submitted data frame with item responses}
	\item{betapars_subgroup}{List of item parameters (difficulty) for each subgroup}
	\item{se.beta_subgroup}{List of standard errors of the estimated item parameters}
	\item{model}{Used model ((mst) for Rasch model with multistage design)}
	\item{LRvalue}{LR-value}
	\item{df}{Degrees of freedoms for the test statistic}
	\item{pvalue}{P-value of the likelihood ratio test}
	\item{loglik_subgroup}{Log-likelihoods for the subgroups}
	\item{split_subgroup}{List of split vector for each subgroup}
	\item{call}{Submitted arguments for the function (matched call)}
	\item{fitobj}{List of objects from subgroup estimation}
}
\description{
This function applies the Likelihood Ratio Test of Andersen. Note that all persons with raw score equal to "median" are assigned to lower group. Is is also allowed to split after "mean" or submit any dichotomous vector.
}
\examples{
# example for tmt_lrtest
#############################################################################
# Example Rasch model and Likelihood Ratio Test
#############################################################################
dat <- tmt:::sim.rm(theta = 100, b = 10, seed = 1111)
dat.rm <- tmt_rm(dat = dat)
dat.lrt <- tmt_lrtest(dat.rm)
summary(dat.lrt)
}
\references{
\itemize{
 \item Andersen, E. B. (1973). A goodness of fit test for the Rasch model. \emph{Psychometrika}, 38(1), 123-140.
 \item Fischer, G. H., & Molenaar, I. W. (Eds.). (2012). \emph{Rasch models: Foundations, recent developments, and applications}. 
	    Springer Science & Business Media.
}
}
\seealso{
\code{\link{tmt_rm}}
}
\author{
Jan Steinfeld
}
