% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tmlenet.R
\name{eval.summaries}
\alias{eval.summaries}
\title{Evaluate Summary Measures sA and sW}
\usage{
eval.summaries(data, Kmax, sW, sA, IDnode = NULL, NETIDnode = NULL,
  sep = " ", NETIDmat = NULL, verbose = getOption("tmlenet.verbose"))
}
\arguments{
\item{data}{Same as \code{\link{tmlenet}} input argument.}

\item{Kmax}{Same as \code{\link{tmlenet}} input argument.}

\item{sW}{Same as \code{\link{tmlenet}} input argument.}

\item{sA}{Same as \code{\link{tmlenet}} input argument.}

\item{IDnode}{(Optional) Same as \code{\link{tmlenet}} input argument.}

\item{NETIDnode}{(Optional) Same as \code{\link{tmlenet}} input argument.}

\item{sep}{Optional friend ID character separator for friends listed in \code{NETIDnode} column of \code{data}, default is \code{' '};
same as \code{\link{tmlenet}} input argument \code{optPars$sep}.}

\item{NETIDmat}{(Optional) Same as \code{\link{tmlenet}} input argument.}

\item{verbose}{Set to \code{TRUE} to print messages on status and information to the console.
Turn this on by default using \code{options(tmlenet.verbose=TRUE)}.}
}
\value{
A named list that contains:
 \itemize{
 \item \code{sW.matrix} - Matrix of evaluated summary measures for \code{sW}.
 \item \code{sA.matrix} - Matrix of evaluated summary measures for \code{sA}.
 \item \code{NETIDmat} - Network ID matrix that can be used for \code{NETIDmat} input argument to \code{tmlenet}.
 \item \code{DatNet.ObsP0} - R6 object of class \code{\link{DatNet.sWsA}} that stores all the summary measures and the network information.
   This object be passed to \code{\link{tmlenet}} as an argument, in which case the arguments already provided to \code{eval.summaries} no
   longer need to be specified to \code{tmlenet}.
 }
}
\description{
Take input data, create a network matrix (when input network matrix not provided) and evaluate the summary measures
 previously defined with functions \code{\link{def.sW}} and \code{\link{def.sA}}.
 This function is called internally by \code{tmlenet} for the evaluation of the summary measures.
 The R6 class object named \code{DatNet.ObsP0} that is returned by this function can be supplied as an input to the
 \code{tmlenet} function.
 When \code{DatNet.ObsP0} is used as an input to \code{tmlenet}, the rest of the input arguments already provided to
 this function can be omitted from the \code{tmlenet} function call.
}
\examples{
#***************************************************************************************
# Define some summary measures for sW
#***************************************************************************************
def_sW <- def.sW(W1, W2, W3) +
          def.sW(netW1 = W1[[1:Kmax]]) +
          def.sW(netW2 = W2[[1:Kmax]]) +
          def.sW(mean.netW2 = mean(W2[[1:Kmax]]), replaceNAw0 = TRUE) +
          def.sW(sum.netW3 = sum(W3[[1:Kmax]]), replaceNAw0 = TRUE)

#***************************************************************************************
# Define some summary measures for sA
#***************************************************************************************
def_sA <- def.sA(netA = A[[0:Kmax]]) +
          def.sA(sum.netAW2 = sum((1-A[[1:Kmax]])*W2[[1:Kmax]]), replaceNAw0 = TRUE)

#***************************************************************************************
# Evaluate the summary measures applied to the  (O)bserved data (data.frame) and network
#***************************************************************************************
# load observed data:
data(df_netKmax6)
# load the network ID matrix:
data(NetInd_mat_Kmax6)
res <- eval.summaries(sW = def_sW, sA = def_sA,  Kmax = 6, data = df_netKmax6,
  NETIDmat = NetInd_mat_Kmax6, verbose = TRUE)

#***************************************************************************************
# Contents of the list returned by eval.summaries():
#***************************************************************************************
names(res)
# matrix of sW summary measures:
head(res$sW.matrix)
# matrix of sA summary measures:
head(res$sA.matrix)
# matrix of network IDs:
head(res$NETIDmat)
# Observed data summary measures (sW,sA) and network 
# stored as "DatNet.sWsA" R6 class object:
res$DatNet.ObsP0
class(res$DatNet.ObsP0)

#***************************************************************************************
# Using DatNet.ObsP0 as input to tmlenet():
#***************************************************************************************
options(tmlenet.verbose = FALSE) # set to TRUE to print status messages
res_K6 <- tmlenet(DatNet.ObsP0 = res$DatNet.ObsP0,
                    Qform = "Y ~ sum.netW3 + sum.netAW2",
                    hform.g0 = "netA ~ netW2 + sum.netW3 + nF",
                    hform.gstar = "netA ~ sum.netW3",
                    Anode = "A", Ynode = "Y", f_gstar1 = 0L)

res_K6$EY_gstar1$estimates
res_K6$EY_gstar1$vars
res_K6$EY_gstar1$CIs



}
\seealso{
\code{\link{tmlenet}} for estimation of network effects and \code{\link{def.sW}} for defining the summary measures.
}

