% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/SummariesModelClass.R
\docType{class}
\name{SummariesModel}
\alias{SummariesModel}
\title{R6 class for fitting and predicting model P(sA|sW) under g.star or g.0}
\format{An \code{\link{R6Class}} generator object}
\usage{
SummariesModel
}
\description{
This R6 class Class for defining, fitting and predicting the probability model
 \code{P(sA|sW)} under \code{g_star} or under \code{g_0} for summary measures
 (\code{sW,sA}). Defines and manages the factorization of the multivariate conditional
 probability model \code{P(sA=sa|...)} into univariate regression models
 \code{sA[j] ~ sA[j-1] + ... + sA[1] + sW}. The class \code{self$new} method automatically
 figures out the correct joint probability factorization into univariate conditional
 probabilities based on name ordering provided by (\code{sA_nms}, \code{sW_nms}).
 When the outcome variable \code{sA[j]} is binary, this class will automatically call
 a new instance of \code{\link{BinOutModel}} class.
 Provide \code{self$fit()} function argument \code{data} as a \code{\link{DatNet.sWsA}} class object.
 This data will be used for fitting the model \code{P(sA|sW)}.
 Provide \code{self$fit()} function argument \code{newdata} (also as \code{DatNet.sWsA} class) for predictions of the type
 \code{P(sA=1|sW=sw)}, where \code{sw} values are coming from \code{newdata} object.
 Finally, provide \code{self$predictAeqa} function \code{newdata} argument
 (also \code{DatNet.sWsA} class object) for getting the likelihood predictions \code{P(sA=sa|sW=sw)}, where
 both, \code{sa} and \code{sw} values are coming from \code{newdata} object.
}
\details{
\itemize{
\item{\code{n_regs}} - .
\item{\code{parfit_allowed}} - .
}
}
\section{Methods}{

\describe{
  \item{\code{new(reg, ...)}}{...}
  \item{\code{length}}{...}
  \item{\code{getPsAsW.models}}{...}
  \item{\code{getcumprodAeqa}}{...}
  \item{\code{copy.fit(SummariesModel)}}{...}
  \item{\code{fit(data)}}{...}
  \item{\code{predict(newdata)}}{...}
  \item{\code{predictAeqa(newdata, ...)}}{...}
}
}

\section{Active Bindings}{

\describe{
  \item{\code{wipe.alldat}}{...}
}
}
\keyword{R6}
\keyword{class}

