% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/tm_layers.R
\name{tm_lines}
\alias{tm_lines}
\title{Draw spatial lines}
\usage{
tm_lines(col = "red", lwd = 1, lty = "solid", alpha = NA, scale = 1,
  n = 5, style = "pretty", breaks = NULL, palette = NULL,
  labels = NULL, auto.palette.mapping = TRUE, contrast = 1,
  max.categories = 12, colorNA = "grey65", textNA = "Missing")
}
\arguments{
\item{col}{color of the lines. Either a color value or a data variable name.}

\item{lwd}{line width}

\item{lty}{line type}

\item{alpha}{transparency number between 0 (totally transparent) and 1 (not transparent). By default, the alpha value of the \code{col} is used (normally 1).}

\item{scale}{line width multiplier number.}

\item{n}{preferred number of color scale classes. Only applicable when \code{lwd} is the name of a numeric variable.}

\item{style}{method to cut the color scale: e.g. "fixed", "equal", "pretty", "quantile", or "kmeans". See the details in \code{\link[classInt:classIntervals]{classIntervals}}. Only applicable when \code{lwd} is the name of a numeric variable.}

\item{breaks}{in case \code{style=="fixed"}, breaks should be specified}

\item{palette}{color palette (see \code{RColorBrewer::display.brewer.all}) for the lines. Only when \code{col} is set to a variable.}

\item{labels}{labels of the classes}

\item{auto.palette.mapping}{When diverging colour palettes are used (i.e. "RdBu") this method automatically maps colors to values such that the middle colors (mostly white or yellow) are assigned to values of 0, and the two sides of the color palette are assigned to negative respectively positive values. In this case of line widths, obviously only the positive side is used.}

\item{contrast}{number between 0 and 1 (default) that determines the contrast of the palette. Only applicable when \code{auto.palette.mapping=TRUE}}

\item{max.categories}{in case \code{col} is the name of a categorical variable, this value determines how many categories (levels) it can have maximally. If the number of levels is higher than \code{max.categories}, then levels are combined.}

\item{colorNA}{color used for missing values}

\item{textNA}{text used for missing values. Use \code{NA} to omit text for missing values in the legend}
}
\value{
\code{\link{tmap-element}}
}
\description{
Creates a \code{\link{tmap-element}} that draw spatial lines.
}
\examples{
data(rivers)
data(World)
data(Europe)

tm_shape(World) +
	tm_fill("darkolivegreen3") +
	tm_shape(rivers) +
	tm_lines(col="navy") +
	tm_layout_World("Rivers of the World", inner.margins = c(0,0,.1,0))

tm_shape(Europe) +
    tm_fill("darkolivegreen3") +
    tm_borders("white") +
tm_shape(rivers) +
    tm_lines(col="navy", lwd="scalerank", scale=2) +
tm_layout("Rivers of Europe", legend.show=FALSE)
}
\seealso{
\href{../doc/tmap-nutshell.html}{\code{vignette("tmap-nutshell")}}
}

