% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/tm_layers.R
\name{tm_borders}
\alias{tm_borders}
\title{Draw polygon borders}
\usage{
tm_borders(col = "grey40", lwd = 1, lty = "solid", alpha = NA)
}
\arguments{
\item{col}{line color}

\item{lwd}{line width (see \code{\link[graphics:par]{par}})}

\item{lty}{line type (see \code{\link[graphics:par]{par}})}

\item{alpha}{transparency number between 0 (totally transparent) and 1 (not transparent). By default, the alpha value of the \code{col} is used (normally 1).}
}
\value{
\code{\link{tmap-element}}
}
\description{
Creates a \code{\link{tmap-element}} that defines the borders of the polygons. Line color, width, and type can be set.
}
\examples{
data(Europe)
data(NLD_prov)
data(NLD_muni)

tm_shape(Europe) + tm_borders()

tm_shape(NLD_muni) +
	tm_fill(col="population", convert2density=TRUE, style="kmeans") +
	tm_borders("grey25", alpha=.5) + 
tm_shape(NLD_prov) +
	tm_borders("grey40", lwd=2) +
	tm_layout_NLD(title="Population (per km2)", bg.color="white", draw.frame = FALSE)
}
\seealso{
\href{../doc/tmap-nutshell.html}{\code{vignette("tmap-nutshell")}}
}

