// Generated by rstantools.  Do not edit by hand.

/*
    tipsae is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    tipsae is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with tipsae.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_global_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_global");
    reader.add_event(1, 1, "include", "/inst/stan/include/data.stan");
    reader.add_event(1, 0, "start", "/inst/stan/include/data.stan");
    reader.add_event(58, 57, "end", "/inst/stan/include/data.stan");
    reader.add_event(58, 2, "restart", "model_global");
    reader.add_event(82, 26, "include", "/inst/stan/include/parameters.stan");
    reader.add_event(82, 0, "start", "/inst/stan/include/parameters.stan");
    reader.add_event(116, 34, "end", "/inst/stan/include/parameters.stan");
    reader.add_event(116, 27, "restart", "model_global");
    reader.add_event(119, 30, "include", "/inst/stan/include/transf_par_declaration.stan");
    reader.add_event(119, 0, "start", "/inst/stan/include/transf_par_declaration.stan");
    reader.add_event(156, 37, "end", "/inst/stan/include/transf_par_declaration.stan");
    reader.add_event(156, 31, "restart", "model_global");
    reader.add_event(179, 54, "include", "/inst/stan/include/transf_par_reff.stan");
    reader.add_event(179, 0, "start", "/inst/stan/include/transf_par_reff.stan");
    reader.add_event(242, 63, "end", "/inst/stan/include/transf_par_reff.stan");
    reader.add_event(242, 55, "restart", "model_global");
    reader.add_event(245, 58, "include", "/inst/stan/include/transf_par_beta.stan");
    reader.add_event(245, 0, "start", "/inst/stan/include/transf_par_beta.stan");
    reader.add_event(263, 18, "include", "/inst/stan/include/transf_par_ab.stan");
    reader.add_event(263, 0, "start", "/inst/stan/include/transf_par_ab.stan");
    reader.add_event(272, 9, "end", "/inst/stan/include/transf_par_ab.stan");
    reader.add_event(272, 19, "restart", "/inst/stan/include/transf_par_beta.stan");
    reader.add_event(273, 20, "end", "/inst/stan/include/transf_par_beta.stan");
    reader.add_event(273, 59, "restart", "model_global");
    reader.add_event(276, 62, "include", "/inst/stan/include/transf_par_FB.stan");
    reader.add_event(276, 0, "start", "/inst/stan/include/transf_par_FB.stan");
    reader.add_event(294, 18, "end", "/inst/stan/include/transf_par_FB.stan");
    reader.add_event(294, 63, "restart", "model_global");
    reader.add_event(295, 64, "include", "/inst/stan/include/transf_par_ZIB.stan");
    reader.add_event(295, 0, "start", "/inst/stan/include/transf_par_ZIB.stan");
    reader.add_event(357, 62, "include", "/inst/stan/include/transf_par_ab.stan");
    reader.add_event(357, 0, "start", "/inst/stan/include/transf_par_ab.stan");
    reader.add_event(366, 9, "end", "/inst/stan/include/transf_par_ab.stan");
    reader.add_event(366, 63, "restart", "/inst/stan/include/transf_par_ZIB.stan");
    reader.add_event(367, 64, "end", "/inst/stan/include/transf_par_ZIB.stan");
    reader.add_event(367, 65, "restart", "model_global");
    reader.add_event(368, 66, "include", "/inst/stan/include/transf_par_ZIBalt.stan");
    reader.add_event(368, 0, "start", "/inst/stan/include/transf_par_ZIBalt.stan");
    reader.add_event(385, 17, "include", "/inst/stan/include/transf_par_ab.stan");
    reader.add_event(385, 0, "start", "/inst/stan/include/transf_par_ab.stan");
    reader.add_event(394, 9, "end", "/inst/stan/include/transf_par_ab.stan");
    reader.add_event(394, 18, "restart", "/inst/stan/include/transf_par_ZIBalt.stan");
    reader.add_event(395, 19, "end", "/inst/stan/include/transf_par_ZIBalt.stan");
    reader.add_event(395, 67, "restart", "model_global");
    reader.add_event(531, 203, "include", "/inst/stan/include/gen_reff_OOS.stan");
    reader.add_event(531, 0, "start", "/inst/stan/include/gen_reff_OOS.stan");
    reader.add_event(543, 12, "end", "/inst/stan/include/gen_reff_OOS.stan");
    reader.add_event(543, 204, "restart", "model_global");
    reader.add_event(550, 211, "include", "/inst/stan/include/gen_FB.stan");
    reader.add_event(550, 0, "start", "/inst/stan/include/gen_FB.stan");
    reader.add_event(560, 10, "end", "/inst/stan/include/gen_FB.stan");
    reader.add_event(560, 212, "restart", "model_global");
    reader.add_event(561, 213, "include", "/inst/stan/include/gen_ZIB.stan");
    reader.add_event(561, 0, "start", "/inst/stan/include/gen_ZIB.stan");
    reader.add_event(562, 1, "include", "/inst/stan/include/gen_reff_OOS.stan");
    reader.add_event(562, 0, "start", "/inst/stan/include/gen_reff_OOS.stan");
    reader.add_event(574, 12, "end", "/inst/stan/include/gen_reff_OOS.stan");
    reader.add_event(574, 2, "restart", "/inst/stan/include/gen_ZIB.stan");
    reader.add_event(647, 75, "end", "/inst/stan/include/gen_ZIB.stan");
    reader.add_event(647, 214, "restart", "model_global");
    reader.add_event(648, 215, "include", "/inst/stan/include/gen_ZIB_alt.stan");
    reader.add_event(648, 0, "start", "/inst/stan/include/gen_ZIB_alt.stan");
    reader.add_event(649, 1, "include", "/inst/stan/include/gen_reff_OOS.stan");
    reader.add_event(649, 0, "start", "/inst/stan/include/gen_reff_OOS.stan");
    reader.add_event(661, 12, "end", "/inst/stan/include/gen_reff_OOS.stan");
    reader.add_event(661, 2, "restart", "/inst/stan/include/gen_ZIB_alt.stan");
    reader.add_event(683, 24, "end", "/inst/stan/include/gen_ZIB_alt.stan");
    reader.add_event(683, 216, "restart", "model_global");
    reader.add_event(690, 221, "end", "model_global");
    return reader;
}
#include <stan_meta_header.hpp>
class model_global
  : public stan::model::model_base_crtp<model_global> {
private:
        int intercept;
        int deff;
        int prior_reff;
        int prior_coeff;
        int likelihood;
        int inflation;
        int temporal_err;
        int spatial_err;
        int spatio_temporal;
        int M_is;
        int M_oos;
        int D;
        int P;
        int TP;
        vector_d y;
        matrix_d X;
        matrix_d X_oos;
        vector_d disp;
        vector_d m_d;
        std::vector<int> indices_is;
        std::vector<int> indices_oos;
        std::vector<int> indices_spat;
        std::vector<std::vector<int> > indices_temp;
        int N_edges;
        int N_comp;
        std::vector<int> dim_c;
        vector_d scales_ICAR;
        std::vector<int> node1;
        std::vector<int> node2;
        std::vector<int> node1_t;
        std::vector<int> node2_t;
        double scale_factor_RW1;
        std::vector<int> cat_ios;
        double sigma_HS;
        double p0_HS;
        double slab_scale;
        double slab_df;
        double sigma_unstr;
        double sigma_spatial;
        double sigma_temporal;
        double sigma_coeff;
        int M_overall;
        double slab_scale2;
        double half_nu;
        double tau0;
        int length_v;
public:
    model_global(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_global(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_global_namespace::model_global";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 3;
            context__.validate_dims("data initialization", "intercept", "int", context__.to_vec());
            intercept = int(0);
            vals_i__ = context__.vals_i("intercept");
            pos__ = 0;
            intercept = vals_i__[pos__++];
            check_greater_or_equal(function__, "intercept", intercept, 0);
            check_less_or_equal(function__, "intercept", intercept, 1);
            current_statement_begin__ = 4;
            context__.validate_dims("data initialization", "deff", "int", context__.to_vec());
            deff = int(0);
            vals_i__ = context__.vals_i("deff");
            pos__ = 0;
            deff = vals_i__[pos__++];
            check_greater_or_equal(function__, "deff", deff, 0);
            check_less_or_equal(function__, "deff", deff, 1);
            current_statement_begin__ = 5;
            context__.validate_dims("data initialization", "prior_reff", "int", context__.to_vec());
            prior_reff = int(0);
            vals_i__ = context__.vals_i("prior_reff");
            pos__ = 0;
            prior_reff = vals_i__[pos__++];
            check_greater_or_equal(function__, "prior_reff", prior_reff, 0);
            check_less_or_equal(function__, "prior_reff", prior_reff, 2);
            current_statement_begin__ = 6;
            context__.validate_dims("data initialization", "prior_coeff", "int", context__.to_vec());
            prior_coeff = int(0);
            vals_i__ = context__.vals_i("prior_coeff");
            pos__ = 0;
            prior_coeff = vals_i__[pos__++];
            check_greater_or_equal(function__, "prior_coeff", prior_coeff, 0);
            check_less_or_equal(function__, "prior_coeff", prior_coeff, 1);
            current_statement_begin__ = 7;
            context__.validate_dims("data initialization", "likelihood", "int", context__.to_vec());
            likelihood = int(0);
            vals_i__ = context__.vals_i("likelihood");
            pos__ = 0;
            likelihood = vals_i__[pos__++];
            check_greater_or_equal(function__, "likelihood", likelihood, 0);
            check_less_or_equal(function__, "likelihood", likelihood, 3);
            current_statement_begin__ = 8;
            context__.validate_dims("data initialization", "inflation", "int", context__.to_vec());
            inflation = int(0);
            vals_i__ = context__.vals_i("inflation");
            pos__ = 0;
            inflation = vals_i__[pos__++];
            check_greater_or_equal(function__, "inflation", inflation, 0);
            check_less_or_equal(function__, "inflation", inflation, 2);
            current_statement_begin__ = 9;
            context__.validate_dims("data initialization", "temporal_err", "int", context__.to_vec());
            temporal_err = int(0);
            vals_i__ = context__.vals_i("temporal_err");
            pos__ = 0;
            temporal_err = vals_i__[pos__++];
            check_greater_or_equal(function__, "temporal_err", temporal_err, 0);
            check_less_or_equal(function__, "temporal_err", temporal_err, 1);
            current_statement_begin__ = 10;
            context__.validate_dims("data initialization", "spatial_err", "int", context__.to_vec());
            spatial_err = int(0);
            vals_i__ = context__.vals_i("spatial_err");
            pos__ = 0;
            spatial_err = vals_i__[pos__++];
            check_greater_or_equal(function__, "spatial_err", spatial_err, 0);
            check_less_or_equal(function__, "spatial_err", spatial_err, 1);
            current_statement_begin__ = 11;
            context__.validate_dims("data initialization", "spatio_temporal", "int", context__.to_vec());
            spatio_temporal = int(0);
            vals_i__ = context__.vals_i("spatio_temporal");
            pos__ = 0;
            spatio_temporal = vals_i__[pos__++];
            check_greater_or_equal(function__, "spatio_temporal", spatio_temporal, 0);
            check_less_or_equal(function__, "spatio_temporal", spatio_temporal, 1);
            current_statement_begin__ = 15;
            context__.validate_dims("data initialization", "M_is", "int", context__.to_vec());
            M_is = int(0);
            vals_i__ = context__.vals_i("M_is");
            pos__ = 0;
            M_is = vals_i__[pos__++];
            check_greater_or_equal(function__, "M_is", M_is, 0);
            current_statement_begin__ = 16;
            context__.validate_dims("data initialization", "M_oos", "int", context__.to_vec());
            M_oos = int(0);
            vals_i__ = context__.vals_i("M_oos");
            pos__ = 0;
            M_oos = vals_i__[pos__++];
            check_greater_or_equal(function__, "M_oos", M_oos, 0);
            current_statement_begin__ = 17;
            context__.validate_dims("data initialization", "D", "int", context__.to_vec());
            D = int(0);
            vals_i__ = context__.vals_i("D");
            pos__ = 0;
            D = vals_i__[pos__++];
            check_greater_or_equal(function__, "D", D, 0);
            current_statement_begin__ = 18;
            context__.validate_dims("data initialization", "P", "int", context__.to_vec());
            P = int(0);
            vals_i__ = context__.vals_i("P");
            pos__ = 0;
            P = vals_i__[pos__++];
            check_greater_or_equal(function__, "P", P, 0);
            current_statement_begin__ = 19;
            context__.validate_dims("data initialization", "TP", "int", context__.to_vec());
            TP = int(0);
            vals_i__ = context__.vals_i("TP");
            pos__ = 0;
            TP = vals_i__[pos__++];
            check_greater_or_equal(function__, "TP", TP, 0);
            current_statement_begin__ = 22;
            validate_non_negative_index("y", "M_is", M_is);
            context__.validate_dims("data initialization", "y", "vector_d", context__.to_vec(M_is));
            y = Eigen::Matrix<double, Eigen::Dynamic, 1>(M_is);
            vals_r__ = context__.vals_r("y");
            pos__ = 0;
            size_t y_j_1_max__ = M_is;
            for (size_t j_1__ = 0; j_1__ < y_j_1_max__; ++j_1__) {
                y(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "y", y, 0);
            check_less_or_equal(function__, "y", y, 1);
            current_statement_begin__ = 23;
            validate_non_negative_index("X", "M_is", M_is);
            validate_non_negative_index("X", "P", P);
            context__.validate_dims("data initialization", "X", "matrix_d", context__.to_vec(M_is,P));
            X = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(M_is, P);
            vals_r__ = context__.vals_r("X");
            pos__ = 0;
            size_t X_j_2_max__ = P;
            size_t X_j_1_max__ = M_is;
            for (size_t j_2__ = 0; j_2__ < X_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < X_j_1_max__; ++j_1__) {
                    X(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 24;
            validate_non_negative_index("X_oos", "M_oos", M_oos);
            validate_non_negative_index("X_oos", "P", P);
            context__.validate_dims("data initialization", "X_oos", "matrix_d", context__.to_vec(M_oos,P));
            X_oos = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(M_oos, P);
            vals_r__ = context__.vals_r("X_oos");
            pos__ = 0;
            size_t X_oos_j_2_max__ = P;
            size_t X_oos_j_1_max__ = M_oos;
            for (size_t j_2__ = 0; j_2__ < X_oos_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < X_oos_j_1_max__; ++j_1__) {
                    X_oos(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 25;
            validate_non_negative_index("disp", "M_is", M_is);
            context__.validate_dims("data initialization", "disp", "vector_d", context__.to_vec(M_is));
            disp = Eigen::Matrix<double, Eigen::Dynamic, 1>(M_is);
            vals_r__ = context__.vals_r("disp");
            pos__ = 0;
            size_t disp_j_1_max__ = M_is;
            for (size_t j_1__ = 0; j_1__ < disp_j_1_max__; ++j_1__) {
                disp(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "disp", disp, 0);
            current_statement_begin__ = 26;
            validate_non_negative_index("m_d", "M_is", M_is);
            context__.validate_dims("data initialization", "m_d", "vector_d", context__.to_vec(M_is));
            m_d = Eigen::Matrix<double, Eigen::Dynamic, 1>(M_is);
            vals_r__ = context__.vals_r("m_d");
            pos__ = 0;
            size_t m_d_j_1_max__ = M_is;
            for (size_t j_1__ = 0; j_1__ < m_d_j_1_max__; ++j_1__) {
                m_d(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "m_d", m_d, 0);
            current_statement_begin__ = 29;
            validate_non_negative_index("indices_is", "M_is", M_is);
            context__.validate_dims("data initialization", "indices_is", "int", context__.to_vec(M_is));
            indices_is = std::vector<int>(M_is, int(0));
            vals_i__ = context__.vals_i("indices_is");
            pos__ = 0;
            size_t indices_is_k_0_max__ = M_is;
            for (size_t k_0__ = 0; k_0__ < indices_is_k_0_max__; ++k_0__) {
                indices_is[k_0__] = vals_i__[pos__++];
            }
            size_t indices_is_i_0_max__ = M_is;
            for (size_t i_0__ = 0; i_0__ < indices_is_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "indices_is[i_0__]", indices_is[i_0__], 0);
            }
            current_statement_begin__ = 30;
            validate_non_negative_index("indices_oos", "M_oos", M_oos);
            context__.validate_dims("data initialization", "indices_oos", "int", context__.to_vec(M_oos));
            indices_oos = std::vector<int>(M_oos, int(0));
            vals_i__ = context__.vals_i("indices_oos");
            pos__ = 0;
            size_t indices_oos_k_0_max__ = M_oos;
            for (size_t k_0__ = 0; k_0__ < indices_oos_k_0_max__; ++k_0__) {
                indices_oos[k_0__] = vals_i__[pos__++];
            }
            size_t indices_oos_i_0_max__ = M_oos;
            for (size_t i_0__ = 0; i_0__ < indices_oos_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "indices_oos[i_0__]", indices_oos[i_0__], 0);
            }
            current_statement_begin__ = 31;
            validate_non_negative_index("indices_spat", "D", D);
            context__.validate_dims("data initialization", "indices_spat", "int", context__.to_vec(D));
            indices_spat = std::vector<int>(D, int(0));
            vals_i__ = context__.vals_i("indices_spat");
            pos__ = 0;
            size_t indices_spat_k_0_max__ = D;
            for (size_t k_0__ = 0; k_0__ < indices_spat_k_0_max__; ++k_0__) {
                indices_spat[k_0__] = vals_i__[pos__++];
            }
            size_t indices_spat_i_0_max__ = D;
            for (size_t i_0__ = 0; i_0__ < indices_spat_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "indices_spat[i_0__]", indices_spat[i_0__], 0);
            }
            current_statement_begin__ = 32;
            validate_non_negative_index("indices_temp", "(M_is + M_oos)", (M_is + M_oos));
            validate_non_negative_index("indices_temp", "2", 2);
            context__.validate_dims("data initialization", "indices_temp", "int", context__.to_vec((M_is + M_oos),2));
            indices_temp = std::vector<std::vector<int> >((M_is + M_oos), std::vector<int>(2, int(0)));
            vals_i__ = context__.vals_i("indices_temp");
            pos__ = 0;
            size_t indices_temp_k_0_max__ = (M_is + M_oos);
            size_t indices_temp_k_1_max__ = 2;
            for (size_t k_1__ = 0; k_1__ < indices_temp_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < indices_temp_k_0_max__; ++k_0__) {
                    indices_temp[k_0__][k_1__] = vals_i__[pos__++];
                }
            }
            size_t indices_temp_i_0_max__ = (M_is + M_oos);
            size_t indices_temp_i_1_max__ = 2;
            for (size_t i_0__ = 0; i_0__ < indices_temp_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < indices_temp_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "indices_temp[i_0__][i_1__]", indices_temp[i_0__][i_1__], 0);
                }
            }
            current_statement_begin__ = 35;
            context__.validate_dims("data initialization", "N_edges", "int", context__.to_vec());
            N_edges = int(0);
            vals_i__ = context__.vals_i("N_edges");
            pos__ = 0;
            N_edges = vals_i__[pos__++];
            check_greater_or_equal(function__, "N_edges", N_edges, 0);
            current_statement_begin__ = 36;
            context__.validate_dims("data initialization", "N_comp", "int", context__.to_vec());
            N_comp = int(0);
            vals_i__ = context__.vals_i("N_comp");
            pos__ = 0;
            N_comp = vals_i__[pos__++];
            check_greater_or_equal(function__, "N_comp", N_comp, 0);
            current_statement_begin__ = 37;
            validate_non_negative_index("dim_c", "N_comp", N_comp);
            context__.validate_dims("data initialization", "dim_c", "int", context__.to_vec(N_comp));
            dim_c = std::vector<int>(N_comp, int(0));
            vals_i__ = context__.vals_i("dim_c");
            pos__ = 0;
            size_t dim_c_k_0_max__ = N_comp;
            for (size_t k_0__ = 0; k_0__ < dim_c_k_0_max__; ++k_0__) {
                dim_c[k_0__] = vals_i__[pos__++];
            }
            size_t dim_c_i_0_max__ = N_comp;
            for (size_t i_0__ = 0; i_0__ < dim_c_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "dim_c[i_0__]", dim_c[i_0__], 0);
            }
            current_statement_begin__ = 38;
            validate_non_negative_index("scales_ICAR", "D", D);
            context__.validate_dims("data initialization", "scales_ICAR", "vector_d", context__.to_vec(D));
            scales_ICAR = Eigen::Matrix<double, Eigen::Dynamic, 1>(D);
            vals_r__ = context__.vals_r("scales_ICAR");
            pos__ = 0;
            size_t scales_ICAR_j_1_max__ = D;
            for (size_t j_1__ = 0; j_1__ < scales_ICAR_j_1_max__; ++j_1__) {
                scales_ICAR(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "scales_ICAR", scales_ICAR, 0);
            current_statement_begin__ = 39;
            validate_non_negative_index("node1", "N_edges", N_edges);
            context__.validate_dims("data initialization", "node1", "int", context__.to_vec(N_edges));
            node1 = std::vector<int>(N_edges, int(0));
            vals_i__ = context__.vals_i("node1");
            pos__ = 0;
            size_t node1_k_0_max__ = N_edges;
            for (size_t k_0__ = 0; k_0__ < node1_k_0_max__; ++k_0__) {
                node1[k_0__] = vals_i__[pos__++];
            }
            size_t node1_i_0_max__ = N_edges;
            for (size_t i_0__ = 0; i_0__ < node1_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "node1[i_0__]", node1[i_0__], 1);
                check_less_or_equal(function__, "node1[i_0__]", node1[i_0__], D);
            }
            current_statement_begin__ = 40;
            validate_non_negative_index("node2", "N_edges", N_edges);
            context__.validate_dims("data initialization", "node2", "int", context__.to_vec(N_edges));
            node2 = std::vector<int>(N_edges, int(0));
            vals_i__ = context__.vals_i("node2");
            pos__ = 0;
            size_t node2_k_0_max__ = N_edges;
            for (size_t k_0__ = 0; k_0__ < node2_k_0_max__; ++k_0__) {
                node2[k_0__] = vals_i__[pos__++];
            }
            size_t node2_i_0_max__ = N_edges;
            for (size_t i_0__ = 0; i_0__ < node2_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "node2[i_0__]", node2[i_0__], 1);
                check_less_or_equal(function__, "node2[i_0__]", node2[i_0__], D);
            }
            current_statement_begin__ = 43;
            validate_non_negative_index("node1_t", "(TP - 1)", (TP - 1));
            context__.validate_dims("data initialization", "node1_t", "int", context__.to_vec((TP - 1)));
            node1_t = std::vector<int>((TP - 1), int(0));
            vals_i__ = context__.vals_i("node1_t");
            pos__ = 0;
            size_t node1_t_k_0_max__ = (TP - 1);
            for (size_t k_0__ = 0; k_0__ < node1_t_k_0_max__; ++k_0__) {
                node1_t[k_0__] = vals_i__[pos__++];
            }
            size_t node1_t_i_0_max__ = (TP - 1);
            for (size_t i_0__ = 0; i_0__ < node1_t_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "node1_t[i_0__]", node1_t[i_0__], 1);
                check_less_or_equal(function__, "node1_t[i_0__]", node1_t[i_0__], TP);
            }
            current_statement_begin__ = 44;
            validate_non_negative_index("node2_t", "(TP - 1)", (TP - 1));
            context__.validate_dims("data initialization", "node2_t", "int", context__.to_vec((TP - 1)));
            node2_t = std::vector<int>((TP - 1), int(0));
            vals_i__ = context__.vals_i("node2_t");
            pos__ = 0;
            size_t node2_t_k_0_max__ = (TP - 1);
            for (size_t k_0__ = 0; k_0__ < node2_t_k_0_max__; ++k_0__) {
                node2_t[k_0__] = vals_i__[pos__++];
            }
            size_t node2_t_i_0_max__ = (TP - 1);
            for (size_t i_0__ = 0; i_0__ < node2_t_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "node2_t[i_0__]", node2_t[i_0__], 1);
                check_less_or_equal(function__, "node2_t[i_0__]", node2_t[i_0__], TP);
            }
            current_statement_begin__ = 45;
            context__.validate_dims("data initialization", "scale_factor_RW1", "double", context__.to_vec());
            scale_factor_RW1 = double(0);
            vals_r__ = context__.vals_r("scale_factor_RW1");
            pos__ = 0;
            scale_factor_RW1 = vals_r__[pos__++];
            check_greater_or_equal(function__, "scale_factor_RW1", scale_factor_RW1, 0);
            current_statement_begin__ = 46;
            validate_non_negative_index("cat_ios", "M_oos", M_oos);
            context__.validate_dims("data initialization", "cat_ios", "int", context__.to_vec(M_oos));
            cat_ios = std::vector<int>(M_oos, int(0));
            vals_i__ = context__.vals_i("cat_ios");
            pos__ = 0;
            size_t cat_ios_k_0_max__ = M_oos;
            for (size_t k_0__ = 0; k_0__ < cat_ios_k_0_max__; ++k_0__) {
                cat_ios[k_0__] = vals_i__[pos__++];
            }
            size_t cat_ios_i_0_max__ = M_oos;
            for (size_t i_0__ = 0; i_0__ < cat_ios_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "cat_ios[i_0__]", cat_ios[i_0__], 0);
            }
            current_statement_begin__ = 49;
            context__.validate_dims("data initialization", "sigma_HS", "double", context__.to_vec());
            sigma_HS = double(0);
            vals_r__ = context__.vals_r("sigma_HS");
            pos__ = 0;
            sigma_HS = vals_r__[pos__++];
            check_greater_or_equal(function__, "sigma_HS", sigma_HS, 0);
            current_statement_begin__ = 50;
            context__.validate_dims("data initialization", "p0_HS", "double", context__.to_vec());
            p0_HS = double(0);
            vals_r__ = context__.vals_r("p0_HS");
            pos__ = 0;
            p0_HS = vals_r__[pos__++];
            check_greater_or_equal(function__, "p0_HS", p0_HS, 0);
            current_statement_begin__ = 51;
            context__.validate_dims("data initialization", "slab_scale", "double", context__.to_vec());
            slab_scale = double(0);
            vals_r__ = context__.vals_r("slab_scale");
            pos__ = 0;
            slab_scale = vals_r__[pos__++];
            check_greater_or_equal(function__, "slab_scale", slab_scale, 0);
            current_statement_begin__ = 52;
            context__.validate_dims("data initialization", "slab_df", "double", context__.to_vec());
            slab_df = double(0);
            vals_r__ = context__.vals_r("slab_df");
            pos__ = 0;
            slab_df = vals_r__[pos__++];
            check_greater_or_equal(function__, "slab_df", slab_df, 0);
            current_statement_begin__ = 55;
            context__.validate_dims("data initialization", "sigma_unstr", "double", context__.to_vec());
            sigma_unstr = double(0);
            vals_r__ = context__.vals_r("sigma_unstr");
            pos__ = 0;
            sigma_unstr = vals_r__[pos__++];
            check_greater_or_equal(function__, "sigma_unstr", sigma_unstr, 0);
            current_statement_begin__ = 56;
            context__.validate_dims("data initialization", "sigma_spatial", "double", context__.to_vec());
            sigma_spatial = double(0);
            vals_r__ = context__.vals_r("sigma_spatial");
            pos__ = 0;
            sigma_spatial = vals_r__[pos__++];
            check_greater_or_equal(function__, "sigma_spatial", sigma_spatial, 0);
            current_statement_begin__ = 57;
            context__.validate_dims("data initialization", "sigma_temporal", "double", context__.to_vec());
            sigma_temporal = double(0);
            vals_r__ = context__.vals_r("sigma_temporal");
            pos__ = 0;
            sigma_temporal = vals_r__[pos__++];
            check_greater_or_equal(function__, "sigma_temporal", sigma_temporal, 0);
            current_statement_begin__ = 58;
            context__.validate_dims("data initialization", "sigma_coeff", "double", context__.to_vec());
            sigma_coeff = double(0);
            vals_r__ = context__.vals_r("sigma_coeff");
            pos__ = 0;
            sigma_coeff = vals_r__[pos__++];
            check_greater_or_equal(function__, "sigma_coeff", sigma_coeff, 0);
            // initialize transformed data variables
            current_statement_begin__ = 61;
            M_overall = int(0);
            stan::math::fill(M_overall, std::numeric_limits<int>::min());
            stan::math::assign(M_overall,(M_is + M_oos));
            current_statement_begin__ = 63;
            slab_scale2 = double(0);
            stan::math::fill(slab_scale2, DUMMY_VAR__);
            stan::math::assign(slab_scale2,square(slab_scale));
            current_statement_begin__ = 64;
            half_nu = double(0);
            stan::math::fill(half_nu, DUMMY_VAR__);
            stan::math::assign(half_nu,(0.5 * slab_df));
            current_statement_begin__ = 65;
            tau0 = double(0);
            stan::math::fill(tau0, DUMMY_VAR__);
            current_statement_begin__ = 66;
            length_v = int(0);
            stan::math::fill(length_v, std::numeric_limits<int>::min());
            // execute transformed data statements
            current_statement_begin__ = 67;
            if (as_bool(logical_eq(P, 0))) {
                current_statement_begin__ = 68;
                stan::math::assign(tau0, 1);
            } else {
                current_statement_begin__ = 70;
                stan::math::assign(tau0, ((p0_HS / ((1.0 * P) - p0_HS)) * (sigma_HS / stan::math::sqrt((1.0 * M_is)))));
            }
            current_statement_begin__ = 72;
            if (as_bool(logical_eq(temporal_err, 0))) {
                current_statement_begin__ = 73;
                stan::math::assign(length_v, M_is);
            } else {
                current_statement_begin__ = 75;
                if (as_bool(logical_eq(spatio_temporal, 1))) {
                    current_statement_begin__ = 76;
                    stan::math::assign(length_v, 0);
                } else {
                    current_statement_begin__ = 78;
                    stan::math::assign(length_v, D);
                }
            }
            // validate transformed data
            current_statement_begin__ = 61;
            check_greater_or_equal(function__, "M_overall", M_overall, 0);
            current_statement_begin__ = 63;
            check_greater_or_equal(function__, "slab_scale2", slab_scale2, 0);
            current_statement_begin__ = 64;
            check_greater_or_equal(function__, "half_nu", half_nu, 0);
            current_statement_begin__ = 65;
            check_greater_or_equal(function__, "tau0", tau0, 0);
            current_statement_begin__ = 66;
            check_greater_or_equal(function__, "length_v", length_v, 0);
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 84;
            validate_non_negative_index("beta0", "(logical_eq(intercept, 1) ? 1 : 0 )", (logical_eq(intercept, 1) ? 1 : 0 ));
            num_params_r__ += (logical_eq(intercept, 1) ? 1 : 0 );
            current_statement_begin__ = 85;
            validate_non_negative_index("z_beta", "P", P);
            num_params_r__ += P;
            current_statement_begin__ = 87;
            validate_non_negative_index("lambda_HS", "(logical_eq(prior_coeff, 1) ? P : 0 )", (logical_eq(prior_coeff, 1) ? P : 0 ));
            num_params_r__ += (logical_eq(prior_coeff, 1) ? P : 0 );
            current_statement_begin__ = 88;
            validate_non_negative_index("z_c2", "(logical_eq(prior_coeff, 1) ? 1 : 0 )", (logical_eq(prior_coeff, 1) ? 1 : 0 ));
            num_params_r__ += (logical_eq(prior_coeff, 1) ? 1 : 0 );
            current_statement_begin__ = 89;
            validate_non_negative_index("z_tau", "(logical_eq(prior_coeff, 1) ? 1 : 0 )", (logical_eq(prior_coeff, 1) ? 1 : 0 ));
            num_params_r__ += (logical_eq(prior_coeff, 1) ? 1 : 0 );
            current_statement_begin__ = 92;
            validate_non_negative_index("v_raw", "length_v", length_v);
            num_params_r__ += length_v;
            current_statement_begin__ = 94;
            validate_non_negative_index("sigma_v", "((primitive_value((primitive_value(logical_eq(prior_reff, 0)) || primitive_value(logical_eq(prior_reff, 1)))) && primitive_value(logical_eq(spatio_temporal, 0))) ? 1 : 0 )", ((primitive_value((primitive_value(logical_eq(prior_reff, 0)) || primitive_value(logical_eq(prior_reff, 1)))) && primitive_value(logical_eq(spatio_temporal, 0))) ? 1 : 0 ));
            num_params_r__ += ((primitive_value((primitive_value(logical_eq(prior_reff, 0)) || primitive_value(logical_eq(prior_reff, 1)))) && primitive_value(logical_eq(spatio_temporal, 0))) ? 1 : 0 );
            current_statement_begin__ = 96;
            validate_non_negative_index("nu", "((primitive_value(logical_eq(prior_reff, 1)) && primitive_value(logical_eq(spatio_temporal, 0))) ? 1 : 0 )", ((primitive_value(logical_eq(prior_reff, 1)) && primitive_value(logical_eq(spatio_temporal, 0))) ? 1 : 0 ));
            num_params_r__ += ((primitive_value(logical_eq(prior_reff, 1)) && primitive_value(logical_eq(spatio_temporal, 0))) ? 1 : 0 );
            current_statement_begin__ = 98;
            validate_non_negative_index("psi_d", "((primitive_value(logical_eq(prior_reff, 2)) && primitive_value(logical_eq(spatio_temporal, 0))) ? length_v : 0 )", ((primitive_value(logical_eq(prior_reff, 2)) && primitive_value(logical_eq(spatio_temporal, 0))) ? length_v : 0 ));
            num_params_r__ += ((primitive_value(logical_eq(prior_reff, 2)) && primitive_value(logical_eq(spatio_temporal, 0))) ? length_v : 0 );
            current_statement_begin__ = 99;
            validate_non_negative_index("lambda", "((primitive_value(logical_eq(prior_reff, 2)) && primitive_value(logical_eq(spatio_temporal, 0))) ? 1 : 0 )", ((primitive_value(logical_eq(prior_reff, 2)) && primitive_value(logical_eq(spatio_temporal, 0))) ? 1 : 0 ));
            num_params_r__ += ((primitive_value(logical_eq(prior_reff, 2)) && primitive_value(logical_eq(spatio_temporal, 0))) ? 1 : 0 );
            current_statement_begin__ = 102;
            validate_non_negative_index("s_raw", "(logical_eq(spatial_err, 1) ? D : 0 )", (logical_eq(spatial_err, 1) ? D : 0 ));
            num_params_r__ += (logical_eq(spatial_err, 1) ? D : 0 );
            current_statement_begin__ = 103;
            validate_non_negative_index("sigma_s", "(logical_eq(spatial_err, 1) ? 1 : 0 )", (logical_eq(spatial_err, 1) ? 1 : 0 ));
            num_params_r__ += (logical_eq(spatial_err, 1) ? 1 : 0 );
            current_statement_begin__ = 105;
            validate_non_negative_index("t_raw", "(logical_eq(temporal_err, 1) ? D : 0 )", (logical_eq(temporal_err, 1) ? D : 0 ));
            validate_non_negative_index("t_raw", "(logical_eq(temporal_err, 1) ? TP : 0 )", (logical_eq(temporal_err, 1) ? TP : 0 ));
            num_params_r__ += ((logical_eq(temporal_err, 1) ? D : 0 ) * (logical_eq(temporal_err, 1) ? TP : 0 ));
            current_statement_begin__ = 106;
            validate_non_negative_index("sigma_t", "(logical_eq(temporal_err, 1) ? 1 : 0 )", (logical_eq(temporal_err, 1) ? 1 : 0 ));
            num_params_r__ += (logical_eq(temporal_err, 1) ? 1 : 0 );
            current_statement_begin__ = 110;
            validate_non_negative_index("w", "(logical_eq(likelihood, 1) ? 1 : 0 )", (logical_eq(likelihood, 1) ? 1 : 0 ));
            num_params_r__ += (logical_eq(likelihood, 1) ? 1 : 0 );
            current_statement_begin__ = 111;
            validate_non_negative_index("p", "(logical_eq(likelihood, 1) ? 1 : 0 )", (logical_eq(likelihood, 1) ? 1 : 0 ));
            num_params_r__ += (logical_eq(likelihood, 1) ? 1 : 0 );
            current_statement_begin__ = 113;
            validate_non_negative_index("gamma_p0", "((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 1))) ? P : 0 )", ((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 1))) ? P : 0 ));
            num_params_r__ += ((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 1))) ? P : 0 );
            current_statement_begin__ = 114;
            validate_non_negative_index("gamma_p1", "((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 0))) ? P : 0 )", ((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 0))) ? P : 0 ));
            num_params_r__ += ((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 0))) ? P : 0 );
            current_statement_begin__ = 115;
            validate_non_negative_index("gamma0_p0", "((primitive_value((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 1)))) && primitive_value(logical_eq(intercept, 1))) ? 1 : 0 )", ((primitive_value((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 1)))) && primitive_value(logical_eq(intercept, 1))) ? 1 : 0 ));
            num_params_r__ += ((primitive_value((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 1)))) && primitive_value(logical_eq(intercept, 1))) ? 1 : 0 );
            current_statement_begin__ = 116;
            validate_non_negative_index("gamma0_p1", "((primitive_value((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 0)))) && primitive_value(logical_eq(intercept, 1))) ? 1 : 0 )", ((primitive_value((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 0)))) && primitive_value(logical_eq(intercept, 1))) ? 1 : 0 ));
            num_params_r__ += ((primitive_value((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 0)))) && primitive_value(logical_eq(intercept, 1))) ? 1 : 0 );
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_global() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 84;
        if (!(context__.contains_r("beta0")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable beta0 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("beta0");
        pos__ = 0U;
        validate_non_negative_index("beta0", "(logical_eq(intercept, 1) ? 1 : 0 )", (logical_eq(intercept, 1) ? 1 : 0 ));
        context__.validate_dims("parameter initialization", "beta0", "vector_d", context__.to_vec((logical_eq(intercept, 1) ? 1 : 0 )));
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta0((logical_eq(intercept, 1) ? 1 : 0 ));
        size_t beta0_j_1_max__ = (logical_eq(intercept, 1) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < beta0_j_1_max__; ++j_1__) {
            beta0(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(beta0);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable beta0: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 85;
        if (!(context__.contains_r("z_beta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable z_beta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("z_beta");
        pos__ = 0U;
        validate_non_negative_index("z_beta", "P", P);
        context__.validate_dims("parameter initialization", "z_beta", "vector_d", context__.to_vec(P));
        Eigen::Matrix<double, Eigen::Dynamic, 1> z_beta(P);
        size_t z_beta_j_1_max__ = P;
        for (size_t j_1__ = 0; j_1__ < z_beta_j_1_max__; ++j_1__) {
            z_beta(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(z_beta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable z_beta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 87;
        if (!(context__.contains_r("lambda_HS")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable lambda_HS missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("lambda_HS");
        pos__ = 0U;
        validate_non_negative_index("lambda_HS", "(logical_eq(prior_coeff, 1) ? P : 0 )", (logical_eq(prior_coeff, 1) ? P : 0 ));
        context__.validate_dims("parameter initialization", "lambda_HS", "vector_d", context__.to_vec((logical_eq(prior_coeff, 1) ? P : 0 )));
        Eigen::Matrix<double, Eigen::Dynamic, 1> lambda_HS((logical_eq(prior_coeff, 1) ? P : 0 ));
        size_t lambda_HS_j_1_max__ = (logical_eq(prior_coeff, 1) ? P : 0 );
        for (size_t j_1__ = 0; j_1__ < lambda_HS_j_1_max__; ++j_1__) {
            lambda_HS(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, lambda_HS);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable lambda_HS: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 88;
        if (!(context__.contains_r("z_c2")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable z_c2 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("z_c2");
        pos__ = 0U;
        validate_non_negative_index("z_c2", "(logical_eq(prior_coeff, 1) ? 1 : 0 )", (logical_eq(prior_coeff, 1) ? 1 : 0 ));
        context__.validate_dims("parameter initialization", "z_c2", "vector_d", context__.to_vec((logical_eq(prior_coeff, 1) ? 1 : 0 )));
        Eigen::Matrix<double, Eigen::Dynamic, 1> z_c2((logical_eq(prior_coeff, 1) ? 1 : 0 ));
        size_t z_c2_j_1_max__ = (logical_eq(prior_coeff, 1) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < z_c2_j_1_max__; ++j_1__) {
            z_c2(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, z_c2);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable z_c2: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 89;
        if (!(context__.contains_r("z_tau")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable z_tau missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("z_tau");
        pos__ = 0U;
        validate_non_negative_index("z_tau", "(logical_eq(prior_coeff, 1) ? 1 : 0 )", (logical_eq(prior_coeff, 1) ? 1 : 0 ));
        context__.validate_dims("parameter initialization", "z_tau", "vector_d", context__.to_vec((logical_eq(prior_coeff, 1) ? 1 : 0 )));
        Eigen::Matrix<double, Eigen::Dynamic, 1> z_tau((logical_eq(prior_coeff, 1) ? 1 : 0 ));
        size_t z_tau_j_1_max__ = (logical_eq(prior_coeff, 1) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < z_tau_j_1_max__; ++j_1__) {
            z_tau(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, z_tau);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable z_tau: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 92;
        if (!(context__.contains_r("v_raw")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable v_raw missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("v_raw");
        pos__ = 0U;
        validate_non_negative_index("v_raw", "length_v", length_v);
        context__.validate_dims("parameter initialization", "v_raw", "vector_d", context__.to_vec(length_v));
        Eigen::Matrix<double, Eigen::Dynamic, 1> v_raw(length_v);
        size_t v_raw_j_1_max__ = length_v;
        for (size_t j_1__ = 0; j_1__ < v_raw_j_1_max__; ++j_1__) {
            v_raw(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(v_raw);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable v_raw: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 94;
        if (!(context__.contains_r("sigma_v")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma_v missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma_v");
        pos__ = 0U;
        validate_non_negative_index("sigma_v", "((primitive_value((primitive_value(logical_eq(prior_reff, 0)) || primitive_value(logical_eq(prior_reff, 1)))) && primitive_value(logical_eq(spatio_temporal, 0))) ? 1 : 0 )", ((primitive_value((primitive_value(logical_eq(prior_reff, 0)) || primitive_value(logical_eq(prior_reff, 1)))) && primitive_value(logical_eq(spatio_temporal, 0))) ? 1 : 0 ));
        context__.validate_dims("parameter initialization", "sigma_v", "vector_d", context__.to_vec(((primitive_value((primitive_value(logical_eq(prior_reff, 0)) || primitive_value(logical_eq(prior_reff, 1)))) && primitive_value(logical_eq(spatio_temporal, 0))) ? 1 : 0 )));
        Eigen::Matrix<double, Eigen::Dynamic, 1> sigma_v(((primitive_value((primitive_value(logical_eq(prior_reff, 0)) || primitive_value(logical_eq(prior_reff, 1)))) && primitive_value(logical_eq(spatio_temporal, 0))) ? 1 : 0 ));
        size_t sigma_v_j_1_max__ = ((primitive_value((primitive_value(logical_eq(prior_reff, 0)) || primitive_value(logical_eq(prior_reff, 1)))) && primitive_value(logical_eq(spatio_temporal, 0))) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < sigma_v_j_1_max__; ++j_1__) {
            sigma_v(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, sigma_v);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma_v: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 96;
        if (!(context__.contains_r("nu")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable nu missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("nu");
        pos__ = 0U;
        validate_non_negative_index("nu", "((primitive_value(logical_eq(prior_reff, 1)) && primitive_value(logical_eq(spatio_temporal, 0))) ? 1 : 0 )", ((primitive_value(logical_eq(prior_reff, 1)) && primitive_value(logical_eq(spatio_temporal, 0))) ? 1 : 0 ));
        context__.validate_dims("parameter initialization", "nu", "vector_d", context__.to_vec(((primitive_value(logical_eq(prior_reff, 1)) && primitive_value(logical_eq(spatio_temporal, 0))) ? 1 : 0 )));
        Eigen::Matrix<double, Eigen::Dynamic, 1> nu(((primitive_value(logical_eq(prior_reff, 1)) && primitive_value(logical_eq(spatio_temporal, 0))) ? 1 : 0 ));
        size_t nu_j_1_max__ = ((primitive_value(logical_eq(prior_reff, 1)) && primitive_value(logical_eq(spatio_temporal, 0))) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < nu_j_1_max__; ++j_1__) {
            nu(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, nu);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable nu: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 98;
        if (!(context__.contains_r("psi_d")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable psi_d missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("psi_d");
        pos__ = 0U;
        validate_non_negative_index("psi_d", "((primitive_value(logical_eq(prior_reff, 2)) && primitive_value(logical_eq(spatio_temporal, 0))) ? length_v : 0 )", ((primitive_value(logical_eq(prior_reff, 2)) && primitive_value(logical_eq(spatio_temporal, 0))) ? length_v : 0 ));
        context__.validate_dims("parameter initialization", "psi_d", "vector_d", context__.to_vec(((primitive_value(logical_eq(prior_reff, 2)) && primitive_value(logical_eq(spatio_temporal, 0))) ? length_v : 0 )));
        Eigen::Matrix<double, Eigen::Dynamic, 1> psi_d(((primitive_value(logical_eq(prior_reff, 2)) && primitive_value(logical_eq(spatio_temporal, 0))) ? length_v : 0 ));
        size_t psi_d_j_1_max__ = ((primitive_value(logical_eq(prior_reff, 2)) && primitive_value(logical_eq(spatio_temporal, 0))) ? length_v : 0 );
        for (size_t j_1__ = 0; j_1__ < psi_d_j_1_max__; ++j_1__) {
            psi_d(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, psi_d);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable psi_d: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 99;
        if (!(context__.contains_r("lambda")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable lambda missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("lambda");
        pos__ = 0U;
        validate_non_negative_index("lambda", "((primitive_value(logical_eq(prior_reff, 2)) && primitive_value(logical_eq(spatio_temporal, 0))) ? 1 : 0 )", ((primitive_value(logical_eq(prior_reff, 2)) && primitive_value(logical_eq(spatio_temporal, 0))) ? 1 : 0 ));
        context__.validate_dims("parameter initialization", "lambda", "vector_d", context__.to_vec(((primitive_value(logical_eq(prior_reff, 2)) && primitive_value(logical_eq(spatio_temporal, 0))) ? 1 : 0 )));
        Eigen::Matrix<double, Eigen::Dynamic, 1> lambda(((primitive_value(logical_eq(prior_reff, 2)) && primitive_value(logical_eq(spatio_temporal, 0))) ? 1 : 0 ));
        size_t lambda_j_1_max__ = ((primitive_value(logical_eq(prior_reff, 2)) && primitive_value(logical_eq(spatio_temporal, 0))) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < lambda_j_1_max__; ++j_1__) {
            lambda(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, lambda);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable lambda: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 102;
        if (!(context__.contains_r("s_raw")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable s_raw missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("s_raw");
        pos__ = 0U;
        validate_non_negative_index("s_raw", "(logical_eq(spatial_err, 1) ? D : 0 )", (logical_eq(spatial_err, 1) ? D : 0 ));
        context__.validate_dims("parameter initialization", "s_raw", "vector_d", context__.to_vec((logical_eq(spatial_err, 1) ? D : 0 )));
        Eigen::Matrix<double, Eigen::Dynamic, 1> s_raw((logical_eq(spatial_err, 1) ? D : 0 ));
        size_t s_raw_j_1_max__ = (logical_eq(spatial_err, 1) ? D : 0 );
        for (size_t j_1__ = 0; j_1__ < s_raw_j_1_max__; ++j_1__) {
            s_raw(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(s_raw);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable s_raw: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 103;
        if (!(context__.contains_r("sigma_s")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma_s missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma_s");
        pos__ = 0U;
        validate_non_negative_index("sigma_s", "(logical_eq(spatial_err, 1) ? 1 : 0 )", (logical_eq(spatial_err, 1) ? 1 : 0 ));
        context__.validate_dims("parameter initialization", "sigma_s", "vector_d", context__.to_vec((logical_eq(spatial_err, 1) ? 1 : 0 )));
        Eigen::Matrix<double, Eigen::Dynamic, 1> sigma_s((logical_eq(spatial_err, 1) ? 1 : 0 ));
        size_t sigma_s_j_1_max__ = (logical_eq(spatial_err, 1) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < sigma_s_j_1_max__; ++j_1__) {
            sigma_s(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, sigma_s);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma_s: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 105;
        if (!(context__.contains_r("t_raw")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable t_raw missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("t_raw");
        pos__ = 0U;
        validate_non_negative_index("t_raw", "(logical_eq(temporal_err, 1) ? D : 0 )", (logical_eq(temporal_err, 1) ? D : 0 ));
        validate_non_negative_index("t_raw", "(logical_eq(temporal_err, 1) ? TP : 0 )", (logical_eq(temporal_err, 1) ? TP : 0 ));
        context__.validate_dims("parameter initialization", "t_raw", "matrix_d", context__.to_vec((logical_eq(temporal_err, 1) ? D : 0 ),(logical_eq(temporal_err, 1) ? TP : 0 )));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> t_raw((logical_eq(temporal_err, 1) ? D : 0 ), (logical_eq(temporal_err, 1) ? TP : 0 ));
        size_t t_raw_j_2_max__ = (logical_eq(temporal_err, 1) ? TP : 0 );
        size_t t_raw_j_1_max__ = (logical_eq(temporal_err, 1) ? D : 0 );
        for (size_t j_2__ = 0; j_2__ < t_raw_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < t_raw_j_1_max__; ++j_1__) {
                t_raw(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.matrix_unconstrain(t_raw);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable t_raw: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 106;
        if (!(context__.contains_r("sigma_t")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma_t missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma_t");
        pos__ = 0U;
        validate_non_negative_index("sigma_t", "(logical_eq(temporal_err, 1) ? 1 : 0 )", (logical_eq(temporal_err, 1) ? 1 : 0 ));
        context__.validate_dims("parameter initialization", "sigma_t", "vector_d", context__.to_vec((logical_eq(temporal_err, 1) ? 1 : 0 )));
        Eigen::Matrix<double, Eigen::Dynamic, 1> sigma_t((logical_eq(temporal_err, 1) ? 1 : 0 ));
        size_t sigma_t_j_1_max__ = (logical_eq(temporal_err, 1) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < sigma_t_j_1_max__; ++j_1__) {
            sigma_t(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, sigma_t);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma_t: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 110;
        if (!(context__.contains_r("w")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable w missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("w");
        pos__ = 0U;
        validate_non_negative_index("w", "(logical_eq(likelihood, 1) ? 1 : 0 )", (logical_eq(likelihood, 1) ? 1 : 0 ));
        context__.validate_dims("parameter initialization", "w", "vector_d", context__.to_vec((logical_eq(likelihood, 1) ? 1 : 0 )));
        Eigen::Matrix<double, Eigen::Dynamic, 1> w((logical_eq(likelihood, 1) ? 1 : 0 ));
        size_t w_j_1_max__ = (logical_eq(likelihood, 1) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < w_j_1_max__; ++j_1__) {
            w(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lub_unconstrain(0.001, 0.999, w);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable w: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 111;
        if (!(context__.contains_r("p")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable p missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("p");
        pos__ = 0U;
        validate_non_negative_index("p", "(logical_eq(likelihood, 1) ? 1 : 0 )", (logical_eq(likelihood, 1) ? 1 : 0 ));
        context__.validate_dims("parameter initialization", "p", "vector_d", context__.to_vec((logical_eq(likelihood, 1) ? 1 : 0 )));
        Eigen::Matrix<double, Eigen::Dynamic, 1> p((logical_eq(likelihood, 1) ? 1 : 0 ));
        size_t p_j_1_max__ = (logical_eq(likelihood, 1) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < p_j_1_max__; ++j_1__) {
            p(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lub_unconstrain(0.001, 0.999, p);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable p: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 113;
        if (!(context__.contains_r("gamma_p0")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable gamma_p0 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("gamma_p0");
        pos__ = 0U;
        validate_non_negative_index("gamma_p0", "((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 1))) ? P : 0 )", ((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 1))) ? P : 0 ));
        context__.validate_dims("parameter initialization", "gamma_p0", "vector_d", context__.to_vec(((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 1))) ? P : 0 )));
        Eigen::Matrix<double, Eigen::Dynamic, 1> gamma_p0(((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 1))) ? P : 0 ));
        size_t gamma_p0_j_1_max__ = ((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 1))) ? P : 0 );
        for (size_t j_1__ = 0; j_1__ < gamma_p0_j_1_max__; ++j_1__) {
            gamma_p0(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(gamma_p0);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable gamma_p0: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 114;
        if (!(context__.contains_r("gamma_p1")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable gamma_p1 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("gamma_p1");
        pos__ = 0U;
        validate_non_negative_index("gamma_p1", "((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 0))) ? P : 0 )", ((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 0))) ? P : 0 ));
        context__.validate_dims("parameter initialization", "gamma_p1", "vector_d", context__.to_vec(((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 0))) ? P : 0 )));
        Eigen::Matrix<double, Eigen::Dynamic, 1> gamma_p1(((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 0))) ? P : 0 ));
        size_t gamma_p1_j_1_max__ = ((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 0))) ? P : 0 );
        for (size_t j_1__ = 0; j_1__ < gamma_p1_j_1_max__; ++j_1__) {
            gamma_p1(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(gamma_p1);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable gamma_p1: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 115;
        if (!(context__.contains_r("gamma0_p0")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable gamma0_p0 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("gamma0_p0");
        pos__ = 0U;
        validate_non_negative_index("gamma0_p0", "((primitive_value((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 1)))) && primitive_value(logical_eq(intercept, 1))) ? 1 : 0 )", ((primitive_value((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 1)))) && primitive_value(logical_eq(intercept, 1))) ? 1 : 0 ));
        context__.validate_dims("parameter initialization", "gamma0_p0", "vector_d", context__.to_vec(((primitive_value((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 1)))) && primitive_value(logical_eq(intercept, 1))) ? 1 : 0 )));
        Eigen::Matrix<double, Eigen::Dynamic, 1> gamma0_p0(((primitive_value((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 1)))) && primitive_value(logical_eq(intercept, 1))) ? 1 : 0 ));
        size_t gamma0_p0_j_1_max__ = ((primitive_value((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 1)))) && primitive_value(logical_eq(intercept, 1))) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < gamma0_p0_j_1_max__; ++j_1__) {
            gamma0_p0(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(gamma0_p0);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable gamma0_p0: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 116;
        if (!(context__.contains_r("gamma0_p1")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable gamma0_p1 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("gamma0_p1");
        pos__ = 0U;
        validate_non_negative_index("gamma0_p1", "((primitive_value((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 0)))) && primitive_value(logical_eq(intercept, 1))) ? 1 : 0 )", ((primitive_value((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 0)))) && primitive_value(logical_eq(intercept, 1))) ? 1 : 0 ));
        context__.validate_dims("parameter initialization", "gamma0_p1", "vector_d", context__.to_vec(((primitive_value((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 0)))) && primitive_value(logical_eq(intercept, 1))) ? 1 : 0 )));
        Eigen::Matrix<double, Eigen::Dynamic, 1> gamma0_p1(((primitive_value((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 0)))) && primitive_value(logical_eq(intercept, 1))) ? 1 : 0 ));
        size_t gamma0_p1_j_1_max__ = ((primitive_value((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 0)))) && primitive_value(logical_eq(intercept, 1))) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < gamma0_p1_j_1_max__; ++j_1__) {
            gamma0_p1(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(gamma0_p1);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable gamma0_p1: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 84;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> beta0;
            (void) beta0;  // dummy to suppress unused var warning
            if (jacobian__)
                beta0 = in__.vector_constrain((logical_eq(intercept, 1) ? 1 : 0 ), lp__);
            else
                beta0 = in__.vector_constrain((logical_eq(intercept, 1) ? 1 : 0 ));
            current_statement_begin__ = 85;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> z_beta;
            (void) z_beta;  // dummy to suppress unused var warning
            if (jacobian__)
                z_beta = in__.vector_constrain(P, lp__);
            else
                z_beta = in__.vector_constrain(P);
            current_statement_begin__ = 87;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lambda_HS;
            (void) lambda_HS;  // dummy to suppress unused var warning
            if (jacobian__)
                lambda_HS = in__.vector_lb_constrain(0, (logical_eq(prior_coeff, 1) ? P : 0 ), lp__);
            else
                lambda_HS = in__.vector_lb_constrain(0, (logical_eq(prior_coeff, 1) ? P : 0 ));
            current_statement_begin__ = 88;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> z_c2;
            (void) z_c2;  // dummy to suppress unused var warning
            if (jacobian__)
                z_c2 = in__.vector_lb_constrain(0, (logical_eq(prior_coeff, 1) ? 1 : 0 ), lp__);
            else
                z_c2 = in__.vector_lb_constrain(0, (logical_eq(prior_coeff, 1) ? 1 : 0 ));
            current_statement_begin__ = 89;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> z_tau;
            (void) z_tau;  // dummy to suppress unused var warning
            if (jacobian__)
                z_tau = in__.vector_lb_constrain(0, (logical_eq(prior_coeff, 1) ? 1 : 0 ), lp__);
            else
                z_tau = in__.vector_lb_constrain(0, (logical_eq(prior_coeff, 1) ? 1 : 0 ));
            current_statement_begin__ = 92;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> v_raw;
            (void) v_raw;  // dummy to suppress unused var warning
            if (jacobian__)
                v_raw = in__.vector_constrain(length_v, lp__);
            else
                v_raw = in__.vector_constrain(length_v);
            current_statement_begin__ = 94;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> sigma_v;
            (void) sigma_v;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_v = in__.vector_lb_constrain(0, ((primitive_value((primitive_value(logical_eq(prior_reff, 0)) || primitive_value(logical_eq(prior_reff, 1)))) && primitive_value(logical_eq(spatio_temporal, 0))) ? 1 : 0 ), lp__);
            else
                sigma_v = in__.vector_lb_constrain(0, ((primitive_value((primitive_value(logical_eq(prior_reff, 0)) || primitive_value(logical_eq(prior_reff, 1)))) && primitive_value(logical_eq(spatio_temporal, 0))) ? 1 : 0 ));
            current_statement_begin__ = 96;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> nu;
            (void) nu;  // dummy to suppress unused var warning
            if (jacobian__)
                nu = in__.vector_lb_constrain(0, ((primitive_value(logical_eq(prior_reff, 1)) && primitive_value(logical_eq(spatio_temporal, 0))) ? 1 : 0 ), lp__);
            else
                nu = in__.vector_lb_constrain(0, ((primitive_value(logical_eq(prior_reff, 1)) && primitive_value(logical_eq(spatio_temporal, 0))) ? 1 : 0 ));
            current_statement_begin__ = 98;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> psi_d;
            (void) psi_d;  // dummy to suppress unused var warning
            if (jacobian__)
                psi_d = in__.vector_lb_constrain(0, ((primitive_value(logical_eq(prior_reff, 2)) && primitive_value(logical_eq(spatio_temporal, 0))) ? length_v : 0 ), lp__);
            else
                psi_d = in__.vector_lb_constrain(0, ((primitive_value(logical_eq(prior_reff, 2)) && primitive_value(logical_eq(spatio_temporal, 0))) ? length_v : 0 ));
            current_statement_begin__ = 99;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lambda;
            (void) lambda;  // dummy to suppress unused var warning
            if (jacobian__)
                lambda = in__.vector_lb_constrain(0, ((primitive_value(logical_eq(prior_reff, 2)) && primitive_value(logical_eq(spatio_temporal, 0))) ? 1 : 0 ), lp__);
            else
                lambda = in__.vector_lb_constrain(0, ((primitive_value(logical_eq(prior_reff, 2)) && primitive_value(logical_eq(spatio_temporal, 0))) ? 1 : 0 ));
            current_statement_begin__ = 102;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> s_raw;
            (void) s_raw;  // dummy to suppress unused var warning
            if (jacobian__)
                s_raw = in__.vector_constrain((logical_eq(spatial_err, 1) ? D : 0 ), lp__);
            else
                s_raw = in__.vector_constrain((logical_eq(spatial_err, 1) ? D : 0 ));
            current_statement_begin__ = 103;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> sigma_s;
            (void) sigma_s;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_s = in__.vector_lb_constrain(0, (logical_eq(spatial_err, 1) ? 1 : 0 ), lp__);
            else
                sigma_s = in__.vector_lb_constrain(0, (logical_eq(spatial_err, 1) ? 1 : 0 ));
            current_statement_begin__ = 105;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> t_raw;
            (void) t_raw;  // dummy to suppress unused var warning
            if (jacobian__)
                t_raw = in__.matrix_constrain((logical_eq(temporal_err, 1) ? D : 0 ), (logical_eq(temporal_err, 1) ? TP : 0 ), lp__);
            else
                t_raw = in__.matrix_constrain((logical_eq(temporal_err, 1) ? D : 0 ), (logical_eq(temporal_err, 1) ? TP : 0 ));
            current_statement_begin__ = 106;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> sigma_t;
            (void) sigma_t;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_t = in__.vector_lb_constrain(0, (logical_eq(temporal_err, 1) ? 1 : 0 ), lp__);
            else
                sigma_t = in__.vector_lb_constrain(0, (logical_eq(temporal_err, 1) ? 1 : 0 ));
            current_statement_begin__ = 110;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> w;
            (void) w;  // dummy to suppress unused var warning
            if (jacobian__)
                w = in__.vector_lub_constrain(0.001, 0.999, (logical_eq(likelihood, 1) ? 1 : 0 ), lp__);
            else
                w = in__.vector_lub_constrain(0.001, 0.999, (logical_eq(likelihood, 1) ? 1 : 0 ));
            current_statement_begin__ = 111;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> p;
            (void) p;  // dummy to suppress unused var warning
            if (jacobian__)
                p = in__.vector_lub_constrain(0.001, 0.999, (logical_eq(likelihood, 1) ? 1 : 0 ), lp__);
            else
                p = in__.vector_lub_constrain(0.001, 0.999, (logical_eq(likelihood, 1) ? 1 : 0 ));
            current_statement_begin__ = 113;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> gamma_p0;
            (void) gamma_p0;  // dummy to suppress unused var warning
            if (jacobian__)
                gamma_p0 = in__.vector_constrain(((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 1))) ? P : 0 ), lp__);
            else
                gamma_p0 = in__.vector_constrain(((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 1))) ? P : 0 ));
            current_statement_begin__ = 114;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> gamma_p1;
            (void) gamma_p1;  // dummy to suppress unused var warning
            if (jacobian__)
                gamma_p1 = in__.vector_constrain(((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 0))) ? P : 0 ), lp__);
            else
                gamma_p1 = in__.vector_constrain(((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 0))) ? P : 0 ));
            current_statement_begin__ = 115;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> gamma0_p0;
            (void) gamma0_p0;  // dummy to suppress unused var warning
            if (jacobian__)
                gamma0_p0 = in__.vector_constrain(((primitive_value((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 1)))) && primitive_value(logical_eq(intercept, 1))) ? 1 : 0 ), lp__);
            else
                gamma0_p0 = in__.vector_constrain(((primitive_value((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 1)))) && primitive_value(logical_eq(intercept, 1))) ? 1 : 0 ));
            current_statement_begin__ = 116;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> gamma0_p1;
            (void) gamma0_p1;  // dummy to suppress unused var warning
            if (jacobian__)
                gamma0_p1 = in__.vector_constrain(((primitive_value((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 0)))) && primitive_value(logical_eq(intercept, 1))) ? 1 : 0 ), lp__);
            else
                gamma0_p1 = in__.vector_constrain(((primitive_value((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 0)))) && primitive_value(logical_eq(intercept, 1))) ? 1 : 0 ));
            // transformed parameters
            current_statement_begin__ = 121;
            validate_non_negative_index("beta", "P", P);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> beta(P);
            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta, DUMMY_VAR__);
            current_statement_begin__ = 123;
            validate_non_negative_index("tau", "(logical_eq(prior_coeff, 1) ? 1 : 0 )", (logical_eq(prior_coeff, 1) ? 1 : 0 ));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tau((logical_eq(prior_coeff, 1) ? 1 : 0 ));
            stan::math::initialize(tau, DUMMY_VAR__);
            stan::math::fill(tau, DUMMY_VAR__);
            current_statement_begin__ = 124;
            validate_non_negative_index("c2", "(logical_eq(prior_coeff, 1) ? 1 : 0 )", (logical_eq(prior_coeff, 1) ? 1 : 0 ));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> c2((logical_eq(prior_coeff, 1) ? 1 : 0 ));
            stan::math::initialize(c2, DUMMY_VAR__);
            stan::math::fill(c2, DUMMY_VAR__);
            current_statement_begin__ = 125;
            validate_non_negative_index("lambda_tilde", "(logical_eq(prior_coeff, 1) ? P : 0 )", (logical_eq(prior_coeff, 1) ? P : 0 ));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lambda_tilde((logical_eq(prior_coeff, 1) ? P : 0 ));
            stan::math::initialize(lambda_tilde, DUMMY_VAR__);
            stan::math::fill(lambda_tilde, DUMMY_VAR__);
            current_statement_begin__ = 128;
            validate_non_negative_index("theta", "M_is", M_is);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> theta(M_is);
            stan::math::initialize(theta, DUMMY_VAR__);
            stan::math::fill(theta, DUMMY_VAR__);
            current_statement_begin__ = 132;
            validate_non_negative_index("b1", "M_is", M_is);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> b1(M_is);
            stan::math::initialize(b1, DUMMY_VAR__);
            stan::math::fill(b1, DUMMY_VAR__);
            current_statement_begin__ = 133;
            validate_non_negative_index("a1", "M_is", M_is);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> a1(M_is);
            stan::math::initialize(a1, DUMMY_VAR__);
            stan::math::fill(a1, DUMMY_VAR__);
            current_statement_begin__ = 134;
            validate_non_negative_index("mu", "M_is", M_is);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> mu(M_is);
            stan::math::initialize(mu, DUMMY_VAR__);
            stan::math::fill(mu, DUMMY_VAR__);
            current_statement_begin__ = 137;
            validate_non_negative_index("phi", "(logical_eq(likelihood, 1) ? M_is : 0 )", (logical_eq(likelihood, 1) ? M_is : 0 ));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> phi((logical_eq(likelihood, 1) ? M_is : 0 ));
            stan::math::initialize(phi, DUMMY_VAR__);
            stan::math::fill(phi, DUMMY_VAR__);
            current_statement_begin__ = 138;
            validate_non_negative_index("lambda1", "(logical_eq(likelihood, 1) ? M_is : 0 )", (logical_eq(likelihood, 1) ? M_is : 0 ));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lambda1((logical_eq(likelihood, 1) ? M_is : 0 ));
            stan::math::initialize(lambda1, DUMMY_VAR__);
            stan::math::fill(lambda1, DUMMY_VAR__);
            current_statement_begin__ = 139;
            validate_non_negative_index("lambda2", "(logical_eq(likelihood, 1) ? M_is : 0 )", (logical_eq(likelihood, 1) ? M_is : 0 ));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lambda2((logical_eq(likelihood, 1) ? M_is : 0 ));
            stan::math::initialize(lambda2, DUMMY_VAR__);
            stan::math::fill(lambda2, DUMMY_VAR__);
            current_statement_begin__ = 140;
            validate_non_negative_index("b2", "(logical_eq(likelihood, 1) ? M_is : 0 )", (logical_eq(likelihood, 1) ? M_is : 0 ));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> b2((logical_eq(likelihood, 1) ? M_is : 0 ));
            stan::math::initialize(b2, DUMMY_VAR__);
            stan::math::fill(b2, DUMMY_VAR__);
            current_statement_begin__ = 141;
            validate_non_negative_index("a2", "(logical_eq(likelihood, 1) ? M_is : 0 )", (logical_eq(likelihood, 1) ? M_is : 0 ));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> a2((logical_eq(likelihood, 1) ? M_is : 0 ));
            stan::math::initialize(a2, DUMMY_VAR__);
            stan::math::fill(a2, DUMMY_VAR__);
            current_statement_begin__ = 144;
            validate_non_negative_index("p0", "((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 1))) ? M_is : 0 )", ((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 1))) ? M_is : 0 ));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> p0(((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 1))) ? M_is : 0 ));
            stan::math::initialize(p0, DUMMY_VAR__);
            stan::math::fill(p0, DUMMY_VAR__);
            current_statement_begin__ = 145;
            validate_non_negative_index("p1", "((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 0))) ? M_is : 0 )", ((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 0))) ? M_is : 0 ));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> p1(((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 0))) ? M_is : 0 ));
            stan::math::initialize(p1, DUMMY_VAR__);
            stan::math::fill(p1, DUMMY_VAR__);
            current_statement_begin__ = 148;
            validate_non_negative_index("v", "length_v", length_v);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> v(length_v);
            stan::math::initialize(v, DUMMY_VAR__);
            stan::math::fill(v, DUMMY_VAR__);
            current_statement_begin__ = 149;
            validate_non_negative_index("s", "(logical_eq(spatial_err, 1) ? D : 0 )", (logical_eq(spatial_err, 1) ? D : 0 ));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> s((logical_eq(spatial_err, 1) ? D : 0 ));
            stan::math::initialize(s, DUMMY_VAR__);
            stan::math::fill(s, DUMMY_VAR__);
            current_statement_begin__ = 150;
            validate_non_negative_index("t", "(logical_eq(temporal_err, 1) ? D : 0 )", (logical_eq(temporal_err, 1) ? D : 0 ));
            validate_non_negative_index("t", "(logical_eq(temporal_err, 1) ? TP : 0 )", (logical_eq(temporal_err, 1) ? TP : 0 ));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> t((logical_eq(temporal_err, 1) ? D : 0 ), (logical_eq(temporal_err, 1) ? TP : 0 ));
            stan::math::initialize(t, DUMMY_VAR__);
            stan::math::fill(t, DUMMY_VAR__);
            current_statement_begin__ = 152;
            validate_non_negative_index("reffs", "M_is", M_is);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> reffs(M_is);
            stan::math::initialize(reffs, DUMMY_VAR__);
            stan::math::fill(reffs, DUMMY_VAR__);
            current_statement_begin__ = 154;
            validate_non_negative_index("reffs_oos", "M_oos", M_oos);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> reffs_oos(M_oos);
            stan::math::initialize(reffs_oos, DUMMY_VAR__);
            stan::math::fill(reffs_oos, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 159;
            if (as_bool(logical_eq(prior_coeff, 0))) {
                current_statement_begin__ = 160;
                stan::math::assign(beta, z_beta);
            } else if (as_bool(logical_eq(prior_coeff, 1))) {
                current_statement_begin__ = 162;
                stan::model::assign(tau, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            (tau0 * get_base1(z_tau, 1, "z_tau", 1)), 
                            "assigning variable tau");
                current_statement_begin__ = 163;
                stan::model::assign(c2, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            (slab_scale2 * get_base1(z_c2, 1, "z_c2", 1)), 
                            "assigning variable c2");
                current_statement_begin__ = 164;
                stan::math::assign(lambda_tilde, stan::math::sqrt(elt_divide(multiply(get_base1(c2, 1, "c2", 1), square(lambda_HS)), add(get_base1(c2, 1, "c2", 1), multiply(square(get_base1(tau, 1, "tau", 1)), square(lambda_HS))))));
                current_statement_begin__ = 165;
                stan::math::assign(beta, elt_multiply(multiply(get_base1(tau, 1, "tau", 1), lambda_tilde), z_beta));
            }
            current_statement_begin__ = 169;
            if (as_bool(logical_eq(spatio_temporal, 0))) {
                current_statement_begin__ = 170;
                if (as_bool(logical_eq(prior_reff, 0))) {
                    current_statement_begin__ = 171;
                    stan::math::assign(v, multiply(get_base1(sigma_v, 1, "sigma_v", 1), v_raw));
                } else if (as_bool(logical_eq(prior_reff, 1))) {
                    current_statement_begin__ = 173;
                    stan::math::assign(v, multiply(get_base1(sigma_v, 1, "sigma_v", 1), v_raw));
                } else if (as_bool(logical_eq(prior_reff, 2))) {
                    current_statement_begin__ = 175;
                    stan::math::assign(v, elt_multiply(multiply(stan::math::sqrt(psi_d), get_base1(lambda, 1, "lambda", 1)), v_raw));
                }
            }
            current_statement_begin__ = 180;
            if (as_bool((primitive_value(logical_eq(spatial_err, 0)) && primitive_value(logical_eq(temporal_err, 0))))) {
                current_statement_begin__ = 181;
                stan::math::assign(reffs, v);
                current_statement_begin__ = 182;
                for (int i = 1; i <= M_oos; ++i) {
                    current_statement_begin__ = 183;
                    stan::model::assign(reffs_oos, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                0, 
                                "assigning variable reffs_oos");
                }
            } else {
                current_statement_begin__ = 186;
                if (as_bool((primitive_value(logical_eq(spatial_err, 1)) && primitive_value(logical_eq(temporal_err, 0))))) {
                    current_statement_begin__ = 187;
                    for (int i = 1; i <= D; ++i) {
                        current_statement_begin__ = 188;
                        stan::model::assign(s, 
                                    stan::model::cons_list(stan::model::index_uni(get_base1(indices_spat, i, "indices_spat", 1)), stan::model::nil_index_list()), 
                                    ((get_base1(sigma_s, 1, "sigma_s", 1) * get_base1(s_raw, i, "s_raw", 1)) / get_base1(scales_ICAR, i, "scales_ICAR", 1)), 
                                    "assigning variable s");
                    }
                    current_statement_begin__ = 190;
                    for (int i = 1; i <= M_is; ++i) {
                        current_statement_begin__ = 191;
                        stan::model::assign(reffs, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (get_base1(v, i, "v", 1) + get_base1(s, get_base1(indices_is, i, "indices_is", 1), "s", 1)), 
                                    "assigning variable reffs");
                    }
                    current_statement_begin__ = 193;
                    for (int i = 1; i <= M_oos; ++i) {
                        current_statement_begin__ = 194;
                        stan::model::assign(reffs_oos, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    get_base1(s, get_base1(indices_oos, i, "indices_oos", 1), "s", 1), 
                                    "assigning variable reffs_oos");
                    }
                }
                current_statement_begin__ = 197;
                if (as_bool((primitive_value(logical_eq(spatial_err, 0)) && primitive_value(logical_eq(temporal_err, 1))))) {
                    current_statement_begin__ = 198;
                    stan::math::assign(t, divide(multiply(get_base1(sigma_t, 1, "sigma_t", 1), t_raw), scale_factor_RW1));
                    current_statement_begin__ = 199;
                    for (int i = 1; i <= M_is; ++i) {
                        current_statement_begin__ = 200;
                        stan::model::assign(reffs, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (get_base1(v, get_base1(get_base1(indices_temp, get_base1(indices_is, i, "indices_is", 1), "indices_temp", 1), 1, "indices_temp", 2), "v", 1) + get_base1(t, get_base1(get_base1(indices_temp, get_base1(indices_is, i, "indices_is", 1), "indices_temp", 1), 1, "indices_temp", 2), get_base1(get_base1(indices_temp, get_base1(indices_is, i, "indices_is", 1), "indices_temp", 1), 2, "indices_temp", 2), "t", 1)), 
                                    "assigning variable reffs");
                    }
                    current_statement_begin__ = 203;
                    for (int i = 1; i <= M_oos; ++i) {
                        current_statement_begin__ = 204;
                        if (as_bool(logical_eq(get_base1(cat_ios, i, "cat_ios", 1), 1))) {
                            current_statement_begin__ = 205;
                            stan::model::assign(reffs_oos, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        0, 
                                        "assigning variable reffs_oos");
                        }
                        current_statement_begin__ = 207;
                        if (as_bool(logical_eq(get_base1(cat_ios, i, "cat_ios", 1), 2))) {
                            current_statement_begin__ = 208;
                            stan::model::assign(reffs_oos, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        get_base1(v, get_base1(get_base1(indices_temp, get_base1(indices_oos, i, "indices_oos", 1), "indices_temp", 1), 1, "indices_temp", 2), "v", 1), 
                                        "assigning variable reffs_oos");
                        }
                        current_statement_begin__ = 210;
                        if (as_bool(logical_eq(get_base1(cat_ios, i, "cat_ios", 1), 3))) {
                            current_statement_begin__ = 211;
                            stan::model::assign(reffs_oos, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        (get_base1(v, get_base1(get_base1(indices_temp, get_base1(indices_oos, i, "indices_oos", 1), "indices_temp", 1), 1, "indices_temp", 2), "v", 1) + get_base1(t, get_base1(get_base1(indices_temp, get_base1(indices_oos, i, "indices_oos", 1), "indices_temp", 1), 1, "indices_temp", 2), get_base1(get_base1(indices_temp, get_base1(indices_oos, i, "indices_oos", 1), "indices_temp", 1), 2, "indices_temp", 2), "t", 1)), 
                                        "assigning variable reffs_oos");
                        }
                    }
                }
                current_statement_begin__ = 216;
                if (as_bool((primitive_value(logical_eq(spatial_err, 1)) && primitive_value(logical_eq(temporal_err, 1))))) {
                    current_statement_begin__ = 217;
                    stan::math::assign(t, divide(multiply(get_base1(sigma_t, 1, "sigma_t", 1), t_raw), scale_factor_RW1));
                    current_statement_begin__ = 218;
                    for (int i = 1; i <= D; ++i) {
                        current_statement_begin__ = 219;
                        stan::model::assign(s, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    ((get_base1(sigma_s, 1, "sigma_s", 1) * get_base1(s_raw, get_base1(indices_spat, i, "indices_spat", 1), "s_raw", 1)) / get_base1(scales_ICAR, get_base1(indices_spat, i, "indices_spat", 1), "scales_ICAR", 1)), 
                                    "assigning variable s");
                    }
                    current_statement_begin__ = 221;
                    for (int i = 1; i <= M_is; ++i) {
                        current_statement_begin__ = 222;
                        stan::model::assign(reffs, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (get_base1(s, get_base1(get_base1(indices_temp, get_base1(indices_is, i, "indices_is", 1), "indices_temp", 1), 1, "indices_temp", 2), "s", 1) + get_base1(t, get_base1(get_base1(indices_temp, get_base1(indices_is, i, "indices_is", 1), "indices_temp", 1), 1, "indices_temp", 2), get_base1(get_base1(indices_temp, get_base1(indices_is, i, "indices_is", 1), "indices_temp", 1), 2, "indices_temp", 2), "t", 1)), 
                                    "assigning variable reffs");
                    }
                    current_statement_begin__ = 225;
                    for (int i = 1; i <= M_oos; ++i) {
                        current_statement_begin__ = 226;
                        if (as_bool(logical_eq(get_base1(cat_ios, i, "cat_ios", 1), 1))) {
                            current_statement_begin__ = 227;
                            stan::model::assign(reffs_oos, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        (get_base1(s, get_base1(get_base1(indices_temp, get_base1(indices_oos, i, "indices_oos", 1), "indices_temp", 1), 1, "indices_temp", 2), "s", 1) + get_base1(t, get_base1(get_base1(indices_temp, get_base1(indices_oos, i, "indices_oos", 1), "indices_temp", 1), 1, "indices_temp", 2), get_base1(get_base1(indices_temp, get_base1(indices_oos, i, "indices_oos", 1), "indices_temp", 1), 2, "indices_temp", 2), "t", 1)), 
                                        "assigning variable reffs_oos");
                        }
                        current_statement_begin__ = 230;
                        if (as_bool(logical_eq(get_base1(cat_ios, i, "cat_ios", 1), 2))) {
                            current_statement_begin__ = 231;
                            stan::model::assign(reffs_oos, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        (get_base1(s, get_base1(get_base1(indices_temp, get_base1(indices_oos, i, "indices_oos", 1), "indices_temp", 1), 1, "indices_temp", 2), "s", 1) + get_base1(t, get_base1(get_base1(indices_temp, get_base1(indices_oos, i, "indices_oos", 1), "indices_temp", 1), 1, "indices_temp", 2), get_base1(get_base1(indices_temp, get_base1(indices_oos, i, "indices_oos", 1), "indices_temp", 1), 2, "indices_temp", 2), "t", 1)), 
                                        "assigning variable reffs_oos");
                        }
                        current_statement_begin__ = 234;
                        if (as_bool(logical_eq(get_base1(cat_ios, i, "cat_ios", 1), 3))) {
                            current_statement_begin__ = 235;
                            stan::model::assign(reffs_oos, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        (get_base1(s, get_base1(get_base1(indices_temp, get_base1(indices_oos, i, "indices_oos", 1), "indices_temp", 1), 1, "indices_temp", 2), "s", 1) + get_base1(t, get_base1(get_base1(indices_temp, get_base1(indices_oos, i, "indices_oos", 1), "indices_temp", 1), 1, "indices_temp", 2), get_base1(get_base1(indices_temp, get_base1(indices_oos, i, "indices_oos", 1), "indices_temp", 1), 2, "indices_temp", 2), "t", 1)), 
                                        "assigning variable reffs_oos");
                        }
                    }
                }
            }
            current_statement_begin__ = 245;
            if (as_bool(logical_eq(likelihood, 0))) {
                current_statement_begin__ = 256;
                for (int i = 1; i <= M_is; ++i) {
                    current_statement_begin__ = 257;
                    if (as_bool(logical_eq(intercept, 0))) {
                        current_statement_begin__ = 258;
                        stan::model::assign(mu, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    inv_logit((multiply(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X"), beta) + get_base1(reffs, i, "reffs", 1))), 
                                    "assigning variable mu");
                    } else {
                        current_statement_begin__ = 260;
                        stan::model::assign(mu, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    inv_logit(((get_base1(beta0, 1, "beta0", 1) + multiply(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X"), beta)) + get_base1(reffs, i, "reffs", 1))), 
                                    "assigning variable mu");
                    }
                    current_statement_begin__ = 262;
                    stan::model::assign(theta, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                get_base1(mu, i, "mu", 1), 
                                "assigning variable theta");
                    current_statement_begin__ = 264;
                    if (as_bool(logical_eq(deff, 0))) {
                        current_statement_begin__ = 265;
                        stan::model::assign(b1, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    ((1 - get_base1(mu, i, "mu", 1)) * (((get_base1(mu, i, "mu", 1) * (1 - get_base1(mu, i, "mu", 1))) / get_base1(disp, i, "disp", 1)) - 1)), 
                                    "assigning variable b1");
                        current_statement_begin__ = 266;
                        stan::model::assign(a1, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (get_base1(mu, i, "mu", 1) * (((get_base1(mu, i, "mu", 1) * (1 - get_base1(mu, i, "mu", 1))) / get_base1(disp, i, "disp", 1)) - 1)), 
                                    "assigning variable a1");
                    } else {
                        current_statement_begin__ = 268;
                        stan::model::assign(b1, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    ((1 - get_base1(mu, i, "mu", 1)) * get_base1(disp, i, "disp", 1)), 
                                    "assigning variable b1");
                        current_statement_begin__ = 269;
                        stan::model::assign(a1, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (get_base1(mu, i, "mu", 1) * get_base1(disp, i, "disp", 1)), 
                                    "assigning variable a1");
                    }
                }
            } else if (as_bool(logical_eq(likelihood, 1))) {
                current_statement_begin__ = 277;
                for (int i = 1; i <= M_is; ++i) {
                    current_statement_begin__ = 278;
                    if (as_bool(logical_eq(intercept, 0))) {
                        current_statement_begin__ = 279;
                        stan::model::assign(lambda2, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    inv_logit((multiply(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X"), beta) + get_base1(reffs, i, "reffs", 1))), 
                                    "assigning variable lambda2");
                    } else {
                        current_statement_begin__ = 281;
                        stan::model::assign(lambda2, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    inv_logit(((get_base1(beta0, 1, "beta0", 1) + multiply(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X"), beta)) + get_base1(reffs, i, "reffs", 1))), 
                                    "assigning variable lambda2");
                    }
                    current_statement_begin__ = 283;
                    stan::model::assign(lambda1, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (get_base1(lambda2, i, "lambda2", 1) + (get_base1(w, 1, "w", 1) * stan::math::fmin(((1 - get_base1(lambda2, i, "lambda2", 1)) / get_base1(p, 1, "p", 1)), stan::math::sqrt((get_base1(disp, i, "disp", 1) / (get_base1(p, 1, "p", 1) * (1 - get_base1(p, 1, "p", 1)))))))), 
                                "assigning variable lambda1");
                    current_statement_begin__ = 284;
                    stan::model::assign(mu, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                ((get_base1(p, 1, "p", 1) * get_base1(lambda1, i, "lambda1", 1)) + ((1 - get_base1(p, 1, "p", 1)) * get_base1(lambda2, i, "lambda2", 1))), 
                                "assigning variable mu");
                    current_statement_begin__ = 285;
                    stan::model::assign(theta, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                get_base1(mu, i, "mu", 1), 
                                "assigning variable theta");
                    current_statement_begin__ = 286;
                    stan::model::assign(phi, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (((get_base1(mu, i, "mu", 1) * (1 - get_base1(mu, i, "mu", 1))) - get_base1(disp, i, "disp", 1)) / (get_base1(disp, i, "disp", 1) - (((get_base1(p, 1, "p", 1) * (1 - get_base1(p, 1, "p", 1))) * pow(get_base1(w, 1, "w", 1), 2)) * pow(stan::math::fmin(((1 - get_base1(lambda2, i, "lambda2", 1)) / get_base1(p, 1, "p", 1)), stan::math::sqrt((get_base1(disp, i, "disp", 1) / (get_base1(p, 1, "p", 1) * (1 - get_base1(p, 1, "p", 1)))))), 2)))), 
                                "assigning variable phi");
                    current_statement_begin__ = 289;
                    stan::model::assign(b1, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                ((1 - get_base1(lambda2, i, "lambda2", 1)) * get_base1(phi, i, "phi", 1)), 
                                "assigning variable b1");
                    current_statement_begin__ = 290;
                    stan::model::assign(a1, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (get_base1(lambda2, i, "lambda2", 1) * get_base1(phi, i, "phi", 1)), 
                                "assigning variable a1");
                    current_statement_begin__ = 291;
                    stan::model::assign(b2, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                ((1 - get_base1(lambda1, i, "lambda1", 1)) * get_base1(phi, i, "phi", 1)), 
                                "assigning variable b2");
                    current_statement_begin__ = 292;
                    stan::model::assign(a2, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (get_base1(lambda1, i, "lambda1", 1) * get_base1(phi, i, "phi", 1)), 
                                "assigning variable a2");
                }
            } else if (as_bool(logical_eq(likelihood, 2))) {
                current_statement_begin__ = 331;
                for (int i = 1; i <= M_is; ++i) {
                    current_statement_begin__ = 332;
                    if (as_bool(logical_eq(intercept, 0))) {
                        current_statement_begin__ = 333;
                        stan::model::assign(mu, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    inv_logit((multiply(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X"), beta) + get_base1(reffs, i, "reffs", 1))), 
                                    "assigning variable mu");
                    } else {
                        current_statement_begin__ = 335;
                        stan::model::assign(mu, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    inv_logit(((get_base1(beta0, 1, "beta0", 1) + multiply(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X"), beta)) + get_base1(reffs, i, "reffs", 1))), 
                                    "assigning variable mu");
                    }
                    current_statement_begin__ = 337;
                    if (as_bool(logical_neq(inflation, 1))) {
                        current_statement_begin__ = 338;
                        if (as_bool(logical_eq(intercept, 0))) {
                            current_statement_begin__ = 339;
                            stan::model::assign(p0, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        inv_logit(multiply(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X"), gamma_p0)), 
                                        "assigning variable p0");
                        } else {
                            current_statement_begin__ = 341;
                            stan::model::assign(p0, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        inv_logit((get_base1(gamma0_p0, 1, "gamma0_p0", 1) + multiply(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X"), gamma_p0))), 
                                        "assigning variable p0");
                        }
                    }
                    current_statement_begin__ = 344;
                    if (as_bool(logical_neq(inflation, 0))) {
                        current_statement_begin__ = 345;
                        if (as_bool(logical_eq(intercept, 0))) {
                            current_statement_begin__ = 346;
                            stan::model::assign(p1, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        inv_logit(multiply(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X"), gamma_p1)), 
                                        "assigning variable p1");
                        } else {
                            current_statement_begin__ = 348;
                            stan::model::assign(p1, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        inv_logit((get_base1(gamma0_p1, 1, "gamma0_p1", 1) + multiply(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X"), gamma_p1))), 
                                        "assigning variable p1");
                        }
                    }
                    current_statement_begin__ = 351;
                    if (as_bool(logical_eq(inflation, 0))) {
                        current_statement_begin__ = 352;
                        stan::model::assign(theta, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    ((1 - get_base1(p0, i, "p0", 1)) * get_base1(mu, i, "mu", 1)), 
                                    "assigning variable theta");
                    } else if (as_bool(logical_eq(inflation, 1))) {
                        current_statement_begin__ = 354;
                        stan::model::assign(theta, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (((1 - get_base1(p1, i, "p1", 1)) * get_base1(mu, i, "mu", 1)) + get_base1(p1, i, "p1", 1)), 
                                    "assigning variable theta");
                    } else if (as_bool(logical_eq(inflation, 2))) {
                        current_statement_begin__ = 356;
                        stan::model::assign(theta, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    ((((1 - get_base1(p0, i, "p0", 1)) - get_base1(p1, i, "p1", 1)) * get_base1(mu, i, "mu", 1)) + get_base1(p1, i, "p1", 1)), 
                                    "assigning variable theta");
                    }
                    current_statement_begin__ = 358;
                    if (as_bool(logical_eq(deff, 0))) {
                        current_statement_begin__ = 359;
                        stan::model::assign(b1, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    ((1 - get_base1(mu, i, "mu", 1)) * (((get_base1(mu, i, "mu", 1) * (1 - get_base1(mu, i, "mu", 1))) / get_base1(disp, i, "disp", 1)) - 1)), 
                                    "assigning variable b1");
                        current_statement_begin__ = 360;
                        stan::model::assign(a1, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (get_base1(mu, i, "mu", 1) * (((get_base1(mu, i, "mu", 1) * (1 - get_base1(mu, i, "mu", 1))) / get_base1(disp, i, "disp", 1)) - 1)), 
                                    "assigning variable a1");
                    } else {
                        current_statement_begin__ = 362;
                        stan::model::assign(b1, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    ((1 - get_base1(mu, i, "mu", 1)) * get_base1(disp, i, "disp", 1)), 
                                    "assigning variable b1");
                        current_statement_begin__ = 363;
                        stan::model::assign(a1, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (get_base1(mu, i, "mu", 1) * get_base1(disp, i, "disp", 1)), 
                                    "assigning variable a1");
                    }
                }
            } else if (as_bool(logical_eq(likelihood, 3))) {
                current_statement_begin__ = 379;
                for (int i = 1; i <= M_is; ++i) {
                    current_statement_begin__ = 380;
                    if (as_bool(logical_eq(intercept, 0))) {
                        current_statement_begin__ = 381;
                        stan::model::assign(mu, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    inv_logit((multiply(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X"), beta) + get_base1(reffs, i, "reffs", 1))), 
                                    "assigning variable mu");
                    } else {
                        current_statement_begin__ = 383;
                        stan::model::assign(mu, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    inv_logit(((get_base1(beta0, 1, "beta0", 1) + multiply(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X"), beta)) + get_base1(reffs, i, "reffs", 1))), 
                                    "assigning variable mu");
                    }
                    current_statement_begin__ = 385;
                    stan::model::assign(theta, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (get_base1(mu, i, "mu", 1) * (1 - pow((1 - get_base1(mu, i, "mu", 1)), get_base1(m_d, i, "m_d", 1)))), 
                                "assigning variable theta");
                    current_statement_begin__ = 386;
                    if (as_bool(logical_eq(deff, 0))) {
                        current_statement_begin__ = 387;
                        stan::model::assign(b1, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    ((1 - get_base1(mu, i, "mu", 1)) * (((get_base1(mu, i, "mu", 1) * (1 - get_base1(mu, i, "mu", 1))) / get_base1(disp, i, "disp", 1)) - 1)), 
                                    "assigning variable b1");
                        current_statement_begin__ = 388;
                        stan::model::assign(a1, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (get_base1(mu, i, "mu", 1) * (((get_base1(mu, i, "mu", 1) * (1 - get_base1(mu, i, "mu", 1))) / get_base1(disp, i, "disp", 1)) - 1)), 
                                    "assigning variable a1");
                    } else {
                        current_statement_begin__ = 390;
                        stan::model::assign(b1, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    ((1 - get_base1(mu, i, "mu", 1)) * get_base1(disp, i, "disp", 1)), 
                                    "assigning variable b1");
                        current_statement_begin__ = 391;
                        stan::model::assign(a1, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (get_base1(mu, i, "mu", 1) * get_base1(disp, i, "disp", 1)), 
                                    "assigning variable a1");
                    }
                }
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 121;
            size_t beta_j_1_max__ = P;
            for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(beta(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: beta" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable beta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 123;
            size_t tau_j_1_max__ = (logical_eq(prior_coeff, 1) ? 1 : 0 );
            for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(tau(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: tau" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable tau: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "tau", tau, 0);
            current_statement_begin__ = 124;
            size_t c2_j_1_max__ = (logical_eq(prior_coeff, 1) ? 1 : 0 );
            for (size_t j_1__ = 0; j_1__ < c2_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(c2(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: c2" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable c2: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "c2", c2, 0);
            current_statement_begin__ = 125;
            size_t lambda_tilde_j_1_max__ = (logical_eq(prior_coeff, 1) ? P : 0 );
            for (size_t j_1__ = 0; j_1__ < lambda_tilde_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(lambda_tilde(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: lambda_tilde" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable lambda_tilde: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "lambda_tilde", lambda_tilde, 0);
            current_statement_begin__ = 128;
            size_t theta_j_1_max__ = M_is;
            for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(theta(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: theta" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable theta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "theta", theta, 0);
            check_less_or_equal(function__, "theta", theta, 1);
            current_statement_begin__ = 132;
            size_t b1_j_1_max__ = M_is;
            for (size_t j_1__ = 0; j_1__ < b1_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(b1(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: b1" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable b1: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "b1", b1, 0);
            current_statement_begin__ = 133;
            size_t a1_j_1_max__ = M_is;
            for (size_t j_1__ = 0; j_1__ < a1_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(a1(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: a1" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable a1: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "a1", a1, 0);
            current_statement_begin__ = 134;
            size_t mu_j_1_max__ = M_is;
            for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(mu(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: mu" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable mu: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "mu", mu, 0);
            check_less_or_equal(function__, "mu", mu, 1);
            current_statement_begin__ = 137;
            size_t phi_j_1_max__ = (logical_eq(likelihood, 1) ? M_is : 0 );
            for (size_t j_1__ = 0; j_1__ < phi_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(phi(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: phi" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable phi: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "phi", phi, 0);
            current_statement_begin__ = 138;
            size_t lambda1_j_1_max__ = (logical_eq(likelihood, 1) ? M_is : 0 );
            for (size_t j_1__ = 0; j_1__ < lambda1_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(lambda1(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: lambda1" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable lambda1: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "lambda1", lambda1, 0);
            check_less_or_equal(function__, "lambda1", lambda1, 1);
            current_statement_begin__ = 139;
            size_t lambda2_j_1_max__ = (logical_eq(likelihood, 1) ? M_is : 0 );
            for (size_t j_1__ = 0; j_1__ < lambda2_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(lambda2(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: lambda2" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable lambda2: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "lambda2", lambda2, 0);
            check_less_or_equal(function__, "lambda2", lambda2, 1);
            current_statement_begin__ = 140;
            size_t b2_j_1_max__ = (logical_eq(likelihood, 1) ? M_is : 0 );
            for (size_t j_1__ = 0; j_1__ < b2_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(b2(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: b2" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable b2: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "b2", b2, 0);
            current_statement_begin__ = 141;
            size_t a2_j_1_max__ = (logical_eq(likelihood, 1) ? M_is : 0 );
            for (size_t j_1__ = 0; j_1__ < a2_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(a2(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: a2" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable a2: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "a2", a2, 0);
            current_statement_begin__ = 144;
            size_t p0_j_1_max__ = ((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 1))) ? M_is : 0 );
            for (size_t j_1__ = 0; j_1__ < p0_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(p0(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: p0" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable p0: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "p0", p0, 0);
            check_less_or_equal(function__, "p0", p0, 1);
            current_statement_begin__ = 145;
            size_t p1_j_1_max__ = ((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 0))) ? M_is : 0 );
            for (size_t j_1__ = 0; j_1__ < p1_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(p1(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: p1" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable p1: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "p1", p1, 0);
            check_less_or_equal(function__, "p1", p1, 1);
            current_statement_begin__ = 148;
            size_t v_j_1_max__ = length_v;
            for (size_t j_1__ = 0; j_1__ < v_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(v(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: v" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable v: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 149;
            size_t s_j_1_max__ = (logical_eq(spatial_err, 1) ? D : 0 );
            for (size_t j_1__ = 0; j_1__ < s_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(s(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: s" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable s: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 150;
            size_t t_j_1_max__ = (logical_eq(temporal_err, 1) ? D : 0 );
            size_t t_j_2_max__ = (logical_eq(temporal_err, 1) ? TP : 0 );
            for (size_t j_1__ = 0; j_1__ < t_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < t_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(t(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: t" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable t: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 152;
            size_t reffs_j_1_max__ = M_is;
            for (size_t j_1__ = 0; j_1__ < reffs_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(reffs(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: reffs" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable reffs: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 154;
            size_t reffs_oos_j_1_max__ = M_oos;
            for (size_t j_1__ = 0; j_1__ < reffs_oos_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(reffs_oos(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: reffs_oos" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable reffs_oos: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            // model body
            {
            current_statement_begin__ = 400;
            int pos(0);
            (void) pos;  // dummy to suppress unused var warning
            stan::math::fill(pos, std::numeric_limits<int>::min());
            current_statement_begin__ = 401;
            stan::math::assign(pos, 1);
            current_statement_begin__ = 404;
            if (as_bool(logical_eq(intercept, 1))) {
                current_statement_begin__ = 405;
                lp_accum__.add(normal_log<propto__>(get_base1(beta0, 1, "beta0", 1), 0, sigma_coeff));
            }
            current_statement_begin__ = 407;
            if (as_bool(logical_eq(prior_coeff, 0))) {
                current_statement_begin__ = 408;
                lp_accum__.add(normal_log<propto__>(z_beta, 0, sigma_coeff));
            } else if (as_bool(logical_eq(prior_coeff, 1))) {
                current_statement_begin__ = 410;
                lp_accum__.add(normal_log<propto__>(z_beta, 0, 1));
                current_statement_begin__ = 411;
                lp_accum__.add(cauchy_log<propto__>(lambda_HS, 0, 1));
                current_statement_begin__ = 412;
                lp_accum__.add(cauchy_log<propto__>(get_base1(z_tau, 1, "z_tau", 1), 0, 1));
                current_statement_begin__ = 413;
                lp_accum__.add(inv_gamma_log<propto__>(get_base1(z_c2, 1, "z_c2", 1), half_nu, half_nu));
            }
            current_statement_begin__ = 417;
            if (as_bool(logical_eq(spatio_temporal, 0))) {
                current_statement_begin__ = 418;
                if (as_bool(logical_eq(prior_reff, 0))) {
                    current_statement_begin__ = 419;
                    lp_accum__.add(std_normal_log<propto__>(v_raw));
                    current_statement_begin__ = 420;
                    lp_accum__.add(normal_log<propto__>(get_base1(sigma_v, 1, "sigma_v", 1), 0, sigma_unstr));
                    if (get_base1(sigma_v, 1, "sigma_v", 1) < 0) lp_accum__.add(-std::numeric_limits<double>::infinity());
                    else lp_accum__.add(-normal_ccdf_log(0, 0, sigma_unstr));
                } else if (as_bool(logical_eq(prior_reff, 1))) {
                    current_statement_begin__ = 422;
                    lp_accum__.add(student_t_log<propto__>(v_raw, get_base1(nu, 1, "nu", 1), 0, 1));
                    current_statement_begin__ = 423;
                    lp_accum__.add(normal_log<propto__>(get_base1(sigma_v, 1, "sigma_v", 1), 0, sigma_unstr));
                    if (get_base1(sigma_v, 1, "sigma_v", 1) < 0) lp_accum__.add(-std::numeric_limits<double>::infinity());
                    else lp_accum__.add(-normal_ccdf_log(0, 0, sigma_unstr));
                    current_statement_begin__ = 424;
                    lp_accum__.add(exponential_log<propto__>(get_base1(nu, 1, "nu", 1), 0.1));
                } else if (as_bool(logical_eq(prior_reff, 2))) {
                    current_statement_begin__ = 426;
                    lp_accum__.add(std_normal_log<propto__>(v_raw));
                    current_statement_begin__ = 427;
                    lp_accum__.add(gamma_log<propto__>(psi_d, 0.5, 1));
                    current_statement_begin__ = 428;
                    lp_accum__.add(normal_log<propto__>(get_base1(lambda, 1, "lambda", 1), 0, sigma_unstr));
                }
            }
            current_statement_begin__ = 432;
            if (as_bool(logical_eq(spatial_err, 1))) {
                current_statement_begin__ = 433;
                lp_accum__.add(normal_log<propto__>(get_base1(sigma_s, 1, "sigma_s", 1), 0, 2.5));
                if (get_base1(sigma_s, 1, "sigma_s", 1) < 0) lp_accum__.add(-std::numeric_limits<double>::infinity());
                else lp_accum__.add(-normal_ccdf_log(0, 0, 2.5));
                current_statement_begin__ = 434;
                for (int k = 1; k <= N_comp; ++k) {
                    current_statement_begin__ = 435;
                    if (as_bool(logical_eq(get_base1(dim_c, k, "dim_c", 1), 1))) {
                        current_statement_begin__ = 436;
                        lp_accum__.add(normal_log<propto__>(segment(s_raw, pos, get_base1(dim_c, k, "dim_c", 1)), 0, 1));
                    }
                    current_statement_begin__ = 438;
                    if (as_bool(logical_gt(get_base1(dim_c, k, "dim_c", 1), 1))) {
                        current_statement_begin__ = 439;
                        lp_accum__.add(normal_log<propto__>(sum(segment(s_raw, pos, get_base1(dim_c, k, "dim_c", 1))), 0, (0.001 * get_base1(dim_c, k, "dim_c", 1))));
                    }
                    current_statement_begin__ = 441;
                    stan::math::assign(pos, (pos + get_base1(dim_c, k, "dim_c", 1)));
                }
                current_statement_begin__ = 443;
                lp_accum__.add((-(0.5) * dot_self(subtract(stan::model::rvalue(s_raw, stan::model::cons_list(stan::model::index_multi(node1), stan::model::nil_index_list()), "s_raw"), stan::model::rvalue(s_raw, stan::model::cons_list(stan::model::index_multi(node2), stan::model::nil_index_list()), "s_raw")))));
            }
            current_statement_begin__ = 447;
            if (as_bool(logical_eq(temporal_err, 1))) {
                current_statement_begin__ = 448;
                lp_accum__.add(normal_log<propto__>(get_base1(sigma_t, 1, "sigma_t", 1), 0, 2.5));
                if (get_base1(sigma_t, 1, "sigma_t", 1) < 0) lp_accum__.add(-std::numeric_limits<double>::infinity());
                else lp_accum__.add(-normal_ccdf_log(0, 0, 2.5));
                current_statement_begin__ = 449;
                for (int i = 1; i <= D; ++i) {
                    current_statement_begin__ = 450;
                    lp_accum__.add(normal_log<propto__>(sum(stan::model::rvalue(t_raw, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "t_raw")), 0, (0.001 * TP)));
                    current_statement_begin__ = 451;
                    lp_accum__.add((-(0.5) * dot_self(subtract(stan::model::rvalue(t_raw, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_multi(node1_t), stan::model::nil_index_list())), "t_raw"), stan::model::rvalue(t_raw, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_multi(node2_t), stan::model::nil_index_list())), "t_raw")))));
                }
            }
            current_statement_begin__ = 456;
            if (as_bool(logical_eq(likelihood, 1))) {
                current_statement_begin__ = 457;
                lp_accum__.add(beta_log<propto__>(get_base1(p, 1, "p", 1), 2, 2));
                current_statement_begin__ = 458;
                lp_accum__.add(uniform_log<propto__>(get_base1(w, 1, "w", 1), 0.001, 0.999));
            }
            current_statement_begin__ = 460;
            if (as_bool(logical_eq(likelihood, 2))) {
                current_statement_begin__ = 461;
                if (as_bool(logical_neq(inflation, 1))) {
                    current_statement_begin__ = 462;
                    lp_accum__.add(normal_log<propto__>(gamma_p0, 0, 2.5));
                    current_statement_begin__ = 463;
                    if (as_bool(logical_eq(intercept, 1))) {
                        current_statement_begin__ = 464;
                        lp_accum__.add(normal_log<propto__>(get_base1(gamma0_p0, 1, "gamma0_p0", 1), 0, 2.5));
                    }
                }
                current_statement_begin__ = 467;
                if (as_bool(logical_neq(inflation, 0))) {
                    current_statement_begin__ = 468;
                    lp_accum__.add(normal_log<propto__>(gamma_p1, 0, 2.5));
                    current_statement_begin__ = 469;
                    if (as_bool(logical_eq(intercept, 1))) {
                        current_statement_begin__ = 470;
                        lp_accum__.add(normal_log<propto__>(get_base1(gamma0_p1, 1, "gamma0_p1", 1), 0, 2.5));
                    }
                }
            }
            current_statement_begin__ = 476;
            if (as_bool(logical_eq(likelihood, 0))) {
                current_statement_begin__ = 477;
                for (int i = 1; i <= M_is; ++i) {
                    current_statement_begin__ = 478;
                    lp_accum__.add(beta_log(get_base1(y, i, "y", 1), get_base1(a1, i, "a1", 1), get_base1(b1, i, "b1", 1)));
                }
            } else if (as_bool(logical_eq(likelihood, 1))) {
                current_statement_begin__ = 481;
                for (int i = 1; i <= M_is; ++i) {
                    current_statement_begin__ = 482;
                    lp_accum__.add(log_mix(get_base1(p, 1, "p", 1), beta_log(get_base1(y, i, "y", 1), get_base1(a2, i, "a2", 1), get_base1(b2, i, "b2", 1)), beta_log(get_base1(y, i, "y", 1), get_base1(a1, i, "a1", 1), get_base1(b1, i, "b1", 1))));
                }
            } else if (as_bool(logical_eq(likelihood, 2))) {
                current_statement_begin__ = 486;
                for (int i = 1; i <= M_is; ++i) {
                    current_statement_begin__ = 487;
                    if (as_bool((primitive_value(logical_eq(get_base1(y, i, "y", 1), 0)) && primitive_value(logical_neq(inflation, 1))))) {
                        current_statement_begin__ = 488;
                        lp_accum__.add(stan::math::log(get_base1(p0, i, "p0", 1)));
                    } else if (as_bool((primitive_value(logical_eq(get_base1(y, i, "y", 1), 1)) && primitive_value(logical_neq(inflation, 0))))) {
                        current_statement_begin__ = 490;
                        lp_accum__.add(stan::math::log(get_base1(p1, i, "p1", 1)));
                    } else {
                        current_statement_begin__ = 492;
                        lp_accum__.add(beta_log(get_base1(y, i, "y", 1), get_base1(a1, i, "a1", 1), get_base1(b1, i, "b1", 1)));
                        current_statement_begin__ = 493;
                        if (as_bool(logical_eq(inflation, 0))) {
                            current_statement_begin__ = 494;
                            lp_accum__.add(stan::math::log((1 - get_base1(p0, i, "p0", 1))));
                        } else if (as_bool(logical_eq(inflation, 1))) {
                            current_statement_begin__ = 496;
                            lp_accum__.add(stan::math::log((1 - get_base1(p1, i, "p1", 1))));
                        } else if (as_bool(logical_eq(inflation, 2))) {
                            current_statement_begin__ = 498;
                            lp_accum__.add(stan::math::log(((1 - get_base1(p0, i, "p0", 1)) - get_base1(p1, i, "p1", 1))));
                        }
                    }
                }
            } else if (as_bool(logical_eq(likelihood, 3))) {
                current_statement_begin__ = 503;
                for (int i = 1; i <= M_is; ++i) {
                    current_statement_begin__ = 504;
                    if (as_bool(logical_eq(get_base1(y, i, "y", 1), 0))) {
                        current_statement_begin__ = 505;
                        lp_accum__.add((get_base1(m_d, i, "m_d", 1) * stan::math::log((1 - get_base1(mu, i, "mu", 1)))));
                    } else {
                        current_statement_begin__ = 507;
                        lp_accum__.add((stan::math::log((1 - pow((1 - get_base1(mu, i, "mu", 1)), get_base1(m_d, i, "m_d", 1)))) + beta_log(get_base1(y, i, "y", 1), get_base1(a1, i, "a1", 1), get_base1(b1, i, "b1", 1))));
                    }
                }
            }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("beta0");
        names__.push_back("z_beta");
        names__.push_back("lambda_HS");
        names__.push_back("z_c2");
        names__.push_back("z_tau");
        names__.push_back("v_raw");
        names__.push_back("sigma_v");
        names__.push_back("nu");
        names__.push_back("psi_d");
        names__.push_back("lambda");
        names__.push_back("s_raw");
        names__.push_back("sigma_s");
        names__.push_back("t_raw");
        names__.push_back("sigma_t");
        names__.push_back("w");
        names__.push_back("p");
        names__.push_back("gamma_p0");
        names__.push_back("gamma_p1");
        names__.push_back("gamma0_p0");
        names__.push_back("gamma0_p1");
        names__.push_back("beta");
        names__.push_back("tau");
        names__.push_back("c2");
        names__.push_back("lambda_tilde");
        names__.push_back("theta");
        names__.push_back("b1");
        names__.push_back("a1");
        names__.push_back("mu");
        names__.push_back("phi");
        names__.push_back("lambda1");
        names__.push_back("lambda2");
        names__.push_back("b2");
        names__.push_back("a2");
        names__.push_back("p0");
        names__.push_back("p1");
        names__.push_back("v");
        names__.push_back("s");
        names__.push_back("t");
        names__.push_back("reffs");
        names__.push_back("reffs_oos");
        names__.push_back("log_lik");
        names__.push_back("y_rep");
        names__.push_back("psi_OOS");
        names__.push_back("v_oos");
        names__.push_back("label_mixt");
        names__.push_back("probs");
        names__.push_back("theta_oos");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back((logical_eq(intercept, 1) ? 1 : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(P);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_eq(prior_coeff, 1) ? P : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_eq(prior_coeff, 1) ? 1 : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_eq(prior_coeff, 1) ? 1 : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(length_v);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(((primitive_value((primitive_value(logical_eq(prior_reff, 0)) || primitive_value(logical_eq(prior_reff, 1)))) && primitive_value(logical_eq(spatio_temporal, 0))) ? 1 : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(((primitive_value(logical_eq(prior_reff, 1)) && primitive_value(logical_eq(spatio_temporal, 0))) ? 1 : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(((primitive_value(logical_eq(prior_reff, 2)) && primitive_value(logical_eq(spatio_temporal, 0))) ? length_v : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(((primitive_value(logical_eq(prior_reff, 2)) && primitive_value(logical_eq(spatio_temporal, 0))) ? 1 : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_eq(spatial_err, 1) ? D : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_eq(spatial_err, 1) ? 1 : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_eq(temporal_err, 1) ? D : 0 ));
        dims__.push_back((logical_eq(temporal_err, 1) ? TP : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_eq(temporal_err, 1) ? 1 : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_eq(likelihood, 1) ? 1 : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_eq(likelihood, 1) ? 1 : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 1))) ? P : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 0))) ? P : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(((primitive_value((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 1)))) && primitive_value(logical_eq(intercept, 1))) ? 1 : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(((primitive_value((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 0)))) && primitive_value(logical_eq(intercept, 1))) ? 1 : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(P);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_eq(prior_coeff, 1) ? 1 : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_eq(prior_coeff, 1) ? 1 : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_eq(prior_coeff, 1) ? P : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(M_is);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(M_is);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(M_is);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(M_is);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_eq(likelihood, 1) ? M_is : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_eq(likelihood, 1) ? M_is : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_eq(likelihood, 1) ? M_is : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_eq(likelihood, 1) ? M_is : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_eq(likelihood, 1) ? M_is : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 1))) ? M_is : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 0))) ? M_is : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(length_v);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_eq(spatial_err, 1) ? D : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_eq(temporal_err, 1) ? D : 0 ));
        dims__.push_back((logical_eq(temporal_err, 1) ? TP : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(M_is);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(M_oos);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(M_is);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(M_is);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(1);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(1);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_eq(inflation, 2) ? 3 : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_neq(likelihood, 1) ? M_oos : 0 ));
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_global_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta0 = in__.vector_constrain((logical_eq(intercept, 1) ? 1 : 0 ));
        size_t beta0_j_1_max__ = (logical_eq(intercept, 1) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < beta0_j_1_max__; ++j_1__) {
            vars__.push_back(beta0(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> z_beta = in__.vector_constrain(P);
        size_t z_beta_j_1_max__ = P;
        for (size_t j_1__ = 0; j_1__ < z_beta_j_1_max__; ++j_1__) {
            vars__.push_back(z_beta(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> lambda_HS = in__.vector_lb_constrain(0, (logical_eq(prior_coeff, 1) ? P : 0 ));
        size_t lambda_HS_j_1_max__ = (logical_eq(prior_coeff, 1) ? P : 0 );
        for (size_t j_1__ = 0; j_1__ < lambda_HS_j_1_max__; ++j_1__) {
            vars__.push_back(lambda_HS(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> z_c2 = in__.vector_lb_constrain(0, (logical_eq(prior_coeff, 1) ? 1 : 0 ));
        size_t z_c2_j_1_max__ = (logical_eq(prior_coeff, 1) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < z_c2_j_1_max__; ++j_1__) {
            vars__.push_back(z_c2(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> z_tau = in__.vector_lb_constrain(0, (logical_eq(prior_coeff, 1) ? 1 : 0 ));
        size_t z_tau_j_1_max__ = (logical_eq(prior_coeff, 1) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < z_tau_j_1_max__; ++j_1__) {
            vars__.push_back(z_tau(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> v_raw = in__.vector_constrain(length_v);
        size_t v_raw_j_1_max__ = length_v;
        for (size_t j_1__ = 0; j_1__ < v_raw_j_1_max__; ++j_1__) {
            vars__.push_back(v_raw(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> sigma_v = in__.vector_lb_constrain(0, ((primitive_value((primitive_value(logical_eq(prior_reff, 0)) || primitive_value(logical_eq(prior_reff, 1)))) && primitive_value(logical_eq(spatio_temporal, 0))) ? 1 : 0 ));
        size_t sigma_v_j_1_max__ = ((primitive_value((primitive_value(logical_eq(prior_reff, 0)) || primitive_value(logical_eq(prior_reff, 1)))) && primitive_value(logical_eq(spatio_temporal, 0))) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < sigma_v_j_1_max__; ++j_1__) {
            vars__.push_back(sigma_v(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> nu = in__.vector_lb_constrain(0, ((primitive_value(logical_eq(prior_reff, 1)) && primitive_value(logical_eq(spatio_temporal, 0))) ? 1 : 0 ));
        size_t nu_j_1_max__ = ((primitive_value(logical_eq(prior_reff, 1)) && primitive_value(logical_eq(spatio_temporal, 0))) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < nu_j_1_max__; ++j_1__) {
            vars__.push_back(nu(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> psi_d = in__.vector_lb_constrain(0, ((primitive_value(logical_eq(prior_reff, 2)) && primitive_value(logical_eq(spatio_temporal, 0))) ? length_v : 0 ));
        size_t psi_d_j_1_max__ = ((primitive_value(logical_eq(prior_reff, 2)) && primitive_value(logical_eq(spatio_temporal, 0))) ? length_v : 0 );
        for (size_t j_1__ = 0; j_1__ < psi_d_j_1_max__; ++j_1__) {
            vars__.push_back(psi_d(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> lambda = in__.vector_lb_constrain(0, ((primitive_value(logical_eq(prior_reff, 2)) && primitive_value(logical_eq(spatio_temporal, 0))) ? 1 : 0 ));
        size_t lambda_j_1_max__ = ((primitive_value(logical_eq(prior_reff, 2)) && primitive_value(logical_eq(spatio_temporal, 0))) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < lambda_j_1_max__; ++j_1__) {
            vars__.push_back(lambda(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> s_raw = in__.vector_constrain((logical_eq(spatial_err, 1) ? D : 0 ));
        size_t s_raw_j_1_max__ = (logical_eq(spatial_err, 1) ? D : 0 );
        for (size_t j_1__ = 0; j_1__ < s_raw_j_1_max__; ++j_1__) {
            vars__.push_back(s_raw(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> sigma_s = in__.vector_lb_constrain(0, (logical_eq(spatial_err, 1) ? 1 : 0 ));
        size_t sigma_s_j_1_max__ = (logical_eq(spatial_err, 1) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < sigma_s_j_1_max__; ++j_1__) {
            vars__.push_back(sigma_s(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> t_raw = in__.matrix_constrain((logical_eq(temporal_err, 1) ? D : 0 ), (logical_eq(temporal_err, 1) ? TP : 0 ));
        size_t t_raw_j_2_max__ = (logical_eq(temporal_err, 1) ? TP : 0 );
        size_t t_raw_j_1_max__ = (logical_eq(temporal_err, 1) ? D : 0 );
        for (size_t j_2__ = 0; j_2__ < t_raw_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < t_raw_j_1_max__; ++j_1__) {
                vars__.push_back(t_raw(j_1__, j_2__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> sigma_t = in__.vector_lb_constrain(0, (logical_eq(temporal_err, 1) ? 1 : 0 ));
        size_t sigma_t_j_1_max__ = (logical_eq(temporal_err, 1) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < sigma_t_j_1_max__; ++j_1__) {
            vars__.push_back(sigma_t(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> w = in__.vector_lub_constrain(0.001, 0.999, (logical_eq(likelihood, 1) ? 1 : 0 ));
        size_t w_j_1_max__ = (logical_eq(likelihood, 1) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < w_j_1_max__; ++j_1__) {
            vars__.push_back(w(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> p = in__.vector_lub_constrain(0.001, 0.999, (logical_eq(likelihood, 1) ? 1 : 0 ));
        size_t p_j_1_max__ = (logical_eq(likelihood, 1) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < p_j_1_max__; ++j_1__) {
            vars__.push_back(p(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> gamma_p0 = in__.vector_constrain(((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 1))) ? P : 0 ));
        size_t gamma_p0_j_1_max__ = ((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 1))) ? P : 0 );
        for (size_t j_1__ = 0; j_1__ < gamma_p0_j_1_max__; ++j_1__) {
            vars__.push_back(gamma_p0(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> gamma_p1 = in__.vector_constrain(((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 0))) ? P : 0 ));
        size_t gamma_p1_j_1_max__ = ((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 0))) ? P : 0 );
        for (size_t j_1__ = 0; j_1__ < gamma_p1_j_1_max__; ++j_1__) {
            vars__.push_back(gamma_p1(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> gamma0_p0 = in__.vector_constrain(((primitive_value((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 1)))) && primitive_value(logical_eq(intercept, 1))) ? 1 : 0 ));
        size_t gamma0_p0_j_1_max__ = ((primitive_value((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 1)))) && primitive_value(logical_eq(intercept, 1))) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < gamma0_p0_j_1_max__; ++j_1__) {
            vars__.push_back(gamma0_p0(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> gamma0_p1 = in__.vector_constrain(((primitive_value((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 0)))) && primitive_value(logical_eq(intercept, 1))) ? 1 : 0 ));
        size_t gamma0_p1_j_1_max__ = ((primitive_value((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 0)))) && primitive_value(logical_eq(intercept, 1))) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < gamma0_p1_j_1_max__; ++j_1__) {
            vars__.push_back(gamma0_p1(j_1__));
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 121;
            validate_non_negative_index("beta", "P", P);
            Eigen::Matrix<double, Eigen::Dynamic, 1> beta(P);
            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta, DUMMY_VAR__);
            current_statement_begin__ = 123;
            validate_non_negative_index("tau", "(logical_eq(prior_coeff, 1) ? 1 : 0 )", (logical_eq(prior_coeff, 1) ? 1 : 0 ));
            Eigen::Matrix<double, Eigen::Dynamic, 1> tau((logical_eq(prior_coeff, 1) ? 1 : 0 ));
            stan::math::initialize(tau, DUMMY_VAR__);
            stan::math::fill(tau, DUMMY_VAR__);
            current_statement_begin__ = 124;
            validate_non_negative_index("c2", "(logical_eq(prior_coeff, 1) ? 1 : 0 )", (logical_eq(prior_coeff, 1) ? 1 : 0 ));
            Eigen::Matrix<double, Eigen::Dynamic, 1> c2((logical_eq(prior_coeff, 1) ? 1 : 0 ));
            stan::math::initialize(c2, DUMMY_VAR__);
            stan::math::fill(c2, DUMMY_VAR__);
            current_statement_begin__ = 125;
            validate_non_negative_index("lambda_tilde", "(logical_eq(prior_coeff, 1) ? P : 0 )", (logical_eq(prior_coeff, 1) ? P : 0 ));
            Eigen::Matrix<double, Eigen::Dynamic, 1> lambda_tilde((logical_eq(prior_coeff, 1) ? P : 0 ));
            stan::math::initialize(lambda_tilde, DUMMY_VAR__);
            stan::math::fill(lambda_tilde, DUMMY_VAR__);
            current_statement_begin__ = 128;
            validate_non_negative_index("theta", "M_is", M_is);
            Eigen::Matrix<double, Eigen::Dynamic, 1> theta(M_is);
            stan::math::initialize(theta, DUMMY_VAR__);
            stan::math::fill(theta, DUMMY_VAR__);
            current_statement_begin__ = 132;
            validate_non_negative_index("b1", "M_is", M_is);
            Eigen::Matrix<double, Eigen::Dynamic, 1> b1(M_is);
            stan::math::initialize(b1, DUMMY_VAR__);
            stan::math::fill(b1, DUMMY_VAR__);
            current_statement_begin__ = 133;
            validate_non_negative_index("a1", "M_is", M_is);
            Eigen::Matrix<double, Eigen::Dynamic, 1> a1(M_is);
            stan::math::initialize(a1, DUMMY_VAR__);
            stan::math::fill(a1, DUMMY_VAR__);
            current_statement_begin__ = 134;
            validate_non_negative_index("mu", "M_is", M_is);
            Eigen::Matrix<double, Eigen::Dynamic, 1> mu(M_is);
            stan::math::initialize(mu, DUMMY_VAR__);
            stan::math::fill(mu, DUMMY_VAR__);
            current_statement_begin__ = 137;
            validate_non_negative_index("phi", "(logical_eq(likelihood, 1) ? M_is : 0 )", (logical_eq(likelihood, 1) ? M_is : 0 ));
            Eigen::Matrix<double, Eigen::Dynamic, 1> phi((logical_eq(likelihood, 1) ? M_is : 0 ));
            stan::math::initialize(phi, DUMMY_VAR__);
            stan::math::fill(phi, DUMMY_VAR__);
            current_statement_begin__ = 138;
            validate_non_negative_index("lambda1", "(logical_eq(likelihood, 1) ? M_is : 0 )", (logical_eq(likelihood, 1) ? M_is : 0 ));
            Eigen::Matrix<double, Eigen::Dynamic, 1> lambda1((logical_eq(likelihood, 1) ? M_is : 0 ));
            stan::math::initialize(lambda1, DUMMY_VAR__);
            stan::math::fill(lambda1, DUMMY_VAR__);
            current_statement_begin__ = 139;
            validate_non_negative_index("lambda2", "(logical_eq(likelihood, 1) ? M_is : 0 )", (logical_eq(likelihood, 1) ? M_is : 0 ));
            Eigen::Matrix<double, Eigen::Dynamic, 1> lambda2((logical_eq(likelihood, 1) ? M_is : 0 ));
            stan::math::initialize(lambda2, DUMMY_VAR__);
            stan::math::fill(lambda2, DUMMY_VAR__);
            current_statement_begin__ = 140;
            validate_non_negative_index("b2", "(logical_eq(likelihood, 1) ? M_is : 0 )", (logical_eq(likelihood, 1) ? M_is : 0 ));
            Eigen::Matrix<double, Eigen::Dynamic, 1> b2((logical_eq(likelihood, 1) ? M_is : 0 ));
            stan::math::initialize(b2, DUMMY_VAR__);
            stan::math::fill(b2, DUMMY_VAR__);
            current_statement_begin__ = 141;
            validate_non_negative_index("a2", "(logical_eq(likelihood, 1) ? M_is : 0 )", (logical_eq(likelihood, 1) ? M_is : 0 ));
            Eigen::Matrix<double, Eigen::Dynamic, 1> a2((logical_eq(likelihood, 1) ? M_is : 0 ));
            stan::math::initialize(a2, DUMMY_VAR__);
            stan::math::fill(a2, DUMMY_VAR__);
            current_statement_begin__ = 144;
            validate_non_negative_index("p0", "((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 1))) ? M_is : 0 )", ((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 1))) ? M_is : 0 ));
            Eigen::Matrix<double, Eigen::Dynamic, 1> p0(((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 1))) ? M_is : 0 ));
            stan::math::initialize(p0, DUMMY_VAR__);
            stan::math::fill(p0, DUMMY_VAR__);
            current_statement_begin__ = 145;
            validate_non_negative_index("p1", "((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 0))) ? M_is : 0 )", ((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 0))) ? M_is : 0 ));
            Eigen::Matrix<double, Eigen::Dynamic, 1> p1(((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 0))) ? M_is : 0 ));
            stan::math::initialize(p1, DUMMY_VAR__);
            stan::math::fill(p1, DUMMY_VAR__);
            current_statement_begin__ = 148;
            validate_non_negative_index("v", "length_v", length_v);
            Eigen::Matrix<double, Eigen::Dynamic, 1> v(length_v);
            stan::math::initialize(v, DUMMY_VAR__);
            stan::math::fill(v, DUMMY_VAR__);
            current_statement_begin__ = 149;
            validate_non_negative_index("s", "(logical_eq(spatial_err, 1) ? D : 0 )", (logical_eq(spatial_err, 1) ? D : 0 ));
            Eigen::Matrix<double, Eigen::Dynamic, 1> s((logical_eq(spatial_err, 1) ? D : 0 ));
            stan::math::initialize(s, DUMMY_VAR__);
            stan::math::fill(s, DUMMY_VAR__);
            current_statement_begin__ = 150;
            validate_non_negative_index("t", "(logical_eq(temporal_err, 1) ? D : 0 )", (logical_eq(temporal_err, 1) ? D : 0 ));
            validate_non_negative_index("t", "(logical_eq(temporal_err, 1) ? TP : 0 )", (logical_eq(temporal_err, 1) ? TP : 0 ));
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> t((logical_eq(temporal_err, 1) ? D : 0 ), (logical_eq(temporal_err, 1) ? TP : 0 ));
            stan::math::initialize(t, DUMMY_VAR__);
            stan::math::fill(t, DUMMY_VAR__);
            current_statement_begin__ = 152;
            validate_non_negative_index("reffs", "M_is", M_is);
            Eigen::Matrix<double, Eigen::Dynamic, 1> reffs(M_is);
            stan::math::initialize(reffs, DUMMY_VAR__);
            stan::math::fill(reffs, DUMMY_VAR__);
            current_statement_begin__ = 154;
            validate_non_negative_index("reffs_oos", "M_oos", M_oos);
            Eigen::Matrix<double, Eigen::Dynamic, 1> reffs_oos(M_oos);
            stan::math::initialize(reffs_oos, DUMMY_VAR__);
            stan::math::fill(reffs_oos, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 159;
            if (as_bool(logical_eq(prior_coeff, 0))) {
                current_statement_begin__ = 160;
                stan::math::assign(beta, z_beta);
            } else if (as_bool(logical_eq(prior_coeff, 1))) {
                current_statement_begin__ = 162;
                stan::model::assign(tau, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            (tau0 * get_base1(z_tau, 1, "z_tau", 1)), 
                            "assigning variable tau");
                current_statement_begin__ = 163;
                stan::model::assign(c2, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            (slab_scale2 * get_base1(z_c2, 1, "z_c2", 1)), 
                            "assigning variable c2");
                current_statement_begin__ = 164;
                stan::math::assign(lambda_tilde, stan::math::sqrt(elt_divide(multiply(get_base1(c2, 1, "c2", 1), square(lambda_HS)), add(get_base1(c2, 1, "c2", 1), multiply(square(get_base1(tau, 1, "tau", 1)), square(lambda_HS))))));
                current_statement_begin__ = 165;
                stan::math::assign(beta, elt_multiply(multiply(get_base1(tau, 1, "tau", 1), lambda_tilde), z_beta));
            }
            current_statement_begin__ = 169;
            if (as_bool(logical_eq(spatio_temporal, 0))) {
                current_statement_begin__ = 170;
                if (as_bool(logical_eq(prior_reff, 0))) {
                    current_statement_begin__ = 171;
                    stan::math::assign(v, multiply(get_base1(sigma_v, 1, "sigma_v", 1), v_raw));
                } else if (as_bool(logical_eq(prior_reff, 1))) {
                    current_statement_begin__ = 173;
                    stan::math::assign(v, multiply(get_base1(sigma_v, 1, "sigma_v", 1), v_raw));
                } else if (as_bool(logical_eq(prior_reff, 2))) {
                    current_statement_begin__ = 175;
                    stan::math::assign(v, elt_multiply(multiply(stan::math::sqrt(psi_d), get_base1(lambda, 1, "lambda", 1)), v_raw));
                }
            }
            current_statement_begin__ = 180;
            if (as_bool((primitive_value(logical_eq(spatial_err, 0)) && primitive_value(logical_eq(temporal_err, 0))))) {
                current_statement_begin__ = 181;
                stan::math::assign(reffs, v);
                current_statement_begin__ = 182;
                for (int i = 1; i <= M_oos; ++i) {
                    current_statement_begin__ = 183;
                    stan::model::assign(reffs_oos, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                0, 
                                "assigning variable reffs_oos");
                }
            } else {
                current_statement_begin__ = 186;
                if (as_bool((primitive_value(logical_eq(spatial_err, 1)) && primitive_value(logical_eq(temporal_err, 0))))) {
                    current_statement_begin__ = 187;
                    for (int i = 1; i <= D; ++i) {
                        current_statement_begin__ = 188;
                        stan::model::assign(s, 
                                    stan::model::cons_list(stan::model::index_uni(get_base1(indices_spat, i, "indices_spat", 1)), stan::model::nil_index_list()), 
                                    ((get_base1(sigma_s, 1, "sigma_s", 1) * get_base1(s_raw, i, "s_raw", 1)) / get_base1(scales_ICAR, i, "scales_ICAR", 1)), 
                                    "assigning variable s");
                    }
                    current_statement_begin__ = 190;
                    for (int i = 1; i <= M_is; ++i) {
                        current_statement_begin__ = 191;
                        stan::model::assign(reffs, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (get_base1(v, i, "v", 1) + get_base1(s, get_base1(indices_is, i, "indices_is", 1), "s", 1)), 
                                    "assigning variable reffs");
                    }
                    current_statement_begin__ = 193;
                    for (int i = 1; i <= M_oos; ++i) {
                        current_statement_begin__ = 194;
                        stan::model::assign(reffs_oos, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    get_base1(s, get_base1(indices_oos, i, "indices_oos", 1), "s", 1), 
                                    "assigning variable reffs_oos");
                    }
                }
                current_statement_begin__ = 197;
                if (as_bool((primitive_value(logical_eq(spatial_err, 0)) && primitive_value(logical_eq(temporal_err, 1))))) {
                    current_statement_begin__ = 198;
                    stan::math::assign(t, divide(multiply(get_base1(sigma_t, 1, "sigma_t", 1), t_raw), scale_factor_RW1));
                    current_statement_begin__ = 199;
                    for (int i = 1; i <= M_is; ++i) {
                        current_statement_begin__ = 200;
                        stan::model::assign(reffs, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (get_base1(v, get_base1(get_base1(indices_temp, get_base1(indices_is, i, "indices_is", 1), "indices_temp", 1), 1, "indices_temp", 2), "v", 1) + get_base1(t, get_base1(get_base1(indices_temp, get_base1(indices_is, i, "indices_is", 1), "indices_temp", 1), 1, "indices_temp", 2), get_base1(get_base1(indices_temp, get_base1(indices_is, i, "indices_is", 1), "indices_temp", 1), 2, "indices_temp", 2), "t", 1)), 
                                    "assigning variable reffs");
                    }
                    current_statement_begin__ = 203;
                    for (int i = 1; i <= M_oos; ++i) {
                        current_statement_begin__ = 204;
                        if (as_bool(logical_eq(get_base1(cat_ios, i, "cat_ios", 1), 1))) {
                            current_statement_begin__ = 205;
                            stan::model::assign(reffs_oos, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        0, 
                                        "assigning variable reffs_oos");
                        }
                        current_statement_begin__ = 207;
                        if (as_bool(logical_eq(get_base1(cat_ios, i, "cat_ios", 1), 2))) {
                            current_statement_begin__ = 208;
                            stan::model::assign(reffs_oos, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        get_base1(v, get_base1(get_base1(indices_temp, get_base1(indices_oos, i, "indices_oos", 1), "indices_temp", 1), 1, "indices_temp", 2), "v", 1), 
                                        "assigning variable reffs_oos");
                        }
                        current_statement_begin__ = 210;
                        if (as_bool(logical_eq(get_base1(cat_ios, i, "cat_ios", 1), 3))) {
                            current_statement_begin__ = 211;
                            stan::model::assign(reffs_oos, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        (get_base1(v, get_base1(get_base1(indices_temp, get_base1(indices_oos, i, "indices_oos", 1), "indices_temp", 1), 1, "indices_temp", 2), "v", 1) + get_base1(t, get_base1(get_base1(indices_temp, get_base1(indices_oos, i, "indices_oos", 1), "indices_temp", 1), 1, "indices_temp", 2), get_base1(get_base1(indices_temp, get_base1(indices_oos, i, "indices_oos", 1), "indices_temp", 1), 2, "indices_temp", 2), "t", 1)), 
                                        "assigning variable reffs_oos");
                        }
                    }
                }
                current_statement_begin__ = 216;
                if (as_bool((primitive_value(logical_eq(spatial_err, 1)) && primitive_value(logical_eq(temporal_err, 1))))) {
                    current_statement_begin__ = 217;
                    stan::math::assign(t, divide(multiply(get_base1(sigma_t, 1, "sigma_t", 1), t_raw), scale_factor_RW1));
                    current_statement_begin__ = 218;
                    for (int i = 1; i <= D; ++i) {
                        current_statement_begin__ = 219;
                        stan::model::assign(s, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    ((get_base1(sigma_s, 1, "sigma_s", 1) * get_base1(s_raw, get_base1(indices_spat, i, "indices_spat", 1), "s_raw", 1)) / get_base1(scales_ICAR, get_base1(indices_spat, i, "indices_spat", 1), "scales_ICAR", 1)), 
                                    "assigning variable s");
                    }
                    current_statement_begin__ = 221;
                    for (int i = 1; i <= M_is; ++i) {
                        current_statement_begin__ = 222;
                        stan::model::assign(reffs, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (get_base1(s, get_base1(get_base1(indices_temp, get_base1(indices_is, i, "indices_is", 1), "indices_temp", 1), 1, "indices_temp", 2), "s", 1) + get_base1(t, get_base1(get_base1(indices_temp, get_base1(indices_is, i, "indices_is", 1), "indices_temp", 1), 1, "indices_temp", 2), get_base1(get_base1(indices_temp, get_base1(indices_is, i, "indices_is", 1), "indices_temp", 1), 2, "indices_temp", 2), "t", 1)), 
                                    "assigning variable reffs");
                    }
                    current_statement_begin__ = 225;
                    for (int i = 1; i <= M_oos; ++i) {
                        current_statement_begin__ = 226;
                        if (as_bool(logical_eq(get_base1(cat_ios, i, "cat_ios", 1), 1))) {
                            current_statement_begin__ = 227;
                            stan::model::assign(reffs_oos, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        (get_base1(s, get_base1(get_base1(indices_temp, get_base1(indices_oos, i, "indices_oos", 1), "indices_temp", 1), 1, "indices_temp", 2), "s", 1) + get_base1(t, get_base1(get_base1(indices_temp, get_base1(indices_oos, i, "indices_oos", 1), "indices_temp", 1), 1, "indices_temp", 2), get_base1(get_base1(indices_temp, get_base1(indices_oos, i, "indices_oos", 1), "indices_temp", 1), 2, "indices_temp", 2), "t", 1)), 
                                        "assigning variable reffs_oos");
                        }
                        current_statement_begin__ = 230;
                        if (as_bool(logical_eq(get_base1(cat_ios, i, "cat_ios", 1), 2))) {
                            current_statement_begin__ = 231;
                            stan::model::assign(reffs_oos, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        (get_base1(s, get_base1(get_base1(indices_temp, get_base1(indices_oos, i, "indices_oos", 1), "indices_temp", 1), 1, "indices_temp", 2), "s", 1) + get_base1(t, get_base1(get_base1(indices_temp, get_base1(indices_oos, i, "indices_oos", 1), "indices_temp", 1), 1, "indices_temp", 2), get_base1(get_base1(indices_temp, get_base1(indices_oos, i, "indices_oos", 1), "indices_temp", 1), 2, "indices_temp", 2), "t", 1)), 
                                        "assigning variable reffs_oos");
                        }
                        current_statement_begin__ = 234;
                        if (as_bool(logical_eq(get_base1(cat_ios, i, "cat_ios", 1), 3))) {
                            current_statement_begin__ = 235;
                            stan::model::assign(reffs_oos, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        (get_base1(s, get_base1(get_base1(indices_temp, get_base1(indices_oos, i, "indices_oos", 1), "indices_temp", 1), 1, "indices_temp", 2), "s", 1) + get_base1(t, get_base1(get_base1(indices_temp, get_base1(indices_oos, i, "indices_oos", 1), "indices_temp", 1), 1, "indices_temp", 2), get_base1(get_base1(indices_temp, get_base1(indices_oos, i, "indices_oos", 1), "indices_temp", 1), 2, "indices_temp", 2), "t", 1)), 
                                        "assigning variable reffs_oos");
                        }
                    }
                }
            }
            current_statement_begin__ = 245;
            if (as_bool(logical_eq(likelihood, 0))) {
                current_statement_begin__ = 256;
                for (int i = 1; i <= M_is; ++i) {
                    current_statement_begin__ = 257;
                    if (as_bool(logical_eq(intercept, 0))) {
                        current_statement_begin__ = 258;
                        stan::model::assign(mu, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    inv_logit((multiply(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X"), beta) + get_base1(reffs, i, "reffs", 1))), 
                                    "assigning variable mu");
                    } else {
                        current_statement_begin__ = 260;
                        stan::model::assign(mu, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    inv_logit(((get_base1(beta0, 1, "beta0", 1) + multiply(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X"), beta)) + get_base1(reffs, i, "reffs", 1))), 
                                    "assigning variable mu");
                    }
                    current_statement_begin__ = 262;
                    stan::model::assign(theta, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                get_base1(mu, i, "mu", 1), 
                                "assigning variable theta");
                    current_statement_begin__ = 264;
                    if (as_bool(logical_eq(deff, 0))) {
                        current_statement_begin__ = 265;
                        stan::model::assign(b1, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    ((1 - get_base1(mu, i, "mu", 1)) * (((get_base1(mu, i, "mu", 1) * (1 - get_base1(mu, i, "mu", 1))) / get_base1(disp, i, "disp", 1)) - 1)), 
                                    "assigning variable b1");
                        current_statement_begin__ = 266;
                        stan::model::assign(a1, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (get_base1(mu, i, "mu", 1) * (((get_base1(mu, i, "mu", 1) * (1 - get_base1(mu, i, "mu", 1))) / get_base1(disp, i, "disp", 1)) - 1)), 
                                    "assigning variable a1");
                    } else {
                        current_statement_begin__ = 268;
                        stan::model::assign(b1, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    ((1 - get_base1(mu, i, "mu", 1)) * get_base1(disp, i, "disp", 1)), 
                                    "assigning variable b1");
                        current_statement_begin__ = 269;
                        stan::model::assign(a1, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (get_base1(mu, i, "mu", 1) * get_base1(disp, i, "disp", 1)), 
                                    "assigning variable a1");
                    }
                }
            } else if (as_bool(logical_eq(likelihood, 1))) {
                current_statement_begin__ = 277;
                for (int i = 1; i <= M_is; ++i) {
                    current_statement_begin__ = 278;
                    if (as_bool(logical_eq(intercept, 0))) {
                        current_statement_begin__ = 279;
                        stan::model::assign(lambda2, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    inv_logit((multiply(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X"), beta) + get_base1(reffs, i, "reffs", 1))), 
                                    "assigning variable lambda2");
                    } else {
                        current_statement_begin__ = 281;
                        stan::model::assign(lambda2, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    inv_logit(((get_base1(beta0, 1, "beta0", 1) + multiply(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X"), beta)) + get_base1(reffs, i, "reffs", 1))), 
                                    "assigning variable lambda2");
                    }
                    current_statement_begin__ = 283;
                    stan::model::assign(lambda1, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (get_base1(lambda2, i, "lambda2", 1) + (get_base1(w, 1, "w", 1) * stan::math::fmin(((1 - get_base1(lambda2, i, "lambda2", 1)) / get_base1(p, 1, "p", 1)), stan::math::sqrt((get_base1(disp, i, "disp", 1) / (get_base1(p, 1, "p", 1) * (1 - get_base1(p, 1, "p", 1)))))))), 
                                "assigning variable lambda1");
                    current_statement_begin__ = 284;
                    stan::model::assign(mu, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                ((get_base1(p, 1, "p", 1) * get_base1(lambda1, i, "lambda1", 1)) + ((1 - get_base1(p, 1, "p", 1)) * get_base1(lambda2, i, "lambda2", 1))), 
                                "assigning variable mu");
                    current_statement_begin__ = 285;
                    stan::model::assign(theta, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                get_base1(mu, i, "mu", 1), 
                                "assigning variable theta");
                    current_statement_begin__ = 286;
                    stan::model::assign(phi, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (((get_base1(mu, i, "mu", 1) * (1 - get_base1(mu, i, "mu", 1))) - get_base1(disp, i, "disp", 1)) / (get_base1(disp, i, "disp", 1) - (((get_base1(p, 1, "p", 1) * (1 - get_base1(p, 1, "p", 1))) * pow(get_base1(w, 1, "w", 1), 2)) * pow(stan::math::fmin(((1 - get_base1(lambda2, i, "lambda2", 1)) / get_base1(p, 1, "p", 1)), stan::math::sqrt((get_base1(disp, i, "disp", 1) / (get_base1(p, 1, "p", 1) * (1 - get_base1(p, 1, "p", 1)))))), 2)))), 
                                "assigning variable phi");
                    current_statement_begin__ = 289;
                    stan::model::assign(b1, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                ((1 - get_base1(lambda2, i, "lambda2", 1)) * get_base1(phi, i, "phi", 1)), 
                                "assigning variable b1");
                    current_statement_begin__ = 290;
                    stan::model::assign(a1, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (get_base1(lambda2, i, "lambda2", 1) * get_base1(phi, i, "phi", 1)), 
                                "assigning variable a1");
                    current_statement_begin__ = 291;
                    stan::model::assign(b2, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                ((1 - get_base1(lambda1, i, "lambda1", 1)) * get_base1(phi, i, "phi", 1)), 
                                "assigning variable b2");
                    current_statement_begin__ = 292;
                    stan::model::assign(a2, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (get_base1(lambda1, i, "lambda1", 1) * get_base1(phi, i, "phi", 1)), 
                                "assigning variable a2");
                }
            } else if (as_bool(logical_eq(likelihood, 2))) {
                current_statement_begin__ = 331;
                for (int i = 1; i <= M_is; ++i) {
                    current_statement_begin__ = 332;
                    if (as_bool(logical_eq(intercept, 0))) {
                        current_statement_begin__ = 333;
                        stan::model::assign(mu, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    inv_logit((multiply(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X"), beta) + get_base1(reffs, i, "reffs", 1))), 
                                    "assigning variable mu");
                    } else {
                        current_statement_begin__ = 335;
                        stan::model::assign(mu, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    inv_logit(((get_base1(beta0, 1, "beta0", 1) + multiply(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X"), beta)) + get_base1(reffs, i, "reffs", 1))), 
                                    "assigning variable mu");
                    }
                    current_statement_begin__ = 337;
                    if (as_bool(logical_neq(inflation, 1))) {
                        current_statement_begin__ = 338;
                        if (as_bool(logical_eq(intercept, 0))) {
                            current_statement_begin__ = 339;
                            stan::model::assign(p0, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        inv_logit(multiply(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X"), gamma_p0)), 
                                        "assigning variable p0");
                        } else {
                            current_statement_begin__ = 341;
                            stan::model::assign(p0, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        inv_logit((get_base1(gamma0_p0, 1, "gamma0_p0", 1) + multiply(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X"), gamma_p0))), 
                                        "assigning variable p0");
                        }
                    }
                    current_statement_begin__ = 344;
                    if (as_bool(logical_neq(inflation, 0))) {
                        current_statement_begin__ = 345;
                        if (as_bool(logical_eq(intercept, 0))) {
                            current_statement_begin__ = 346;
                            stan::model::assign(p1, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        inv_logit(multiply(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X"), gamma_p1)), 
                                        "assigning variable p1");
                        } else {
                            current_statement_begin__ = 348;
                            stan::model::assign(p1, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        inv_logit((get_base1(gamma0_p1, 1, "gamma0_p1", 1) + multiply(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X"), gamma_p1))), 
                                        "assigning variable p1");
                        }
                    }
                    current_statement_begin__ = 351;
                    if (as_bool(logical_eq(inflation, 0))) {
                        current_statement_begin__ = 352;
                        stan::model::assign(theta, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    ((1 - get_base1(p0, i, "p0", 1)) * get_base1(mu, i, "mu", 1)), 
                                    "assigning variable theta");
                    } else if (as_bool(logical_eq(inflation, 1))) {
                        current_statement_begin__ = 354;
                        stan::model::assign(theta, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (((1 - get_base1(p1, i, "p1", 1)) * get_base1(mu, i, "mu", 1)) + get_base1(p1, i, "p1", 1)), 
                                    "assigning variable theta");
                    } else if (as_bool(logical_eq(inflation, 2))) {
                        current_statement_begin__ = 356;
                        stan::model::assign(theta, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    ((((1 - get_base1(p0, i, "p0", 1)) - get_base1(p1, i, "p1", 1)) * get_base1(mu, i, "mu", 1)) + get_base1(p1, i, "p1", 1)), 
                                    "assigning variable theta");
                    }
                    current_statement_begin__ = 358;
                    if (as_bool(logical_eq(deff, 0))) {
                        current_statement_begin__ = 359;
                        stan::model::assign(b1, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    ((1 - get_base1(mu, i, "mu", 1)) * (((get_base1(mu, i, "mu", 1) * (1 - get_base1(mu, i, "mu", 1))) / get_base1(disp, i, "disp", 1)) - 1)), 
                                    "assigning variable b1");
                        current_statement_begin__ = 360;
                        stan::model::assign(a1, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (get_base1(mu, i, "mu", 1) * (((get_base1(mu, i, "mu", 1) * (1 - get_base1(mu, i, "mu", 1))) / get_base1(disp, i, "disp", 1)) - 1)), 
                                    "assigning variable a1");
                    } else {
                        current_statement_begin__ = 362;
                        stan::model::assign(b1, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    ((1 - get_base1(mu, i, "mu", 1)) * get_base1(disp, i, "disp", 1)), 
                                    "assigning variable b1");
                        current_statement_begin__ = 363;
                        stan::model::assign(a1, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (get_base1(mu, i, "mu", 1) * get_base1(disp, i, "disp", 1)), 
                                    "assigning variable a1");
                    }
                }
            } else if (as_bool(logical_eq(likelihood, 3))) {
                current_statement_begin__ = 379;
                for (int i = 1; i <= M_is; ++i) {
                    current_statement_begin__ = 380;
                    if (as_bool(logical_eq(intercept, 0))) {
                        current_statement_begin__ = 381;
                        stan::model::assign(mu, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    inv_logit((multiply(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X"), beta) + get_base1(reffs, i, "reffs", 1))), 
                                    "assigning variable mu");
                    } else {
                        current_statement_begin__ = 383;
                        stan::model::assign(mu, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    inv_logit(((get_base1(beta0, 1, "beta0", 1) + multiply(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X"), beta)) + get_base1(reffs, i, "reffs", 1))), 
                                    "assigning variable mu");
                    }
                    current_statement_begin__ = 385;
                    stan::model::assign(theta, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (get_base1(mu, i, "mu", 1) * (1 - pow((1 - get_base1(mu, i, "mu", 1)), get_base1(m_d, i, "m_d", 1)))), 
                                "assigning variable theta");
                    current_statement_begin__ = 386;
                    if (as_bool(logical_eq(deff, 0))) {
                        current_statement_begin__ = 387;
                        stan::model::assign(b1, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    ((1 - get_base1(mu, i, "mu", 1)) * (((get_base1(mu, i, "mu", 1) * (1 - get_base1(mu, i, "mu", 1))) / get_base1(disp, i, "disp", 1)) - 1)), 
                                    "assigning variable b1");
                        current_statement_begin__ = 388;
                        stan::model::assign(a1, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (get_base1(mu, i, "mu", 1) * (((get_base1(mu, i, "mu", 1) * (1 - get_base1(mu, i, "mu", 1))) / get_base1(disp, i, "disp", 1)) - 1)), 
                                    "assigning variable a1");
                    } else {
                        current_statement_begin__ = 390;
                        stan::model::assign(b1, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    ((1 - get_base1(mu, i, "mu", 1)) * get_base1(disp, i, "disp", 1)), 
                                    "assigning variable b1");
                        current_statement_begin__ = 391;
                        stan::model::assign(a1, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (get_base1(mu, i, "mu", 1) * get_base1(disp, i, "disp", 1)), 
                                    "assigning variable a1");
                    }
                }
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 123;
            check_greater_or_equal(function__, "tau", tau, 0);
            current_statement_begin__ = 124;
            check_greater_or_equal(function__, "c2", c2, 0);
            current_statement_begin__ = 125;
            check_greater_or_equal(function__, "lambda_tilde", lambda_tilde, 0);
            current_statement_begin__ = 128;
            check_greater_or_equal(function__, "theta", theta, 0);
            check_less_or_equal(function__, "theta", theta, 1);
            current_statement_begin__ = 132;
            check_greater_or_equal(function__, "b1", b1, 0);
            current_statement_begin__ = 133;
            check_greater_or_equal(function__, "a1", a1, 0);
            current_statement_begin__ = 134;
            check_greater_or_equal(function__, "mu", mu, 0);
            check_less_or_equal(function__, "mu", mu, 1);
            current_statement_begin__ = 137;
            check_greater_or_equal(function__, "phi", phi, 0);
            current_statement_begin__ = 138;
            check_greater_or_equal(function__, "lambda1", lambda1, 0);
            check_less_or_equal(function__, "lambda1", lambda1, 1);
            current_statement_begin__ = 139;
            check_greater_or_equal(function__, "lambda2", lambda2, 0);
            check_less_or_equal(function__, "lambda2", lambda2, 1);
            current_statement_begin__ = 140;
            check_greater_or_equal(function__, "b2", b2, 0);
            current_statement_begin__ = 141;
            check_greater_or_equal(function__, "a2", a2, 0);
            current_statement_begin__ = 144;
            check_greater_or_equal(function__, "p0", p0, 0);
            check_less_or_equal(function__, "p0", p0, 1);
            current_statement_begin__ = 145;
            check_greater_or_equal(function__, "p1", p1, 0);
            check_less_or_equal(function__, "p1", p1, 1);
            // write transformed parameters
            if (include_tparams__) {
                size_t beta_j_1_max__ = P;
                for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                    vars__.push_back(beta(j_1__));
                }
                size_t tau_j_1_max__ = (logical_eq(prior_coeff, 1) ? 1 : 0 );
                for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
                    vars__.push_back(tau(j_1__));
                }
                size_t c2_j_1_max__ = (logical_eq(prior_coeff, 1) ? 1 : 0 );
                for (size_t j_1__ = 0; j_1__ < c2_j_1_max__; ++j_1__) {
                    vars__.push_back(c2(j_1__));
                }
                size_t lambda_tilde_j_1_max__ = (logical_eq(prior_coeff, 1) ? P : 0 );
                for (size_t j_1__ = 0; j_1__ < lambda_tilde_j_1_max__; ++j_1__) {
                    vars__.push_back(lambda_tilde(j_1__));
                }
                size_t theta_j_1_max__ = M_is;
                for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                    vars__.push_back(theta(j_1__));
                }
                size_t b1_j_1_max__ = M_is;
                for (size_t j_1__ = 0; j_1__ < b1_j_1_max__; ++j_1__) {
                    vars__.push_back(b1(j_1__));
                }
                size_t a1_j_1_max__ = M_is;
                for (size_t j_1__ = 0; j_1__ < a1_j_1_max__; ++j_1__) {
                    vars__.push_back(a1(j_1__));
                }
                size_t mu_j_1_max__ = M_is;
                for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                    vars__.push_back(mu(j_1__));
                }
                size_t phi_j_1_max__ = (logical_eq(likelihood, 1) ? M_is : 0 );
                for (size_t j_1__ = 0; j_1__ < phi_j_1_max__; ++j_1__) {
                    vars__.push_back(phi(j_1__));
                }
                size_t lambda1_j_1_max__ = (logical_eq(likelihood, 1) ? M_is : 0 );
                for (size_t j_1__ = 0; j_1__ < lambda1_j_1_max__; ++j_1__) {
                    vars__.push_back(lambda1(j_1__));
                }
                size_t lambda2_j_1_max__ = (logical_eq(likelihood, 1) ? M_is : 0 );
                for (size_t j_1__ = 0; j_1__ < lambda2_j_1_max__; ++j_1__) {
                    vars__.push_back(lambda2(j_1__));
                }
                size_t b2_j_1_max__ = (logical_eq(likelihood, 1) ? M_is : 0 );
                for (size_t j_1__ = 0; j_1__ < b2_j_1_max__; ++j_1__) {
                    vars__.push_back(b2(j_1__));
                }
                size_t a2_j_1_max__ = (logical_eq(likelihood, 1) ? M_is : 0 );
                for (size_t j_1__ = 0; j_1__ < a2_j_1_max__; ++j_1__) {
                    vars__.push_back(a2(j_1__));
                }
                size_t p0_j_1_max__ = ((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 1))) ? M_is : 0 );
                for (size_t j_1__ = 0; j_1__ < p0_j_1_max__; ++j_1__) {
                    vars__.push_back(p0(j_1__));
                }
                size_t p1_j_1_max__ = ((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 0))) ? M_is : 0 );
                for (size_t j_1__ = 0; j_1__ < p1_j_1_max__; ++j_1__) {
                    vars__.push_back(p1(j_1__));
                }
                size_t v_j_1_max__ = length_v;
                for (size_t j_1__ = 0; j_1__ < v_j_1_max__; ++j_1__) {
                    vars__.push_back(v(j_1__));
                }
                size_t s_j_1_max__ = (logical_eq(spatial_err, 1) ? D : 0 );
                for (size_t j_1__ = 0; j_1__ < s_j_1_max__; ++j_1__) {
                    vars__.push_back(s(j_1__));
                }
                size_t t_j_2_max__ = (logical_eq(temporal_err, 1) ? TP : 0 );
                size_t t_j_1_max__ = (logical_eq(temporal_err, 1) ? D : 0 );
                for (size_t j_2__ = 0; j_2__ < t_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < t_j_1_max__; ++j_1__) {
                        vars__.push_back(t(j_1__, j_2__));
                    }
                }
                size_t reffs_j_1_max__ = M_is;
                for (size_t j_1__ = 0; j_1__ < reffs_j_1_max__; ++j_1__) {
                    vars__.push_back(reffs(j_1__));
                }
                size_t reffs_oos_j_1_max__ = M_oos;
                for (size_t j_1__ = 0; j_1__ < reffs_oos_j_1_max__; ++j_1__) {
                    vars__.push_back(reffs_oos(j_1__));
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 515;
            validate_non_negative_index("log_lik", "M_is", M_is);
            Eigen::Matrix<double, Eigen::Dynamic, 1> log_lik(M_is);
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik, DUMMY_VAR__);
            current_statement_begin__ = 516;
            validate_non_negative_index("y_rep", "M_is", M_is);
            Eigen::Matrix<double, Eigen::Dynamic, 1> y_rep(M_is);
            stan::math::initialize(y_rep, DUMMY_VAR__);
            stan::math::fill(y_rep, DUMMY_VAR__);
            current_statement_begin__ = 517;
            validate_non_negative_index("psi_OOS", "1", 1);
            std::vector<double> psi_OOS(1, double(0));
            stan::math::initialize(psi_OOS, DUMMY_VAR__);
            stan::math::fill(psi_OOS, DUMMY_VAR__);
            current_statement_begin__ = 518;
            validate_non_negative_index("v_oos", "1", 1);
            std::vector<double> v_oos(1, double(0));
            stan::math::initialize(v_oos, DUMMY_VAR__);
            stan::math::fill(v_oos, DUMMY_VAR__);
            current_statement_begin__ = 519;
            int label_mixt;
            (void) label_mixt;  // dummy to suppress unused var warning
            stan::math::fill(label_mixt, std::numeric_limits<int>::min());
            current_statement_begin__ = 520;
            validate_non_negative_index("probs", "(logical_eq(inflation, 2) ? 3 : 0 )", (logical_eq(inflation, 2) ? 3 : 0 ));
            Eigen::Matrix<double, Eigen::Dynamic, 1> probs((logical_eq(inflation, 2) ? 3 : 0 ));
            stan::math::initialize(probs, DUMMY_VAR__);
            stan::math::fill(probs, DUMMY_VAR__);
            current_statement_begin__ = 521;
            validate_non_negative_index("theta_oos", "(logical_neq(likelihood, 1) ? M_oos : 0 )", (logical_neq(likelihood, 1) ? M_oos : 0 ));
            Eigen::Matrix<double, Eigen::Dynamic, 1> theta_oos((logical_neq(likelihood, 1) ? M_oos : 0 ));
            stan::math::initialize(theta_oos, DUMMY_VAR__);
            stan::math::fill(theta_oos, DUMMY_VAR__);
            // generated quantities statements
            current_statement_begin__ = 525;
            if (as_bool(logical_eq(likelihood, 0))) {
                current_statement_begin__ = 526;
                for (int i = 1; i <= M_is; ++i) {
                    current_statement_begin__ = 527;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                beta_log(get_base1(y, i, "y", 1), get_base1(a1, i, "a1", 1), get_base1(b1, i, "b1", 1)), 
                                "assigning variable log_lik");
                    current_statement_begin__ = 528;
                    stan::model::assign(y_rep, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                beta_rng(get_base1(a1, i, "a1", 1), get_base1(b1, i, "b1", 1), base_rng__), 
                                "assigning variable y_rep");
                }
                current_statement_begin__ = 531;
                for (int i = 1; i <= M_oos; ++i) {
                    current_statement_begin__ = 532;
                    if (as_bool(logical_eq(temporal_err, 0))) {
                        current_statement_begin__ = 533;
                        if (as_bool(logical_eq(prior_reff, 0))) {
                            current_statement_begin__ = 534;
                            stan::model::assign(v_oos, 
                                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                                        normal_rng(0, get_base1(sigma_v, 1, "sigma_v", 1), base_rng__), 
                                        "assigning variable v_oos");
                        } else if (as_bool(logical_eq(prior_reff, 1))) {
                            current_statement_begin__ = 536;
                            stan::model::assign(v_oos, 
                                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                                        student_t_rng(get_base1(nu, 1, "nu", 1), 0, get_base1(sigma_v, 1, "sigma_v", 1), base_rng__), 
                                        "assigning variable v_oos");
                        } else if (as_bool(logical_eq(prior_reff, 2))) {
                            current_statement_begin__ = 538;
                            stan::model::assign(psi_OOS, 
                                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                                        gamma_rng(0.5, 1, base_rng__), 
                                        "assigning variable psi_OOS");
                            current_statement_begin__ = 539;
                            stan::model::assign(v_oos, 
                                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                                        normal_rng(0, (stan::math::sqrt(get_base1(psi_OOS, 1, "psi_OOS", 1)) * get_base1(lambda, 1, "lambda", 1)), base_rng__), 
                                        "assigning variable v_oos");
                        }
                    } else {
                        current_statement_begin__ = 542;
                        stan::model::assign(v_oos, 
                                    stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                                    0, 
                                    "assigning variable v_oos");
                    }
                    current_statement_begin__ = 544;
                    if (as_bool(logical_eq(intercept, 0))) {
                        current_statement_begin__ = 545;
                        stan::model::assign(theta_oos, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    inv_logit(((multiply(stan::model::rvalue(X_oos, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X_oos"), beta) + get_base1(reffs_oos, i, "reffs_oos", 1)) + get_base1(v_oos, 1, "v_oos", 1))), 
                                    "assigning variable theta_oos");
                    } else {
                        current_statement_begin__ = 547;
                        stan::model::assign(theta_oos, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    inv_logit((((get_base1(beta0, 1, "beta0", 1) + multiply(stan::model::rvalue(X_oos, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X_oos"), beta)) + get_base1(reffs_oos, i, "reffs_oos", 1)) + get_base1(v_oos, 1, "v_oos", 1))), 
                                    "assigning variable theta_oos");
                    }
                }
            } else if (as_bool(logical_eq(likelihood, 1))) {
                current_statement_begin__ = 551;
                for (int i = 1; i <= M_is; ++i) {
                    current_statement_begin__ = 552;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                log_mix(get_base1(p, 1, "p", 1), beta_log(get_base1(y, i, "y", 1), get_base1(a2, i, "a2", 1), get_base1(b2, i, "b2", 1)), beta_log(get_base1(y, i, "y", 1), get_base1(a1, i, "a1", 1), get_base1(b1, i, "b1", 1))), 
                                "assigning variable log_lik");
                    current_statement_begin__ = 554;
                    stan::math::assign(label_mixt, bernoulli_rng(get_base1(p, 1, "p", 1), base_rng__));
                    current_statement_begin__ = 555;
                    if (as_bool(logical_eq(label_mixt, 1))) {
                        current_statement_begin__ = 556;
                        stan::model::assign(y_rep, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    beta_rng(get_base1(a2, i, "a2", 1), get_base1(b2, i, "b2", 1), base_rng__), 
                                    "assigning variable y_rep");
                    } else {
                        current_statement_begin__ = 558;
                        stan::model::assign(y_rep, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    beta_rng(get_base1(a1, i, "a1", 1), get_base1(b1, i, "b1", 1), base_rng__), 
                                    "assigning variable y_rep");
                    }
                }
            } else if (as_bool(logical_eq(likelihood, 2))) {
                current_statement_begin__ = 562;
                for (int i = 1; i <= M_oos; ++i) {
                    current_statement_begin__ = 563;
                    if (as_bool(logical_eq(temporal_err, 0))) {
                        current_statement_begin__ = 564;
                        if (as_bool(logical_eq(prior_reff, 0))) {
                            current_statement_begin__ = 565;
                            stan::model::assign(v_oos, 
                                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                                        normal_rng(0, get_base1(sigma_v, 1, "sigma_v", 1), base_rng__), 
                                        "assigning variable v_oos");
                        } else if (as_bool(logical_eq(prior_reff, 1))) {
                            current_statement_begin__ = 567;
                            stan::model::assign(v_oos, 
                                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                                        student_t_rng(get_base1(nu, 1, "nu", 1), 0, get_base1(sigma_v, 1, "sigma_v", 1), base_rng__), 
                                        "assigning variable v_oos");
                        } else if (as_bool(logical_eq(prior_reff, 2))) {
                            current_statement_begin__ = 569;
                            stan::model::assign(psi_OOS, 
                                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                                        gamma_rng(0.5, 1, base_rng__), 
                                        "assigning variable psi_OOS");
                            current_statement_begin__ = 570;
                            stan::model::assign(v_oos, 
                                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                                        normal_rng(0, (stan::math::sqrt(get_base1(psi_OOS, 1, "psi_OOS", 1)) * get_base1(lambda, 1, "lambda", 1)), base_rng__), 
                                        "assigning variable v_oos");
                        }
                    } else {
                        current_statement_begin__ = 573;
                        stan::model::assign(v_oos, 
                                    stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                                    0, 
                                    "assigning variable v_oos");
                    }
                    current_statement_begin__ = 575;
                    if (as_bool(logical_eq(inflation, 0))) {
                        current_statement_begin__ = 576;
                        if (as_bool(logical_eq(intercept, 0))) {
                            current_statement_begin__ = 577;
                            stan::model::assign(theta_oos, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        ((1 - inv_logit(multiply(stan::model::rvalue(X_oos, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X_oos"), gamma_p0))) * inv_logit(((multiply(stan::model::rvalue(X_oos, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X_oos"), beta) + get_base1(reffs_oos, i, "reffs_oos", 1)) + get_base1(v_oos, 1, "v_oos", 1)))), 
                                        "assigning variable theta_oos");
                        } else {
                            current_statement_begin__ = 580;
                            stan::model::assign(theta_oos, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        ((1 - inv_logit((get_base1(gamma0_p0, 1, "gamma0_p0", 1) + multiply(stan::model::rvalue(X_oos, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X_oos"), gamma_p0)))) * inv_logit((((get_base1(beta0, 1, "beta0", 1) + multiply(stan::model::rvalue(X_oos, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X_oos"), beta)) + get_base1(reffs_oos, i, "reffs_oos", 1)) + get_base1(v_oos, 1, "v_oos", 1)))), 
                                        "assigning variable theta_oos");
                        }
                    } else if (as_bool(logical_eq(inflation, 1))) {
                        current_statement_begin__ = 584;
                        if (as_bool(logical_eq(intercept, 0))) {
                            current_statement_begin__ = 585;
                            stan::model::assign(theta_oos, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        (((1 - inv_logit(multiply(stan::model::rvalue(X_oos, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X_oos"), gamma_p1))) * inv_logit(((multiply(stan::model::rvalue(X_oos, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X_oos"), beta) + get_base1(reffs_oos, i, "reffs_oos", 1)) + get_base1(v_oos, 1, "v_oos", 1)))) + inv_logit(multiply(stan::model::rvalue(X_oos, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X_oos"), gamma_p1))), 
                                        "assigning variable theta_oos");
                        } else {
                            current_statement_begin__ = 589;
                            stan::model::assign(theta_oos, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        (((1 - inv_logit((get_base1(gamma0_p1, 1, "gamma0_p1", 1) + multiply(stan::model::rvalue(X_oos, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X_oos"), gamma_p1)))) * inv_logit((((get_base1(beta0, 1, "beta0", 1) + multiply(stan::model::rvalue(X_oos, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X_oos"), beta)) + get_base1(reffs_oos, i, "reffs_oos", 1)) + get_base1(v_oos, 1, "v_oos", 1)))) + inv_logit((get_base1(gamma0_p1, 1, "gamma0_p1", 1) + multiply(stan::model::rvalue(X_oos, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X_oos"), gamma_p1)))), 
                                        "assigning variable theta_oos");
                        }
                    } else if (as_bool(logical_eq(inflation, 2))) {
                        current_statement_begin__ = 594;
                        if (as_bool(logical_eq(intercept, 0))) {
                            current_statement_begin__ = 595;
                            stan::model::assign(theta_oos, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        ((((1 - inv_logit(multiply(stan::model::rvalue(X_oos, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X_oos"), gamma_p0))) - inv_logit(multiply(stan::model::rvalue(X_oos, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X_oos"), gamma_p1))) * inv_logit(((multiply(stan::model::rvalue(X_oos, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X_oos"), beta) + get_base1(reffs_oos, i, "reffs_oos", 1)) + get_base1(v_oos, 1, "v_oos", 1)))) + inv_logit(multiply(stan::model::rvalue(X_oos, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X_oos"), gamma_p1))), 
                                        "assigning variable theta_oos");
                        } else {
                            current_statement_begin__ = 599;
                            stan::model::assign(theta_oos, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        ((((1 - inv_logit((get_base1(gamma0_p0, 1, "gamma0_p0", 1) + multiply(stan::model::rvalue(X_oos, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X_oos"), gamma_p0)))) - inv_logit((get_base1(gamma0_p1, 1, "gamma0_p1", 1) + multiply(stan::model::rvalue(X_oos, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X_oos"), gamma_p1)))) * inv_logit((((get_base1(beta0, 1, "beta0", 1) + multiply(stan::model::rvalue(X_oos, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X_oos"), beta)) + get_base1(reffs_oos, i, "reffs_oos", 1)) + get_base1(v_oos, 1, "v_oos", 1)))) + inv_logit((get_base1(gamma0_p1, 1, "gamma0_p1", 1) + multiply(stan::model::rvalue(X_oos, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X_oos"), gamma_p1)))), 
                                        "assigning variable theta_oos");
                        }
                    }
                }
                current_statement_begin__ = 606;
                for (int i = 1; i <= M_is; ++i) {
                    current_statement_begin__ = 607;
                    if (as_bool((primitive_value(logical_eq(get_base1(y, i, "y", 1), 0)) && primitive_value(logical_neq(inflation, 1))))) {
                        current_statement_begin__ = 608;
                        stan::model::assign(log_lik, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    stan::math::log(get_base1(p0, i, "p0", 1)), 
                                    "assigning variable log_lik");
                    } else if (as_bool((primitive_value(logical_eq(get_base1(y, i, "y", 1), 1)) && primitive_value(logical_neq(inflation, 0))))) {
                        current_statement_begin__ = 610;
                        stan::model::assign(log_lik, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    stan::math::log(get_base1(p1, i, "p1", 1)), 
                                    "assigning variable log_lik");
                    } else {
                        current_statement_begin__ = 612;
                        if (as_bool(logical_eq(inflation, 0))) {
                            current_statement_begin__ = 613;
                            stan::model::assign(log_lik, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        (stan::math::log((1 - get_base1(p0, i, "p0", 1))) + beta_log(get_base1(y, i, "y", 1), get_base1(a1, i, "a1", 1), get_base1(b1, i, "b1", 1))), 
                                        "assigning variable log_lik");
                        } else if (as_bool(logical_eq(inflation, 1))) {
                            current_statement_begin__ = 615;
                            stan::model::assign(log_lik, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        (stan::math::log((1 - get_base1(p1, i, "p1", 1))) + beta_log(get_base1(y, i, "y", 1), get_base1(a1, i, "a1", 1), get_base1(b1, i, "b1", 1))), 
                                        "assigning variable log_lik");
                        } else if (as_bool(logical_eq(inflation, 2))) {
                            current_statement_begin__ = 617;
                            stan::model::assign(log_lik, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        (stan::math::log(((1 - get_base1(p0, i, "p0", 1)) - get_base1(p1, i, "p1", 1))) + beta_log(get_base1(y, i, "y", 1), get_base1(a1, i, "a1", 1), get_base1(b1, i, "b1", 1))), 
                                        "assigning variable log_lik");
                        }
                    }
                    current_statement_begin__ = 620;
                    if (as_bool(logical_eq(inflation, 0))) {
                        current_statement_begin__ = 621;
                        stan::math::assign(label_mixt, bernoulli_rng(get_base1(p0, i, "p0", 1), base_rng__));
                        current_statement_begin__ = 622;
                        if (as_bool(logical_eq(label_mixt, 1))) {
                            current_statement_begin__ = 623;
                            stan::model::assign(y_rep, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        0, 
                                        "assigning variable y_rep");
                        } else {
                            current_statement_begin__ = 625;
                            stan::model::assign(y_rep, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        beta_rng(get_base1(a1, i, "a1", 1), get_base1(b1, i, "b1", 1), base_rng__), 
                                        "assigning variable y_rep");
                        }
                    } else if (as_bool(logical_eq(inflation, 1))) {
                        current_statement_begin__ = 628;
                        stan::math::assign(label_mixt, bernoulli_rng(get_base1(p1, i, "p1", 1), base_rng__));
                        current_statement_begin__ = 629;
                        if (as_bool(logical_eq(label_mixt, 1))) {
                            current_statement_begin__ = 630;
                            stan::model::assign(y_rep, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        1, 
                                        "assigning variable y_rep");
                        } else {
                            current_statement_begin__ = 632;
                            stan::model::assign(y_rep, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        beta_rng(get_base1(a1, i, "a1", 1), get_base1(b1, i, "b1", 1), base_rng__), 
                                        "assigning variable y_rep");
                        }
                    } else if (as_bool(logical_eq(inflation, 2))) {
                        current_statement_begin__ = 635;
                        stan::model::assign(probs, 
                                    stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                                    get_base1(p0, i, "p0", 1), 
                                    "assigning variable probs");
                        current_statement_begin__ = 636;
                        stan::model::assign(probs, 
                                    stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list()), 
                                    ((1 - get_base1(p0, i, "p0", 1)) - get_base1(p1, i, "p1", 1)), 
                                    "assigning variable probs");
                        current_statement_begin__ = 637;
                        stan::model::assign(probs, 
                                    stan::model::cons_list(stan::model::index_uni(3), stan::model::nil_index_list()), 
                                    get_base1(p1, i, "p1", 1), 
                                    "assigning variable probs");
                        current_statement_begin__ = 638;
                        stan::math::assign(label_mixt, categorical_rng(probs, base_rng__));
                        current_statement_begin__ = 639;
                        if (as_bool(logical_eq(label_mixt, 1))) {
                            current_statement_begin__ = 640;
                            stan::model::assign(y_rep, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        0, 
                                        "assigning variable y_rep");
                        } else if (as_bool(logical_eq(label_mixt, 2))) {
                            current_statement_begin__ = 642;
                            stan::model::assign(y_rep, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        beta_rng(get_base1(a1, i, "a1", 1), get_base1(b1, i, "b1", 1), base_rng__), 
                                        "assigning variable y_rep");
                        } else if (as_bool(logical_eq(label_mixt, 3))) {
                            current_statement_begin__ = 644;
                            stan::model::assign(y_rep, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        1, 
                                        "assigning variable y_rep");
                        }
                    }
                }
            } else if (as_bool(logical_eq(likelihood, 3))) {
                current_statement_begin__ = 649;
                for (int i = 1; i <= M_oos; ++i) {
                    current_statement_begin__ = 650;
                    if (as_bool(logical_eq(temporal_err, 0))) {
                        current_statement_begin__ = 651;
                        if (as_bool(logical_eq(prior_reff, 0))) {
                            current_statement_begin__ = 652;
                            stan::model::assign(v_oos, 
                                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                                        normal_rng(0, get_base1(sigma_v, 1, "sigma_v", 1), base_rng__), 
                                        "assigning variable v_oos");
                        } else if (as_bool(logical_eq(prior_reff, 1))) {
                            current_statement_begin__ = 654;
                            stan::model::assign(v_oos, 
                                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                                        student_t_rng(get_base1(nu, 1, "nu", 1), 0, get_base1(sigma_v, 1, "sigma_v", 1), base_rng__), 
                                        "assigning variable v_oos");
                        } else if (as_bool(logical_eq(prior_reff, 2))) {
                            current_statement_begin__ = 656;
                            stan::model::assign(psi_OOS, 
                                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                                        gamma_rng(0.5, 1, base_rng__), 
                                        "assigning variable psi_OOS");
                            current_statement_begin__ = 657;
                            stan::model::assign(v_oos, 
                                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                                        normal_rng(0, (stan::math::sqrt(get_base1(psi_OOS, 1, "psi_OOS", 1)) * get_base1(lambda, 1, "lambda", 1)), base_rng__), 
                                        "assigning variable v_oos");
                        }
                    } else {
                        current_statement_begin__ = 660;
                        stan::model::assign(v_oos, 
                                    stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                                    0, 
                                    "assigning variable v_oos");
                    }
                    current_statement_begin__ = 662;
                    if (as_bool(logical_eq(intercept, 0))) {
                        current_statement_begin__ = 663;
                        stan::model::assign(theta_oos, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    inv_logit(((multiply(stan::model::rvalue(X_oos, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X_oos"), beta) + get_base1(reffs_oos, i, "reffs_oos", 1)) + get_base1(v_oos, 1, "v_oos", 1))), 
                                    "assigning variable theta_oos");
                    } else {
                        current_statement_begin__ = 665;
                        stan::model::assign(theta_oos, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    inv_logit((((get_base1(beta0, 1, "beta0", 1) + multiply(stan::model::rvalue(X_oos, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X_oos"), beta)) + get_base1(reffs_oos, i, "reffs_oos", 1)) + get_base1(v_oos, 1, "v_oos", 1))), 
                                    "assigning variable theta_oos");
                    }
                }
                current_statement_begin__ = 668;
                for (int i = 1; i <= M_is; ++i) {
                    current_statement_begin__ = 669;
                    if (as_bool(logical_eq(get_base1(y, i, "y", 1), 0))) {
                        current_statement_begin__ = 670;
                        stan::model::assign(log_lik, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (get_base1(m_d, i, "m_d", 1) * stan::math::log((1 - get_base1(mu, i, "mu", 1)))), 
                                    "assigning variable log_lik");
                    } else {
                        current_statement_begin__ = 672;
                        stan::model::assign(log_lik, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (stan::math::log((1 - pow((1 - get_base1(mu, i, "mu", 1)), get_base1(m_d, i, "m_d", 1)))) + beta_log(get_base1(y, i, "y", 1), get_base1(a1, i, "a1", 1), get_base1(b1, i, "b1", 1))), 
                                    "assigning variable log_lik");
                    }
                    current_statement_begin__ = 674;
                    stan::model::assign(y_rep, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                beta_rng(get_base1(a1, i, "a1", 1), get_base1(b1, i, "b1", 1), base_rng__), 
                                "assigning variable y_rep");
                }
                current_statement_begin__ = 676;
                for (int i = 1; i <= M_is; ++i) {
                    current_statement_begin__ = 677;
                    stan::math::assign(label_mixt, bernoulli_rng(pow((1 - get_base1(mu, i, "mu", 1)), get_base1(m_d, i, "m_d", 1)), base_rng__));
                    current_statement_begin__ = 678;
                    if (as_bool(logical_eq(label_mixt, 1))) {
                        current_statement_begin__ = 679;
                        stan::model::assign(y_rep, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    0.0, 
                                    "assigning variable y_rep");
                    } else {
                        current_statement_begin__ = 681;
                        stan::model::assign(y_rep, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    beta_rng(get_base1(a1, i, "a1", 1), get_base1(b1, i, "b1", 1), base_rng__), 
                                    "assigning variable y_rep");
                    }
                }
            }
            // validate, write generated quantities
            current_statement_begin__ = 515;
            size_t log_lik_j_1_max__ = M_is;
            for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
                vars__.push_back(log_lik(j_1__));
            }
            current_statement_begin__ = 516;
            size_t y_rep_j_1_max__ = M_is;
            for (size_t j_1__ = 0; j_1__ < y_rep_j_1_max__; ++j_1__) {
                vars__.push_back(y_rep(j_1__));
            }
            current_statement_begin__ = 517;
            size_t psi_OOS_k_0_max__ = 1;
            for (size_t k_0__ = 0; k_0__ < psi_OOS_k_0_max__; ++k_0__) {
                vars__.push_back(psi_OOS[k_0__]);
            }
            current_statement_begin__ = 518;
            size_t v_oos_k_0_max__ = 1;
            for (size_t k_0__ = 0; k_0__ < v_oos_k_0_max__; ++k_0__) {
                vars__.push_back(v_oos[k_0__]);
            }
            current_statement_begin__ = 519;
            vars__.push_back(label_mixt);
            current_statement_begin__ = 520;
            size_t probs_j_1_max__ = (logical_eq(inflation, 2) ? 3 : 0 );
            for (size_t j_1__ = 0; j_1__ < probs_j_1_max__; ++j_1__) {
                vars__.push_back(probs(j_1__));
            }
            current_statement_begin__ = 521;
            check_greater_or_equal(function__, "theta_oos", theta_oos, 0);
            check_less_or_equal(function__, "theta_oos", theta_oos, 1);
            size_t theta_oos_j_1_max__ = (logical_neq(likelihood, 1) ? M_oos : 0 );
            for (size_t j_1__ = 0; j_1__ < theta_oos_j_1_max__; ++j_1__) {
                vars__.push_back(theta_oos(j_1__));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_global";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t beta0_j_1_max__ = (logical_eq(intercept, 1) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < beta0_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta0" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t z_beta_j_1_max__ = P;
        for (size_t j_1__ = 0; j_1__ < z_beta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z_beta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t lambda_HS_j_1_max__ = (logical_eq(prior_coeff, 1) ? P : 0 );
        for (size_t j_1__ = 0; j_1__ < lambda_HS_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_HS" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t z_c2_j_1_max__ = (logical_eq(prior_coeff, 1) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < z_c2_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z_c2" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t z_tau_j_1_max__ = (logical_eq(prior_coeff, 1) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < z_tau_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z_tau" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t v_raw_j_1_max__ = length_v;
        for (size_t j_1__ = 0; j_1__ < v_raw_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "v_raw" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sigma_v_j_1_max__ = ((primitive_value((primitive_value(logical_eq(prior_reff, 0)) || primitive_value(logical_eq(prior_reff, 1)))) && primitive_value(logical_eq(spatio_temporal, 0))) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < sigma_v_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_v" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t nu_j_1_max__ = ((primitive_value(logical_eq(prior_reff, 1)) && primitive_value(logical_eq(spatio_temporal, 0))) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < nu_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nu" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t psi_d_j_1_max__ = ((primitive_value(logical_eq(prior_reff, 2)) && primitive_value(logical_eq(spatio_temporal, 0))) ? length_v : 0 );
        for (size_t j_1__ = 0; j_1__ < psi_d_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi_d" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t lambda_j_1_max__ = ((primitive_value(logical_eq(prior_reff, 2)) && primitive_value(logical_eq(spatio_temporal, 0))) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < lambda_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t s_raw_j_1_max__ = (logical_eq(spatial_err, 1) ? D : 0 );
        for (size_t j_1__ = 0; j_1__ < s_raw_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "s_raw" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sigma_s_j_1_max__ = (logical_eq(spatial_err, 1) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < sigma_s_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_s" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t t_raw_j_2_max__ = (logical_eq(temporal_err, 1) ? TP : 0 );
        size_t t_raw_j_1_max__ = (logical_eq(temporal_err, 1) ? D : 0 );
        for (size_t j_2__ = 0; j_2__ < t_raw_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < t_raw_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "t_raw" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t sigma_t_j_1_max__ = (logical_eq(temporal_err, 1) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < sigma_t_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_t" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t w_j_1_max__ = (logical_eq(likelihood, 1) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < w_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "w" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t p_j_1_max__ = (logical_eq(likelihood, 1) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < p_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t gamma_p0_j_1_max__ = ((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 1))) ? P : 0 );
        for (size_t j_1__ = 0; j_1__ < gamma_p0_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma_p0" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t gamma_p1_j_1_max__ = ((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 0))) ? P : 0 );
        for (size_t j_1__ = 0; j_1__ < gamma_p1_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma_p1" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t gamma0_p0_j_1_max__ = ((primitive_value((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 1)))) && primitive_value(logical_eq(intercept, 1))) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < gamma0_p0_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma0_p0" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t gamma0_p1_j_1_max__ = ((primitive_value((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 0)))) && primitive_value(logical_eq(intercept, 1))) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < gamma0_p1_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma0_p1" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t beta_j_1_max__ = P;
            for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t tau_j_1_max__ = (logical_eq(prior_coeff, 1) ? 1 : 0 );
            for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "tau" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t c2_j_1_max__ = (logical_eq(prior_coeff, 1) ? 1 : 0 );
            for (size_t j_1__ = 0; j_1__ < c2_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "c2" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t lambda_tilde_j_1_max__ = (logical_eq(prior_coeff, 1) ? P : 0 );
            for (size_t j_1__ = 0; j_1__ < lambda_tilde_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambda_tilde" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t theta_j_1_max__ = M_is;
            for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t b1_j_1_max__ = M_is;
            for (size_t j_1__ = 0; j_1__ < b1_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "b1" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t a1_j_1_max__ = M_is;
            for (size_t j_1__ = 0; j_1__ < a1_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "a1" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t mu_j_1_max__ = M_is;
            for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t phi_j_1_max__ = (logical_eq(likelihood, 1) ? M_is : 0 );
            for (size_t j_1__ = 0; j_1__ < phi_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "phi" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t lambda1_j_1_max__ = (logical_eq(likelihood, 1) ? M_is : 0 );
            for (size_t j_1__ = 0; j_1__ < lambda1_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambda1" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t lambda2_j_1_max__ = (logical_eq(likelihood, 1) ? M_is : 0 );
            for (size_t j_1__ = 0; j_1__ < lambda2_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambda2" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t b2_j_1_max__ = (logical_eq(likelihood, 1) ? M_is : 0 );
            for (size_t j_1__ = 0; j_1__ < b2_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "b2" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t a2_j_1_max__ = (logical_eq(likelihood, 1) ? M_is : 0 );
            for (size_t j_1__ = 0; j_1__ < a2_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "a2" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t p0_j_1_max__ = ((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 1))) ? M_is : 0 );
            for (size_t j_1__ = 0; j_1__ < p0_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "p0" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t p1_j_1_max__ = ((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 0))) ? M_is : 0 );
            for (size_t j_1__ = 0; j_1__ < p1_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "p1" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t v_j_1_max__ = length_v;
            for (size_t j_1__ = 0; j_1__ < v_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "v" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t s_j_1_max__ = (logical_eq(spatial_err, 1) ? D : 0 );
            for (size_t j_1__ = 0; j_1__ < s_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "s" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t t_j_2_max__ = (logical_eq(temporal_err, 1) ? TP : 0 );
            size_t t_j_1_max__ = (logical_eq(temporal_err, 1) ? D : 0 );
            for (size_t j_2__ = 0; j_2__ < t_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < t_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "t" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t reffs_j_1_max__ = M_is;
            for (size_t j_1__ = 0; j_1__ < reffs_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "reffs" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t reffs_oos_j_1_max__ = M_oos;
            for (size_t j_1__ = 0; j_1__ < reffs_oos_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "reffs_oos" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t log_lik_j_1_max__ = M_is;
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t y_rep_j_1_max__ = M_is;
        for (size_t j_1__ = 0; j_1__ < y_rep_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "y_rep" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t psi_OOS_k_0_max__ = 1;
        for (size_t k_0__ = 0; k_0__ < psi_OOS_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi_OOS" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t v_oos_k_0_max__ = 1;
        for (size_t k_0__ = 0; k_0__ < v_oos_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "v_oos" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "label_mixt";
        param_names__.push_back(param_name_stream__.str());
        size_t probs_j_1_max__ = (logical_eq(inflation, 2) ? 3 : 0 );
        for (size_t j_1__ = 0; j_1__ < probs_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "probs" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t theta_oos_j_1_max__ = (logical_neq(likelihood, 1) ? M_oos : 0 );
        for (size_t j_1__ = 0; j_1__ < theta_oos_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta_oos" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t beta0_j_1_max__ = (logical_eq(intercept, 1) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < beta0_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta0" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t z_beta_j_1_max__ = P;
        for (size_t j_1__ = 0; j_1__ < z_beta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z_beta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t lambda_HS_j_1_max__ = (logical_eq(prior_coeff, 1) ? P : 0 );
        for (size_t j_1__ = 0; j_1__ < lambda_HS_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_HS" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t z_c2_j_1_max__ = (logical_eq(prior_coeff, 1) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < z_c2_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z_c2" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t z_tau_j_1_max__ = (logical_eq(prior_coeff, 1) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < z_tau_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z_tau" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t v_raw_j_1_max__ = length_v;
        for (size_t j_1__ = 0; j_1__ < v_raw_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "v_raw" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sigma_v_j_1_max__ = ((primitive_value((primitive_value(logical_eq(prior_reff, 0)) || primitive_value(logical_eq(prior_reff, 1)))) && primitive_value(logical_eq(spatio_temporal, 0))) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < sigma_v_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_v" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t nu_j_1_max__ = ((primitive_value(logical_eq(prior_reff, 1)) && primitive_value(logical_eq(spatio_temporal, 0))) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < nu_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nu" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t psi_d_j_1_max__ = ((primitive_value(logical_eq(prior_reff, 2)) && primitive_value(logical_eq(spatio_temporal, 0))) ? length_v : 0 );
        for (size_t j_1__ = 0; j_1__ < psi_d_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi_d" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t lambda_j_1_max__ = ((primitive_value(logical_eq(prior_reff, 2)) && primitive_value(logical_eq(spatio_temporal, 0))) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < lambda_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t s_raw_j_1_max__ = (logical_eq(spatial_err, 1) ? D : 0 );
        for (size_t j_1__ = 0; j_1__ < s_raw_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "s_raw" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sigma_s_j_1_max__ = (logical_eq(spatial_err, 1) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < sigma_s_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_s" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t t_raw_j_2_max__ = (logical_eq(temporal_err, 1) ? TP : 0 );
        size_t t_raw_j_1_max__ = (logical_eq(temporal_err, 1) ? D : 0 );
        for (size_t j_2__ = 0; j_2__ < t_raw_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < t_raw_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "t_raw" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t sigma_t_j_1_max__ = (logical_eq(temporal_err, 1) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < sigma_t_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_t" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t w_j_1_max__ = (logical_eq(likelihood, 1) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < w_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "w" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t p_j_1_max__ = (logical_eq(likelihood, 1) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < p_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t gamma_p0_j_1_max__ = ((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 1))) ? P : 0 );
        for (size_t j_1__ = 0; j_1__ < gamma_p0_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma_p0" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t gamma_p1_j_1_max__ = ((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 0))) ? P : 0 );
        for (size_t j_1__ = 0; j_1__ < gamma_p1_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma_p1" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t gamma0_p0_j_1_max__ = ((primitive_value((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 1)))) && primitive_value(logical_eq(intercept, 1))) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < gamma0_p0_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma0_p0" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t gamma0_p1_j_1_max__ = ((primitive_value((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 0)))) && primitive_value(logical_eq(intercept, 1))) ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < gamma0_p1_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma0_p1" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t beta_j_1_max__ = P;
            for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t tau_j_1_max__ = (logical_eq(prior_coeff, 1) ? 1 : 0 );
            for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "tau" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t c2_j_1_max__ = (logical_eq(prior_coeff, 1) ? 1 : 0 );
            for (size_t j_1__ = 0; j_1__ < c2_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "c2" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t lambda_tilde_j_1_max__ = (logical_eq(prior_coeff, 1) ? P : 0 );
            for (size_t j_1__ = 0; j_1__ < lambda_tilde_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambda_tilde" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t theta_j_1_max__ = M_is;
            for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t b1_j_1_max__ = M_is;
            for (size_t j_1__ = 0; j_1__ < b1_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "b1" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t a1_j_1_max__ = M_is;
            for (size_t j_1__ = 0; j_1__ < a1_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "a1" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t mu_j_1_max__ = M_is;
            for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t phi_j_1_max__ = (logical_eq(likelihood, 1) ? M_is : 0 );
            for (size_t j_1__ = 0; j_1__ < phi_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "phi" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t lambda1_j_1_max__ = (logical_eq(likelihood, 1) ? M_is : 0 );
            for (size_t j_1__ = 0; j_1__ < lambda1_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambda1" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t lambda2_j_1_max__ = (logical_eq(likelihood, 1) ? M_is : 0 );
            for (size_t j_1__ = 0; j_1__ < lambda2_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambda2" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t b2_j_1_max__ = (logical_eq(likelihood, 1) ? M_is : 0 );
            for (size_t j_1__ = 0; j_1__ < b2_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "b2" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t a2_j_1_max__ = (logical_eq(likelihood, 1) ? M_is : 0 );
            for (size_t j_1__ = 0; j_1__ < a2_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "a2" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t p0_j_1_max__ = ((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 1))) ? M_is : 0 );
            for (size_t j_1__ = 0; j_1__ < p0_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "p0" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t p1_j_1_max__ = ((primitive_value(logical_eq(likelihood, 2)) && primitive_value(logical_neq(inflation, 0))) ? M_is : 0 );
            for (size_t j_1__ = 0; j_1__ < p1_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "p1" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t v_j_1_max__ = length_v;
            for (size_t j_1__ = 0; j_1__ < v_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "v" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t s_j_1_max__ = (logical_eq(spatial_err, 1) ? D : 0 );
            for (size_t j_1__ = 0; j_1__ < s_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "s" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t t_j_2_max__ = (logical_eq(temporal_err, 1) ? TP : 0 );
            size_t t_j_1_max__ = (logical_eq(temporal_err, 1) ? D : 0 );
            for (size_t j_2__ = 0; j_2__ < t_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < t_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "t" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t reffs_j_1_max__ = M_is;
            for (size_t j_1__ = 0; j_1__ < reffs_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "reffs" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t reffs_oos_j_1_max__ = M_oos;
            for (size_t j_1__ = 0; j_1__ < reffs_oos_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "reffs_oos" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t log_lik_j_1_max__ = M_is;
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t y_rep_j_1_max__ = M_is;
        for (size_t j_1__ = 0; j_1__ < y_rep_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "y_rep" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t psi_OOS_k_0_max__ = 1;
        for (size_t k_0__ = 0; k_0__ < psi_OOS_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi_OOS" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t v_oos_k_0_max__ = 1;
        for (size_t k_0__ = 0; k_0__ < v_oos_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "v_oos" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "label_mixt";
        param_names__.push_back(param_name_stream__.str());
        size_t probs_j_1_max__ = (logical_eq(inflation, 2) ? 3 : 0 );
        for (size_t j_1__ = 0; j_1__ < probs_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "probs" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t theta_oos_j_1_max__ = (logical_neq(likelihood, 1) ? M_oos : 0 );
        for (size_t j_1__ = 0; j_1__ < theta_oos_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta_oos" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
}; // model
}  // namespace
typedef model_global_namespace::model_global stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
