% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt.R
\name{tt}
\alias{tt}
\title{Draw a Tiny Table}
\usage{
tt(
  x,
  digits = NULL,
  caption = NULL,
  width = NULL,
  notes = NULL,
  theme = "default",
  placement = getOption("tinytable_tabularray_placement", default = NULL)
)
}
\arguments{
\item{x}{A data frame or data table to be rendered as a table.}

\item{digits}{Number of significant digits to keep for numeric variables. When \code{digits} is an integer, \code{tt()} calls \code{format_tt(x, digits = digits)} before proceeding to draw the table. Users who need more control can proceed in two steps: (1) format the data with \code{format_tt()} or other functions, and (2) pass the formatted data to \code{tt()} for drawing. See \code{?format_tt} for more details on formating options (ex: decimal, scientific notation, dates, boolean variables, etc.).}

\item{caption}{A string that will be used as the caption of the table.}

\item{width}{A numeric value between 0 and 1 indicating the proportion of the line width that the table should cover.}

\item{notes}{A single string or a (named) list of strings to append at the bottom of the table.}

\item{theme}{The theme to apply to the table.
\itemize{
\item LaTeX: "default", "striped", "void", or "grid".
\item HTML: "default", "striped", "void", "grid", or a (composite)
}}

\item{placement}{A string to control the position of tables in LaTeX. Will be inserted in square brackets like: \verb{\\\\begin\{table\}[H]}}
}
\value{
An object of class \code{tt} representing the table.
}
\description{
The \code{tt} function renders a table in different formats (HTML, Markdown, or LaTeX) with various styling options. The table can be customized with additional functions:
\itemize{
\item \code{style_tt()} to style fonts, colors, alignment, etc.
\item \code{format_tt()} to format numbers, dates, strings, etc.
\item \code{save_tt()} to save the table to a file or return the table as a string.
}

\code{tinytable} attempts to determine the appropriate way to print the table based on interactive use, RStudio availability, and output format in RMarkdown or Quarto documents. Users can call \code{print(x, output="markdown")} to print the table in a specific format. Alternatively, they can set a global option: \code{options("tinytable_print_output"="markdown")}
}
\section{LaTeX preamble}{


When rendering Quarto and Rmarkdown documents, \code{tinytable} will populate the LaTeX preamble automatically with all the required packages. For standalone LaTeX packages, these commands should be inserted in the preamble:

\if{html}{\out{<div class="sourceCode latex">}}\preformatted{\\usepackage\{tabularray\}
\\usepackage\{float\}
\\usepackage\{graphicx\}
\\usepackage\{codehigh\}
\\usepackage[normalem]\{ulem\}
\\UseTblrLibrary\{booktabs\}
\newcommand{\tinytableTabularrayUnderline}[1]\{\\underline\{#1\}\}
\newcommand{\tinytableTabularrayStrikeout}[1]\{\\sout\{#1\}\}
\\NewTableCommand\{\\tinytableDefineColor\}[3]\{\\definecolor\{#1\}\{#2\}\{#3\}\}
}\if{html}{\out{</div>}}
}

\examples{
library(tinytable)
x <- mtcars[1:4, 1:5]

tt(x)

tt(x,
   theme = "striped",
   width = 0.5,
   caption = "Data about cars.")

}
