% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str_subset_ops.R
\name{str_subset_ops}
\alias{str_subset_ops}
\alias{\%s><\%}
\alias{\%s<>\%}
\alias{\%sget\%}
\alias{\%strim\%}
\title{String Subsetting Operators}
\usage{
x \%s><\% ss

x \%s<>\% ss

x \%sget\% ss

x \%strim\% ss
}
\arguments{
\item{x}{a character vector.}

\item{ss}{a vector of length 2, or a matrix with 2 columns with \code{nrow(ss) == length(x)}.
The object \code{ss} should consist entirely of non-negative and non-missing integers,
or be coerce-able to such integers.
(thus negative integers, and missing values are not allowed; decimal numbers will be converted to integers). \cr
The first element/column of \code{ss}
gives the number of characters counting from the left side to be
extracted/removed from \code{x}. \cr
The second element/column of \code{ss}
gives the number of characters counting from the right side to be
extracted/removed from \code{x}. \cr}
}
\value{
Both operators return a character vector of the same length as \code{x}. \cr
\cr
The \code{x \%s><\% ss } operator
gives a certain number of the first and last characters of each string in the input
character vector \code{x}. \cr
\cr
The \code{x \%s<>\% ss } operator
removes a certain number of the first and last characters of each string in the input
character vector \code{x}. \cr
\cr
}
\description{
String subsetting operators. \cr
\cr
The \code{x \%s><\% ss } operator
gets a certain number of the first and last characters of every string in
character vector \code{x}. \cr
\code{\%sget\%} is an alias for \code{\%s><\%}. \cr
\cr
The \code{x \%s<>\% ss } operator
trims a certain number of the first and last characters of every string in
character vector \code{x}. \cr
\code{\%strim\%} is an alias for \code{\%<>\%}. \cr \cr
}
\details{
These operators serve as a way to provide straight-forward string sub-setting. \cr
\cr
}
\examples{


x <- c(paste0(letters[1:13], collapse = ""),
       paste0(letters[14:26], collapse = ""))
print(x)
ss <- c(2, 3)
x \%s><\% ss

x <- c(paste0(letters[1:13], collapse = ""),
       paste0(letters[14:26], collapse = ""))
print(x)
ss <- c(1, 0)
x \%s><\% ss

x <- c(paste0(letters[1:13], collapse = ""),
       paste0(letters[14:26], collapse = ""))
print(x)
ss <- c(2, 3)
x \%s<>\% ss

x <- c(paste0(letters[1:13], collapse = ""),
       paste0(letters[14:26], collapse = ""))
print(x)
ss <- c(1, 0)
x \%s<>\% ss
}
\seealso{
\link{tinycodet_strings}
}
