% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str_subset_ops.R
\name{str_subset_ops}
\alias{str_subset_ops}
\alias{\%sget\%}
\alias{\%strim\%}
\title{String Subsetting Operators}
\usage{
x \%sget\% ss

x \%strim\% ss
}
\arguments{
\item{x}{a character vector.}

\item{ss}{a vector of length 2, or a matrix with 2 columns with \code{nrow(ss)==length(x)}.
The object \code{ss} should consist entirely of non-negative and non-missing integers,
or be coerce-able to such integers.
(thus negative integers, and missing values are not allowed; decimal numbers will be converted to integers). \cr
The first element/column of \code{ss}
gives the number of characters counting from the left side to be
extracted/removed from \code{x}. \cr
The second element/column of \code{ss}
gives the number of characters counting from the right side to be
extracted/removed from \code{x}. \cr}
}
\value{
The \code{x \%sget\% ss } operator
gives a certain number of the first and last characters of
character vector \code{x}. \cr
\cr
The \code{x \%strim\% ss } operator
removes a certain number of the first and last characters of
character vector \code{x}. \cr
\cr
}
\description{
String subsetting operators. \cr
\cr
The \code{x \%sget\% ss } operator
gets a certain number of the first and last characters of every string in
character vector \code{x}. \cr
\cr
The \code{x \%strim\% ss } operator
trims a certain number of the first and last characters of every string in
character vector \code{x}. \cr
\cr
}
\details{
These operators serve as a way to provide straight-forward string sub-setting. \cr
\cr
}
\examples{

x <- c(paste0(letters[1:13], collapse=""), paste0(letters[14:26], collapse=""))
print(x)
ss <- c(2,3)
x \%sget\% ss

x <- c(paste0(letters[1:13], collapse=""), paste0(letters[14:26], collapse=""))
print(x)
ss <- c(1,0)
x \%sget\% ss

x <- c(paste0(letters[1:13], collapse=""), paste0(letters[14:26], collapse=""))
print(x)
ss <- c(2,3)
x \%strim\% ss

x <- c(paste0(letters[1:13], collapse=""), paste0(letters[14:26], collapse=""))
print(x)
ss <- c(1,0)
x \%strim\% ss







}
\seealso{
\code{\link[=tinycodet_strings]{tinycodet_strings()}}
}
