% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4_multi_deg.R
\name{multi_deg}
\alias{multi_deg}
\title{multi_deg}
\usage{
multi_deg(
  exp,
  group_list,
  ids,
  logFC_cutoff = 1,
  pvalue_cutoff = 0.05,
  adjust = FALSE,
  species = "human",
  entriz = TRUE
)
}
\arguments{
\item{exp}{A numeric matrix}

\item{group_list}{A factor with duplicated character or factor}

\item{ids}{a data.frame with 2 columns,including probe_id and symbol}

\item{logFC_cutoff}{Cutoff value of logFC,1 by default.}

\item{pvalue_cutoff}{Cutoff value of pvalue,0.05 by default.}

\item{adjust}{a logical value, would you like to use adjusted pvalue to draw this plot,FAlSE by default.}

\item{species}{choose human or mouse, or rat, default: human}

\item{entriz}{whether convert symbols to entriz ids}
}
\value{
a deg data.frame with 10 columns
}
\description{
do diffiential analysis according to expression set and group information
}
\examples{
\dontrun{
if(requireNamespace("Biobase",quietly = TRUE)&
   requireNamespace("AnnoProbe",quietly = TRUE)){
  gse = "GSE474"
  geo = geo_download(gse,destdir=tempdir())
  geo$exp[1:4,1:4]
  geo$exp=log2(geo$exp+1)
  group_list=ifelse(stringr::str_detect(geo$pd$title,"MObese"),
  "MObese",ifelse(stringr::str_detect(geo$pd$title,"NonObese"),
  "NonObese","Obese"))
  group_list=factor(group_list,levels = c("NonObese","Obese","MObese"))
  find_anno(geo$gpl)
  ids <- AnnoProbe::idmap(geo$gpl,destdir = tempdir())
  deg = multi_deg(geo$exp,group_list,ids,adjust = FALSE,entriz = FALSE)
  names(deg)
  head(deg[[1]])
  head(deg[[2]])
  head(deg[[3]])
}else{
  if(!requireNamespace("AnnoProbe",quietly = TRUE)) {
    warning("Package 'AnnoProbe' needed for this function to work.
         Please install it by install.packages('AnnoProbe')",call. = FALSE)
  }
  if(!requireNamespace("Biobase",quietly = TRUE)) {
    warning("Package 'Biobase' needed for this function to work.
         Please install it by BiocManager::install('Biobase')",call. = FALSE)
  }
}
}
}
\seealso{
\code{\link{get_deg}};\code{\link{multi_deg_all}}
}
\author{
Xiaojie Sun
}
