% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anomalize.R
\name{anomalize}
\alias{anomalize}
\title{Automatic group-wise Anomaly Detection}
\usage{
anomalize(
  .data,
  .date_var,
  .value,
  .frequency = "auto",
  .trend = "auto",
  .method = "stl",
  .iqr_alpha = 0.05,
  .clean_alpha = 0.75,
  .max_anomalies = 0.2,
  .message = TRUE
)
}
\arguments{
\item{.data}{A \code{tibble} or \code{data.frame} with a time-based column}

\item{.date_var}{A column containing either date or date-time values}

\item{.value}{A column containing numeric values}

\item{.frequency}{Controls the seasonal adjustment (removal of seasonality).
Input can be either "auto", a time-based definition (e.g. "2 weeks"),
or a numeric number of observations per frequency (e.g. 10).
Refer to \code{\link[=tk_get_frequency]{tk_get_frequency()}}.}

\item{.trend}{Controls the trend component.
For STL, trend controls the sensitivity of the LOESS smoother, which is used to remove the remainder.
Refer to \code{\link[=tk_get_trend]{tk_get_trend()}}.}

\item{.method}{The outlier detection method. Default: "stl". Currently
"stl" is the only method. "twitter" is planned.}

\item{.iqr_alpha}{Controls the width of the "normal" range. Lower values are more conservative
while higher values are less prone to incorrectly classifying "normal" observations.}

\item{.clean_alpha}{Controls the threshold for cleaning
the outliers. The default is 0.75, which means that the anomalies will be
cleaned using the 0.75 * lower or upper bound of the recomposed time series,
depending on the direction of the anomaly.}

\item{.max_anomalies}{The maximum percent of anomalies permitted to be identified.}

\item{.message}{A boolean. If \code{TRUE}, will output information related to automatic frequency
and trend selection (if applicable).}
}
\value{
A \code{tibble} or \code{data.frame} with the following columns:
\itemize{
\item observed: original data
\item seasonal: seasonal component
\item seasadaj: seasonal adjusted
\item trend: trend component
\item remainder: residual component
\item anomaly: Yes/No flag for outlier detection
\item anomaly score: distance from centerline
\item anomaly direction: -1, 0, 1 inidicator for direction of the anomaly
\item recomposed_l1: lower level bound of recomposed time series
\item recomposed_l2: upper level bound of recomposed time series
\item observed_clean: original data with anomalies interpolated
}
}
\description{
\code{anomalize()} is used to detect anomalies in time series data,
either for a single time series or for multiple time series grouped by a specific column.
}
\details{
The \code{anomalize()} method for anomaly detection that implements a 2-step process to
detect outliers in time series.

\strong{Step 1: Detrend & Remove Seasonality using STL Decomposition}

The decomposition separates the "season" and "trend" components from the "observed" values
leaving the "remainder" for anomaly detection.

The user can control two parameters: frequency and trend.
\enumerate{
\item \code{.frequency}: Adjusts the "season" component that is removed from the "observed" values.
\item \code{.trend}: Adjusts the trend window (t.window parameter from \code{\link[stats:stl]{stats::stl()}} that is used.
}

The user may supply both \code{.frequency} and \code{.trend} as time-based durations (e.g. "6 weeks") or
numeric values (e.g. 180) or "auto", which predetermines the frequency and/or trend based on
the scale of the time series using the \code{\link[=tk_time_scale_template]{tk_time_scale_template()}}.

\strong{Step 2: Anomaly Detection}

Once "trend" and "season" (seasonality) is removed, anomaly detection is performed on the "remainder".
Anomalies are identified, and boundaries (recomposed_l1 and recomposed_l2) are determined.

The Anomaly Detection Method uses an inner quartile range (IQR) of +/-25 the median.

\emph{IQR Adjustment, alpha parameter}

With the default \code{alpha = 0.05}, the limits are established by expanding
the 25/75 baseline by an IQR Factor of 3 (3X).
The \emph{IQR Factor = 0.15 / alpha} (hence 3X with alpha = 0.05):
\itemize{
\item To increase the IQR Factor controlling the limits, decrease the alpha,
which makes it more difficult to be an outlier.
\item Increase alpha to make it easier to be an outlier.
\item The IQR outlier detection method is used in \code{forecast::tsoutliers()}.
\item A similar outlier detection method is used by Twitter's \code{AnomalyDetection} package.
\item Both Twitter and Forecast tsoutliers methods have been implemented in Business Science's \code{anomalize}
package.
}
}
\examples{
library(dplyr)

walmart_sales_weekly \%>\%
    filter(id \%in\% c("1_1", "1_3")) \%>\%
    group_by(id) \%>\%
    anomalize(Date, Weekly_Sales)

}
\references{
\enumerate{
\item CLEVELAND, R. B., CLEVELAND, W. S., MCRAE, J. E., AND TERPENNING, I.
STL: A Seasonal-Trend Decomposition Procedure Based on Loess.
Journal of Official Statistics, Vol. 6, No. 1 (1990), pp. 3-73.
\item Owen S. Vallis, Jordan Hochenbaum and Arun Kejariwal (2014).
A Novel Technique for Long-Term Anomaly Detection in the Cloud. Twitter Inc.
}
}
