% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.param.timedeppar.R
\name{get.param}
\alias{get.param}
\title{Extract parameter list and process parameter vectors from an object of type \code{timedeppar}}
\usage{
get.param(x, ind.sample)
}
\arguments{
\item{x}{results from the function \code{\link{infer.timedeppar}} of class \code{timedeppar}.}

\item{ind.sample}{index of the stored (potentially thinned) Markov chain defining which parameters 
to reconstruct.
Default is to extract the parameters corresponding to the maximum posterior 
solution.}
}
\value{
list with the following elements:\cr
        \code{param}: list of constant and time-dependent model parameters,\cr
        \code{param.ou.estim}: vector of estimated process parameters of all time-dependent parameters,\cr
        \code{param.ou.fixed}: vector of fixed process parameters of all time-dependent parameters,\cr
        \code{param.ou}: matrix of Ornstein-Uhlenbeck parameters for all time-dependent parameters;
        columns are mean, sd and gamma of the processes, rows are the time-dependent parameter(s).\cr
        \code{logpdf}: corresponding lopdf values (posterior, intermediate densities, and priors),\cr
        \code{ind.timedeppar}: indices of \code{param} at which parameters are time-dependent.\cr
        \code{ind.sample}: sample index.\cr
        \code{ind.chain}: corresponding index of the Markov chain.\cr
}
\description{
This function extracts an element of the stored Markov chain from an object of type \code{timedeppar} 
produced by the function \code{\link{infer.timedeppar}} and converts it to a format that facilitates
re-evaluation of the posterior, evaluation of the underlying model, and sampling from the Ornstein-Uhlenbeck
process.
In particular, the constant and time-dependent parameters are provided in the same list format as supplied
as \code{param.ini} to the function \code{\link{infer.timedeppar}}.
In addition, the parameters of the Ornstein-Uhlenbeck process(es) of the time-dependent parameters are
provided in different formats (see details below under \code{Value}.
}
