% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poly5_logs_plot.R
\name{poly5_logs_plot}
\alias{poly5_logs_plot}
\title{Visualize the simulation of log cutting along the stem using a 5th degree polynomial that describes the tree taper.}
\usage{
poly5_logs_plot(
  dbh,
  h,
  coef,
  assortments,
  stump_height,
  downgrade,
  broken,
  defect_height,
  lang
)
}
\arguments{
\item{dbh}{tree diameter at breast height, in centimeters.}

\item{h}{total tree height, in meters.}

\item{coef}{numerical vector containing six coefficients of the 5th degree polynomial function that describes the tree's taper.}

\item{assortments}{a data.frame with five columns and n rows, where n is the number of different wood assortments to be obtained from the tree stem. The first column must contain the names of the assortments, the second, numerical, contains the minimum diameters at the small end of the logs, in centimeters. The third column, numerical, contains the minimum lengths of the logs, in meters. The fourth column, numerical, contains the maximum lengths of the logs, in meters. The fifth column, numerical, contains the values in centimeters referring to the loss of wood due to cutting logs. The algorithm prioritizes the extraction of assortments along the stem in the order presented in the data.frame, starting from the first line, to the last.}

\item{stump_height}{tree cutting height, in meters. Default is 0.}

\item{downgrade}{if TRUE, the algorithm,from the defect_height onwards, simulates log extraction only for the last assortment in the assortments data.frame. Default is FALSE.}

\item{broken}{if TRUE, the algorithm will simulate the extraction of logs only up to the defect_height. Default is FALSE.}

\item{defect_height}{the height, in meters, from which the logs will be downgraded (if downgrade is TRUE) or log extraction simulation will be stopped (if broken is TRUE). Default is h * 0.5.}

\item{lang}{language in which plot labels will be displayed. Current options are 'en' and 'pt-BR'. Default is 'en'.}
}
\value{
a ggplot object.
}
\description{
Plot the shape of the tree and visualize the extracted logs based on the tree measurements, assortments data.frame, and the 5th degree polynomial function that describes the tree's taper.
}
\details{
check the \code{poly5_logs} function help for more details.
}
\examples{

library(dplyr)
library(minpack.lm)
library(timbeR)

tree_scaling <- tree_scaling \%>\%
mutate(did = di/dbh,
       hih = hi/h)

poli5 <- lm(did~hih+I(hih^2)+I(hih^3)+I(hih^4)+I(hih^5),tree_scaling)

coef_poli <- coef(poli5)

dbh <- 25
h <- 20

assortments <- data.frame(
  NAME = c('15-25','4-15'),
  SED = c(15,4),
  MINLENGTH = c(2.65,2),
  MAXLENGTH = c(2.65,4.2),
  LOSS = c(5,5)
)

poly5_logs_plot(dbh, h, coef_poli, assortments)

}
