% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/national.R
\name{divisions}
\alias{divisions}
\title{Download a US Census divisions cartographic boundary shapefile into R}
\usage{
divisions(resolution = "500k", year = NULL, ...)
}
\arguments{
\item{resolution}{The resolution of the cartographic boundary file.
Defaults to '500k'; options include '5m' (1:5 million) and '20m' (1:20 million).}

\item{year}{the data year (defaults to 2015).}

\item{...}{arguments to be passed to the underlying `load_tiger` function, which is not exported.
Options include \code{refresh}, which specifies whether or not to re-download shapefiles
(defaults to \code{FALSE}).}
}
\description{
Download a US Census divisions cartographic boundary shapefile into R
}
\examples{
\dontrun{
library(tigris)
library(leaflet)

divs <- divisions(resolution = '20m')

leaflet(divs) \%>\%
   addTiles() \%>\%
   addPolygons()
}
}
\seealso{
Other national cartographic boundary functions: \code{\link{nation}},
  \code{\link{regions}}
}
