% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enumeration_units.R
\name{counties}
\alias{counties}
\title{Download a US Counties shapefile into R, and optionally subset by state}
\usage{
counties(state = NULL, cb = FALSE, resolution = "500k", year = NULL,
  ...)
}
\arguments{
\item{state}{The two-digit FIPS code (string) of the state you want, or a
vector of codes if you want multiple states. Can also be state name
or state abbreviation.}

\item{cb}{If cb is set to TRUE, download a generalized (1:500k)
counties file.  Defaults to FALSE (the most detailed TIGER file).}

\item{resolution}{The resolution of the cartographic boundary file (if cb == TRUE).
Defaults to '500k'; options include '5m' (1:5 million) and '20m' (1:20 million).}

\item{year}{the data year; defaults to 2015}

\item{...}{arguments to be passed to the underlying `load_tiger` function, which is not exported.
Options include \code{refresh}, which specifies whether or not to re-download shapefiles
(defaults to \code{FALSE}).}
}
\description{
Description from the US Census Bureau (see link for source):
The primary legal divisions of most states are termed counties. In Louisiana,
these divisions are known as parishes.  In Alaska, which has no counties,
the equivalent entities are the organized boroughs, city and boroughs,
municipalities, and census areas; the latter of which are delineated
cooperatively for statistical purposes by the state of Alaska and the
Census Bureau.  In four states (Maryland, Missouri, Nevada, and Virginia),
there are one or more incorporated places that are independent of any county
organization and thus constitute primary divisions of their states.  These
incorporated places are known as independent cities and are treated as
equivalent entities for purposes of data presentation.  The District of
Columbia and Guam have no primary divisions, and each area is considered
an equivalent entity for purposes of data presentation.  All of the counties
in Connecticut and Rhode Island and nine counties in Massachusetts were
dissolved as functioning governmental entities; however, the Census Bureau
continues to present data for these historical entities in order to provide
comparable geographic units at the county level of the geographic hierarchy
for these states and represents them as nonfunctioning legal entities in
data products.  The Census Bureau treats the following entities as
equivalents of counties for purposes of data presentation: municipios in
Puerto Rico, districts and islands in American Samoa, municipalities in the
Commonwealth of the Northern Mariana Islands, and islands in the U.S.
Virgin Islands.  Each county or statistically equivalent entity is assigned
a three-character numeric Federal Information Processing Series (FIPS) code
based on alphabetical sequence that is unique within state and an
eight-digit National Standard feature identifier.
}
\examples{
\dontrun{
library(tigris)
library(ggplot2)
library(ggthemes)

me <- counties("Maine", cb = TRUE)
me_map <- fortify(me)

gg <- ggplot()
gg <- gg + geom_map(data=me_map, map=me_map,
                    aes(x=long, y=lat, map_id=id),
                    color="black", fill="white", size=0.25)
gg <- gg + coord_map()
gg <- gg + theme_map()
gg
}
}
\seealso{
\url{https://www.census.gov/geo/reference/gtc/gtc_cou.html}

Other general area functions: \code{\link{block_groups}},
  \code{\link{blocks}}, \code{\link{county_subdivisions}},
  \code{\link{places}}, \code{\link{pumas}},
  \code{\link{school_districts}}, \code{\link{states}},
  \code{\link{tracts}}, \code{\link{zctas}}
}
