% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/national.R
\name{regions}
\alias{regions}
\title{Download a US regions cartographic boundary shapefile into R}
\usage{
regions(resolution = "500k")
}
\arguments{
\item{resolution}{The resolution of the cartographic boundary file.
       Defaults to '500k'; options include '5m' (1:5 million) and '20m' (1:20 million).}
}
\description{
Download a US regions cartographic boundary shapefile into R
}
\examples{
\dontrun{
library(tigris)
library(leaflet)

us_regions <- regions(resolution = '20m')

leaflet(us_regions) \%>\%
   addTiles() \%>\%
   addPolygons()
}
}
\seealso{
Other national cartographic boundary functions: \code{\link{divisions}};
  \code{\link{nation}}
}

