% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_label.R
\name{tw_label}
\alias{tw_label}
\title{Gets labels for all columns with names such as "id" and "property".}
\usage{
tw_label(
  df,
  value = TRUE,
  language = tidywikidatar::tw_get_language(),
  cache = NULL,
  overwrite_cache = FALSE,
  cache_connection = NULL,
  disconnect_db = TRUE,
  wait = 0
)
}
\arguments{
\item{df}{A data frame, typically generated with other \code{tidywikidatar}
functions such as \code{\link[=tw_get_property]{tw_get_property()}}.}

\item{value}{Logical, defaults to \code{TRUE}. If \code{TRUE}, it tries to get labels
for all supposed id in the column called value. May break if the columns
include some value which starts with Q and some digits, but is not a
Wikidata id.}

\item{language}{Defaults to language set with \code{\link[=tw_set_language]{tw_set_language()}}; if not
set, "en". Use "all_available" to keep all languages. For available
language values, see
\href{https://www.wikidata.org/wiki/Help:Wikimedia_language_codes/lists/all}{the
dedicated Wikimedia page}.}

\item{cache}{Defaults to \code{NULL}. If given, it should be given either \code{TRUE}
or \code{FALSE}. Typically set with \code{\link[=tw_enable_cache]{tw_enable_cache()}} or \code{\link[=tw_disable_cache]{tw_disable_cache()}}.}

\item{overwrite_cache}{Logical, defaults to \code{FALSE}. If \code{TRUE}, it overwrites
the table in the local sqlite database. Useful if the original Wikidata
object has been updated.}

\item{cache_connection}{Defaults to \code{NULL}. If \code{NULL}, and caching is
enabled, \code{tidywikidatar} will use a local sqlite database. A custom
connection to other databases can be given (see vignette \code{caching} for
details).}

\item{disconnect_db}{Defaults to \code{TRUE}. If \code{FALSE}, leaves the connection to
cache open.}

\item{wait}{In seconds, defaults to 0. Time to wait between queries to
Wikidata. If data are cached locally, wait time is not applied. If you are
running many queries systematically you may want to add some waiting time
between queries.}
}
\value{
A data frame, with the same shape as the input data frame, but with
labels instead of identifiers.
}
\description{
Gets labels for all columns with names such as "id" and "property".
}
\examples{
\donttest{
if (interactive()) {
  tw_get_qualifiers(id = "Q180099", p = "P26", language = "en") \%>\%
    head(2) \%>\%
    tw_label()
}
}
}
