% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_get.R
\name{tw_get_image}
\alias{tw_get_image}
\title{Get Wikidata image}
\usage{
tw_get_image(
  id,
  language = "all_available",
  cache = NULL,
  overwrite_cache = FALSE,
  format = "filename",
  wait = 0
)
}
\arguments{
\item{id}{A characther vector of length 1, must start with Q, e.g. "Q254" for Wolfgang Amadeus Mozart.}

\item{language}{Defaults to "all_available". It should be relevant only for caching purposes. For a full list of available values, see: https://www.wikidata.org/wiki/Help:Wikimedia_language_codes/lists/all}

\item{cache}{Defaults to NULL. If given, it should be given either TRUE or FALSE. Typically set with \code{tw_enable_cache()} or \code{tw_disable_cache()}.}

\item{overwrite_cache}{Logical, defaults to FALSE. If TRUE, it overwrites the table in the local sqlite database. Useful if the original Wikidata object has been updated.}

\item{format}{A charachter vector, defaults to 'filename". If set to 'commons', outputs the link to the Wikimedia Commons page. If set to "embed", outputs a link that can be used to embed.}

\item{wait}{In seconds, defaults to 0. Time to wait between queries to Wikidata. If data are cached locally, wait time is not applied. If you are running many queries systematically you may want to add some waiting time between queries.}
}
\value{
A charachter vector, corresponding to reference to the image in the requested format.
}
\description{
Get Wikidata image
}
\examples{
tw_get_image(
  c(
    "Q180099",
    "Q228822"
  ),
  format = "filename"
)

tw_get_image(
  c(
    "Q180099",
    "Q228822"
  ),
  format = "commons"
)
}
