% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stm_tidiers.R
\name{stm_tidiers}
\alias{stm_tidiers}
\alias{tidy.STM}
\alias{tidy.estimateEffect}
\alias{glance.estimateEffect}
\alias{augment.STM}
\alias{glance.STM}
\title{Tidiers for Structural Topic Models from the stm package}
\usage{
\method{tidy}{STM}(
  x,
  matrix = c("beta", "gamma", "theta", "frex", "lift"),
  log = FALSE,
  document_names = NULL,
  ...
)

\method{tidy}{estimateEffect}(x, ...)

\method{glance}{estimateEffect}(x, ...)

\method{augment}{STM}(x, data, ...)

\method{glance}{STM}(x, ...)
}
\arguments{
\item{x}{An STM fitted model object from either \code{\link[stm:stm]{stm::stm()}} or
\code{\link[stm:estimateEffect]{stm::estimateEffect()}}}

\item{matrix}{Which matrix to tidy:
\itemize{
\item the beta matrix (per-term-per-topic, default)
\item the gamma/theta matrix (per-document-per-topic); the stm package calls
this the theta matrix, but other topic modeling packages call this gamma
\item the FREX matrix, for words with high frequency and exclusivity
\item the lift matrix, for words with high lift
}}

\item{log}{Whether beta/gamma/theta should be on a log scale, default FALSE}

\item{document_names}{Optional vector of document names for use with
per-document-per-topic tidying}

\item{...}{Extra arguments for tidying, such as \code{w} as used in
\code{\link[stm:calcfrex]{stm::calcfrex()}}}

\item{data}{For \code{augment}, the data given to the stm function, either
as a \code{dfm} from quanteda or as a tidied table with "document" and
"term" columns}
}
\value{
\code{tidy} returns a tidied version of either the beta, gamma, FREX, or
lift matrix if called on an object from \code{\link[stm:stm]{stm::stm()}}, or a tidied version of
the estimated regressions if called on an object from \code{\link[stm:estimateEffect]{stm::estimateEffect()}}.

\code{glance} returns a tibble with exactly one row of model summaries.

\code{augment} must be provided a data argument, either a
\code{dfm} from quanteda or a table containing one row per original
document-term pair, such as is returned by \link{tdm_tidiers}, containing
columns \code{document} and \code{term}. It returns that same data with an additional
column \code{.topic} with the topic assignment for that document-term combination.
}
\description{
Tidy topic models fit by the stm package. The arguments and return values
are similar to \code{\link[=lda_tidiers]{lda_tidiers()}}.
}
\examples{
\dontshow{if (interactive() || identical(Sys.getenv("IN_PKGDOWN"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(dplyr)
library(ggplot2)
library(stm)
library(janeaustenr)

austen_sparse <- austen_books() \%>\%
    unnest_tokens(word, text) \%>\%
    anti_join(stop_words) \%>\%
    count(book, word) \%>\%
    cast_sparse(book, word, n)
topic_model <- stm(austen_sparse, K = 12, verbose = FALSE)

# tidy the word-topic combinations
td_beta <- tidy(topic_model)
td_beta

# Examine the topics
td_beta \%>\%
    group_by(topic) \%>\%
    slice_max(beta, n = 10) \%>\%
    ungroup() \%>\%
    ggplot(aes(beta, term)) +
    geom_col() +
    facet_wrap(~ topic, scales = "free")

# high FREX words per topic
tidy(topic_model, matrix = "frex")

# high lift words per topic
tidy(topic_model, matrix = "lift")

# tidy the document-topic combinations, with optional document names
td_gamma <- tidy(topic_model, matrix = "gamma",
                 document_names = rownames(austen_sparse))
td_gamma

# using stm's gardarianFit, we can tidy the result of a model
# estimated with covariates
effects <- estimateEffect(1:3 ~ treatment, gadarianFit, gadarian)
glance(effects)
td_estimate <- tidy(effects)
td_estimate
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=lda_tidiers]{lda_tidiers()}}, \code{\link[stm:calcfrex]{stm::calcfrex()}}, \code{\link[stm:calclift]{stm::calclift()}}
}
