% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.R
\name{select.}
\alias{select.}
\title{Select or drop columns}
\usage{
select.(.df, ...)
}
\arguments{
\item{.df}{A data.frame or data.table}

\item{...}{Columns to select or drop.
Use named arguments, e.g. new_name = old_name, to rename selected variables.
\code{tidyselect} compatible.}
}
\description{
Select or drop columns from a data.table
}
\examples{
df <- data.table(
  x1 = 1:3,
  x2 = 1:3,
  y = c("a", "b", "c"),
  z = c("a", "b", "c")
)

df \%>\%
  select.(x1, y)

df \%>\%
  select.(x1:y)

df \%>\%
  select.(-y, -z)

df \%>\%
  select.(starts_with("x"), z)

df \%>\%
  select.(where(is.character), x1)

df \%>\%
  select.(new = x1, y)
}
