% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize.R
\name{summarize.}
\alias{summarize.}
\alias{summarise.}
\title{Aggregate data using summary statistics}
\usage{
summarize.(.df, ..., .by = NULL, .sort = FALSE)

summarise.(.df, ..., .by = NULL, .sort = FALSE)
}
\arguments{
\item{.df}{A data.frame or data.table}

\item{...}{Aggregations to perform}

\item{.by}{Columns to group by.
\itemize{
\item A single column can be passed with \code{.by = d}.
\item Multiple columns can be passed with \code{.by = c(c, d)}
\item \code{tidyselect} can be used:
\itemize{
\item Single predicate: \code{.by = where(is.character)}
\item Multiple predicates: \code{.by = c(where(is.character), where(is.factor))}
\item A combination of predicates and column names: \code{.by = c(where(is.character), b)}
}
}}

\item{.sort}{\emph{experimental}: Should the resulting data.table be sorted by the grouping columns?}
}
\description{
Aggregate data using summary statistics such as mean or median. Can be calculated by group.
}
\examples{
df <- data.table(
  a = 1:3,
  b = 4:6,
  c = c("a", "a", "b"),
  d = c("a", "a", "b")
)

df \%>\%
  summarize.(avg_a = mean(a),
             max_b = max(b),
             .by = c)

df \%>\%
  summarize.(avg_a = mean(a),
             .by = c(c, d))
}
