% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_helpers.R
\name{starts_with.}
\alias{starts_with.}
\alias{dt_starts_with}
\alias{contains.}
\alias{dt_contains}
\alias{ends_with.}
\alias{dt_ends_with}
\alias{everything.}
\alias{dt_everything}
\alias{any_of.}
\alias{dt_any_of}
\title{Select helpers}
\usage{
starts_with.(match, ignore.case = TRUE, vars = peek_vars(fn = "starts_with"))

dt_starts_with(match, ignore.case = TRUE, vars = peek_vars(fn = "starts_with"))

contains.(match, ignore.case = TRUE, vars = peek_vars(fn = "contains"))

dt_contains(match, ignore.case = TRUE, vars = peek_vars(fn = "contains"))

ends_with.(match, ignore.case = TRUE, vars = peek_vars(fn = "ends_with"))

dt_ends_with(match, ignore.case = TRUE, vars = peek_vars(fn = "ends_with"))

everything.(vars = peek_vars(fn = "everything"))

dt_everything(vars = peek_vars(fn = "everything"))

any_of.(x, ..., vars = peek_vars(fn = "any_of"))

dt_any_of(x, ..., vars = peek_vars(fn = "any_of"))
}
\arguments{
\item{match}{A character vector. If length > 1, the union of the
matches is taken.}

\item{ignore.case}{If \code{TRUE}, the default, ignores case when matching
names.}

\item{vars}{A character vector of variable names. When called
from inside selecting functions like \code{\link[=select.]{select.()}} these are
automatically set to the names of the table.}

\item{x}{An index vector of names or locations.}

\item{...}{These dots are for future extensions and must be empty.}
}
\description{
Please note these functions are leftover from before \code{tidytable} used \code{tidyselect}.
You can/should use the normal \code{tidyselect} helpers.

These functions allow you to select variables based on their names.
\itemize{
\item \code{any_of.()}: Select using a character vector
\item \code{contains.()}: Contains a literal string or regex match
\item \code{everything.()}: Matches all variables
\item \code{starts_with.()}: Starts with a prefix
\item \code{ends_with.()}: Ends with a suffix
}
}
\examples{
test_df <- tidytable(
  x = 1,
  y = 2,
  double_x = 2,
  double_y = 4)

test_df \%>\%
  select.(starts_with("x"))

test_df \%>\%
  select.(ends_with("y"))
}
