% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_verbs.R
\name{dt_mutate}
\alias{dt_mutate}
\alias{dt_filter}
\alias{dt_arrange}
\alias{dt_summarize}
\alias{dt_summarise}
\alias{dt_select}
\title{\code{dplyr} verbs for data.table}
\usage{
dt_mutate(.data, ..., by = NULL)

dt_filter(.data, ...)

dt_arrange(.data, ...)

dt_summarize(.data, ..., by = NULL)

dt_summarise(.data, ..., by = NULL)

dt_select(.data, ...)
}
\arguments{
\item{.data}{A data.frame or data.table}

\item{...}{dots passed to underlying functions (see examples)}

\item{by}{\code{list()} of bare column names to group by}
}
\value{
A data.table
}
\description{
The core dplyr verbs can be used:
\itemize{
\item \code{dt_mutate()}
\item \code{dt_select()}
\item \code{dt_arrange()}
\item \code{dt_filter()}
\item \code{dt_summarize()}
}

\code{dt_select()} supports enhanced selection
}
\examples{
example_dt <- data.table::data.table(
  a = c(1,2,3),
  b = c(4,5,6),
  c = c("a","a","b"),
  d = c("a","a","b"))

example_dt \%>\%
  as_dt() \%>\%
  dt_select(a, b, c, d) \%>\%
  dt_mutate(double_a = a * 2,
            double_b = b * 2) \%>\%
  dt_filter(double_a > 0, double_b > 0) \%>\%
  dt_arrange(-double_a) \%>\%
  dt_summarize(avg_a = mean(a), by = list(c, d))
}
