% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidystringdist.R
\name{tidy_stringdist}
\alias{tidy_stringdist}
\title{Tidy stringdist calculation}
\usage{
tidy_stringdist(df, v1 = V1, v2 = V2, method = c("osa", "lv", "dl",
  "hamming", "lcs", "qgram", "cosine", "jaccard", "jw", "soundex"))
}
\arguments{
\item{df}{a dataframe containing the strings to compare}

\item{v1}{the name of the first columns}

\item{v2}{the name of the second columns}

\item{method}{one of the methods implemented in the stringdist package — "osa", "lv", "dl", "hamming", "lcs", "qgram", "cosine", "jaccard", "jw", "soundex". See \code{\link[stringdist]{stringdist-metrics}}}
}
\value{
a tibble with string distance
}
\description{
Tidy stringdist calculation
}
\examples{
proust <- tidy_comb_all(c("Albertine", "Françoise", "Gilberte", "Odette", "Charles"))
tidy_stringdist(proust, method= "jw")
}
