% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_stats_to_data_frame.R
\name{tidy_stats_to_data_frame}
\alias{tidy_stats_to_data_frame}
\title{Convert a tidystats list to a data frame}
\usage{
tidy_stats_to_data_frame(x)
}
\arguments{
\item{x}{A tidystats list.}
}
\description{
\code{\link[=tidy_stats_to_data_frame]{tidy_stats_to_data_frame()}} converts a tidystats list to a data frame,
which can then be used to extract specific statistics using standard
subsetting functions (e.g., \code{\link[dplyr:filter]{dplyr::filter()}}).
}
\examples{
# Conduct analyses
sleep_wide <- reshape(
  sleep,
  direction = "wide",
  idvar = "ID",
  timevar = "group",
  sep = "_"
)
sleep_test <- t.test(sleep_wide$extra_1, sleep_wide$extra_2, paired = TRUE)

ctl <- c(4.17, 5.58, 5.18, 6.11, 4.50, 4.61, 5.17, 4.53, 5.33, 5.14)
trt <- c(4.81, 4.17, 4.41, 3.59, 5.87, 3.83, 6.03, 4.89, 4.32, 4.69)
group <- gl(2, 10, 20, labels = c("Ctl", "Trt"))
weight <- c(ctl, trt)
lm_D9 <- lm(weight ~ group)

npk_aov <- aov(yield ~ block + N * P * K, npk)

# Create an empty list to store the statistics in
statistics <- list()

# Add statistics
statistics <- statistics |>
  add_stats(sleep_test, type = "primary", preregistered = TRUE) |>
  add_stats(lm_D9) |>
  add_stats(npk_aov, notes = "An ANOVA example")

# Convert the list to a data frame
df <- tidy_stats_to_data_frame(statistics)

# Select all the p-values
dplyr::filter(df, statistic_name == "p")

}
