% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_methods.R
\name{mutate}
\alias{mutate}
\title{Create, modify, and delete columns}
\usage{
mutate(.data, ...)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g. a tibble), or a
lazy data frame (e.g. from dbplyr or dtplyr). See *Methods*, below, for
more details.}

\item{...}{<[`tidy-eval`][dplyr_tidy_eval]> Name-value pairs.
  The name gives the name of the column in the output.

  The value can be:

  * A vector of length 1, which will be recycled to the correct length.
  * A vector the same length as the current group (or the whole data frame
    if ungrouped).
  * `NULL`, to remove the column.
  * A data frame or tibble, to create multiple columns in the output.}
}
\value{
An object of the same type as `.data`.

For `mutate()`:

* Rows are not affected.
* Existing columns will be preserved unless explicitly modified.
* New columns will be added to the right of existing columns.
* Columns given value `NULL` will be removed
* Groups will be recomputed if a grouping variable is mutated.
* Data frame attributes are preserved.

For `transmute()`:

* Rows are not affected.
* Apart from grouping variables, existing columns will be remove unless
  explicitly kept.
* Column order matches order of expressions.
* Groups will be recomputed if a grouping variable is mutated.
* Data frame attributes are preserved.
}
\description{
`mutate()` adds new variables and preserves existing ones;
`transmute()` adds new variables and drops existing ones.
New variables overwrite existing variables of the same name.
Variables can be removed by setting their value to `NULL`.
}
\section{Useful mutate functions}{


* [`+`], [`-`], [log()], etc., for their usual mathematical meanings

* [lead()], [lag()]

* [dense_rank()], [min_rank()], [percent_rank()], [row_number()],
  [cume_dist()], [ntile()]

* [cumsum()], [cummean()], [cummin()], [cummax()], [cumany()], [cumall()]

* [na_if()], [coalesce()]

* [if_else()], [recode()], [case_when()]
}

\section{Grouped tibbles}{


Because mutating expressions are computed within groups, they may
yield different results on grouped tibbles. This will be the case
as soon as an aggregating, lagging, or ranking function is
involved. Compare this ungrouped mutate:

With the grouped equivalent:

The former normalises `mass` by the global average whereas the
latter normalises by the averages within gender levels.
}

\section{Methods}{

These function are **generic**s, which means that packages can provide
implementations (methods) for other classes. See the documentation of
individual methods for extra arguments and differences in behaviour.

Methods available in currently loaded packages:
}

\examples{
`\%>\%` = magrittr::`\%>\%`
pbmc_small \%>\% tidy \%>\% mutate(nFeature_RNA = 1)

}
\seealso{
Other single table verbs: 
\code{\link{arrange}()},
\code{\link{filter}()},
\code{\link{rename}()},
\code{\link{select}()},
\code{\link{slice}()},
\code{\link{summarise}()}
}
\concept{single table verbs}
