% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collect_metrics.R
\name{collect_metrics.simple_ensemble}
\alias{collect_metrics.simple_ensemble}
\alias{collect_metrics.repeat_ensemble}
\title{Obtain and format results produced by tuning functions for ensemble objects}
\usage{
\method{collect_metrics}{simple_ensemble}(x, ...)

\method{collect_metrics}{repeat_ensemble}(x, ...)
}
\arguments{
\item{x}{A \code{\link{simple_ensemble}} or \code{\link{repeat_ensemble}} object}

\item{...}{Not currently used.}
}
\value{
A tibble.
}
\description{
Return a tibble of performance metrics for all models.
}
\details{
When applied to a ensemble, the metrics that are returned do not contain the
actual tuning parameter columns and values (unlike when these collect
functions are run on other objects). The reason is that ensembles contain
different types of models or models with different tuning parameters.
}
\examples{
collect_metrics(lacerta_ensemble)
collect_metrics(lacerta_rep_ens)
}
\seealso{
\code{\link[tune:collect_predictions]{tune::collect_metrics()}}
}
