% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest.R
\name{nest}
\alias{nest}
\title{Nest repeated values in a list-variable.}
\usage{
nest(data, ..., .key = data)
}
\arguments{
\item{data}{A data frame.}

\item{...}{Specification of columns to nest. Use bare variable names.
Select all variables between x and z with \code{x:z}, exclude y with
\code{-y}. For more options, see the \link[dplyr]{select} documentation.}

\item{.key}{The name of the new column.}
}
\description{
There are many possible ways one could choose to nest columns inside a
data frame. \code{nest()} creates a list of data frames containing all
the nested variables: this seems to be the most useful form in practice.
}
\examples{
library(dplyr)
iris \%>\% nest(-Species)
chickwts \%>\% nest(weight)

if (require("gapminder")) {
  gapminder \%>\%
    group_by(country, continent) \%>\%
    nest()

  gapminder \%>\%
    nest(-country, -continent)
}
}
\seealso{
\code{\link{unnest}} for the inverse operation.

\code{\link{nest_}} for a version that uses regular evaluation
  and is suitable for programming with.
}

